/*
 * Decompiled with CFR 0.152.
 */
package soot.workstealing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Unit;
import soot.jimple.internal.JCaughtExceptionRef;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.internal.JThrowStmt;
import soot.jimple.internal.JTrap;
import soot.jimple.internal.JimpleLocal;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WstExceptionInjector {
    private SootClass wstRuntimeExceptionClass = Scene.v().getSootClass("hj.runtime.wst.adaptive.UnCatchableWorkerException");
    private int counter = 0;

    public static boolean needExceptionInjection(Body b) {
        return b.getTraps().size() > 0;
    }

    public void injectWstException(Body methodBody) {
        Chain<Trap> trapsList = methodBody.getTraps();
        List<Trap> tryCatchList = this.identifyTryCatch(trapsList);
        Iterator<Trap> iterator = tryCatchList.iterator();
        while (iterator.hasNext()) {
            this.insertWstExceptionCatchBlock(methodBody, iterator.next());
        }
    }

    private void insertWstExceptionCatchBlock(Body methodBody, Trap tryCatchTrap) {
        HashChain<Unit> newStmts = new HashChain<Unit>();
        HashChain<Local> newLocals = new HashChain<Local>();
        Unit wstHandler = this.createWstHandlerStmt(newStmts, newLocals);
        Unit firstCatchBlockStmt = tryCatchTrap.getHandlerUnit();
        this.insertWstHandlerStmt(methodBody, firstCatchBlockStmt, newStmts, newLocals);
        Trap wstTrap = this.createWstExceptionTrap(tryCatchTrap.getBeginUnit(), tryCatchTrap.getEndUnit(), wstHandler);
        methodBody.getTraps().insertBefore(wstTrap, tryCatchTrap);
    }

    private void insertWstHandlerStmt(Body methodBody, Unit firstCatchBlockStmt, Chain<Unit> newStmts, Chain<Local> newLocals) {
        Unit pred = methodBody.getUnits().getPredOf(firstCatchBlockStmt);
        methodBody.getUnits().insertAfter(newStmts, pred);
        methodBody.getLocals().addAll(newLocals);
    }

    private Trap createWstExceptionTrap(Unit begin, Unit end, Unit handler) {
        SootClass exception = this.getWstRuntimeExceptionClass();
        JTrap wstTrap = new JTrap(exception, begin, end, handler);
        return wstTrap;
    }

    private Unit createWstHandlerStmt(Chain<Unit> newStmts, Chain<Local> newLocals) {
        JNopStmt handlerBegin = new JNopStmt();
        JimpleLocal idLocal = new JimpleLocal(this.getNewLocalName(), this.getWstRuntimeExceptionClass().getType());
        JCaughtExceptionRef idValue = new JCaughtExceptionRef();
        JIdentityStmt idStmt = new JIdentityStmt(idLocal, idValue);
        JThrowStmt throwStmt = new JThrowStmt(idLocal);
        newStmts.add(handlerBegin);
        newStmts.add(idStmt);
        newStmts.add(throwStmt);
        newLocals.add(idLocal);
        return handlerBegin;
    }

    private String getNewLocalName() {
        return "e_gen" + this.getCounter();
    }

    private int getCounter() {
        return this.counter++;
    }

    public List<Trap> identifyTryCatch(Chain<Trap> trapsList) {
        LinkedList<Unit> beginList = new LinkedList<Unit>();
        LinkedList<Trap> newTrapList = new LinkedList<Trap>();
        for (Trap trap : trapsList) {
            if (beginList.contains(trap.getBeginUnit())) continue;
            beginList.add(trap.getBeginUnit());
            newTrapList.add(trap);
        }
        return newTrapList;
    }

    private SootClass getWstRuntimeExceptionClass() {
        return this.wstRuntimeExceptionClass;
    }
}

