/*
 * Decompiled with CFR 0.152.
 */
package hj.parser;

import hj.parser.HjParserprs;
import hj.parser.HjParsersym;
import hj.parser.HjVarDeclarator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lpg.runtime.BacktrackingParser;
import lpg.runtime.BadParseException;
import lpg.runtime.BadParseSymFileException;
import lpg.runtime.DiagnoseParser;
import lpg.runtime.ErrorToken;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.Monitor;
import lpg.runtime.NotBacktrackParseTableException;
import lpg.runtime.NullExportedSymbolsException;
import lpg.runtime.NullTerminalSymbolsException;
import lpg.runtime.ParseTable;
import lpg.runtime.PrsStream;
import lpg.runtime.RuleAction;
import lpg.runtime.TokenStream;
import lpg.runtime.UndefinedEofSymbolException;
import lpg.runtime.UnimplementedTerminalsException;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Case;
import polyglot.ast.Catch;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.FlagsNode;
import polyglot.ast.FloatLit;
import polyglot.ast.ForInit;
import polyglot.ast.ForUpdate;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Import;
import polyglot.ast.IntLit;
import polyglot.ast.Lit;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.Receiver;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.SwitchElement;
import polyglot.ast.TopLevelDecl;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ext.hj.Configuration;
import polyglot.ext.hj.ast.AnnotationNode;
import polyglot.ext.hj.ast.AsyncClause;
import polyglot.ext.hj.ast.AsyncClauseList;
import polyglot.ext.hj.ast.ComplexOperation;
import polyglot.ext.hj.ast.ConstantDistMaker;
import polyglot.ext.hj.ast.FutureNode;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjFormal_c;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.ast.RegionMaker;
import polyglot.ext.hj.ast.Tuple;
import polyglot.ext.hj.ast.ValueClassDecl;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.BoundedTypeNode;
import polyglot.ext.jl5.ast.ParamTypeNode;
import polyglot.ext.jl5.types.FlagAnnotations;
import polyglot.frontend.FileSource;
import polyglot.frontend.Parser;
import polyglot.frontend.Source;
import polyglot.lex.BooleanLiteral;
import polyglot.lex.CharacterLiteral;
import polyglot.lex.DoubleLiteral;
import polyglot.lex.FloatLiteral;
import polyglot.lex.Identifier;
import polyglot.lex.LongLiteral;
import polyglot.lex.NullLiteral;
import polyglot.lex.Operator;
import polyglot.lex.StringLiteral;
import polyglot.lex.Token;
import polyglot.parse.ParsedName;
import polyglot.parse.VarDeclarator;
import polyglot.types.Flags;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;

public class HjParser
implements RuleAction,
Parser {
    private PrsStream prsStream = null;
    private boolean unimplementedSymbolsWarning = false;
    private static ParseTable prsTable = new HjParserprs();
    private BacktrackingParser btParser = null;
    private ErrorQueue eq;
    private HjTypeSystem ts;
    private HjNodeFactory nf;
    private FileSource source;
    private boolean unrecoverableSyntaxError = false;

    public ParseTable getParseTable() {
        return prsTable;
    }

    public BacktrackingParser getParser() {
        return this.btParser;
    }

    private void setResult(Object object) {
        this.btParser.setSym1(object);
    }

    public Object getRhsSym(int i) {
        return this.btParser.getSym(i);
    }

    public int getRhsTokenIndex(int i) {
        return this.btParser.getToken(i);
    }

    public IToken getRhsIToken(int i) {
        return this.prsStream.getIToken(this.getRhsTokenIndex(i));
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.btParser.getFirstToken(i);
    }

    public IToken getRhsFirstIToken(int i) {
        return this.prsStream.getIToken(this.getRhsFirstTokenIndex(i));
    }

    public int getRhsLastTokenIndex(int i) {
        return this.btParser.getLastToken(i);
    }

    public IToken getRhsLastIToken(int i) {
        return this.prsStream.getIToken(this.getRhsLastTokenIndex(i));
    }

    public int getLeftSpan() {
        return this.btParser.getFirstToken();
    }

    public IToken getLeftIToken() {
        return this.prsStream.getIToken(this.getLeftSpan());
    }

    public int getRightSpan() {
        return this.btParser.getLastToken();
    }

    public IToken getRightIToken() {
        return this.prsStream.getIToken(this.getRightSpan());
    }

    public int getRhsErrorTokenIndex(int i) {
        int index = this.btParser.getToken(i);
        IToken err = this.prsStream.getIToken(index);
        return err instanceof ErrorToken ? index : 0;
    }

    public ErrorToken getRhsErrorIToken(int i) {
        int index = this.btParser.getToken(i);
        IToken err = this.prsStream.getIToken(index);
        return (ErrorToken)(err instanceof ErrorToken ? err : null);
    }

    public void reset(ILexStream lexStream) {
        this.prsStream = new PrsStream(lexStream);
        this.btParser.reset((TokenStream)this.prsStream);
        try {
            this.prsStream.remapTerminalSymbols(this.orderedTerminalSymbols(), prsTable.getEoftSymbol());
        }
        catch (NullExportedSymbolsException e) {
        }
        catch (NullTerminalSymbolsException e) {
        }
        catch (UnimplementedTerminalsException e) {
            if (this.unimplementedSymbolsWarning) {
                ArrayList unimplemented_symbols = e.getSymbols();
                System.out.println("The Lexer will not scan the following token(s):");
                for (int i = 0; i < unimplemented_symbols.size(); ++i) {
                    Integer id = (Integer)unimplemented_symbols.get(i);
                    System.out.println("    " + HjParsersym.orderedTerminalSymbols[id]);
                }
                System.out.println();
            }
        }
        catch (UndefinedEofSymbolException e) {
            throw new Error(new UndefinedEofSymbolException("The Lexer does not implement the Eof symbol " + HjParsersym.orderedTerminalSymbols[prsTable.getEoftSymbol()]));
        }
    }

    public HjParser() {
        try {
            this.btParser = new BacktrackingParser((TokenStream)this.prsStream, prsTable, (RuleAction)this);
        }
        catch (NotBacktrackParseTableException e) {
            throw new Error(new NotBacktrackParseTableException("Regenerate HjParserprs.java with -BACKTRACK option"));
        }
        catch (BadParseSymFileException e) {
            throw new Error(new BadParseSymFileException("Bad Parser Symbol File -- HjParsersym.java"));
        }
    }

    public HjParser(ILexStream lexStream) {
        this();
        this.reset(lexStream);
    }

    public int numTokenKinds() {
        return HjParsersym.numTokenKinds;
    }

    public String[] orderedTerminalSymbols() {
        return HjParsersym.orderedTerminalSymbols;
    }

    public String getTokenKindName(int kind) {
        return HjParsersym.orderedTerminalSymbols[kind];
    }

    public int getEOFTokenKind() {
        return prsTable.getEoftSymbol();
    }

    public IPrsStream getIPrsStream() {
        return this.prsStream;
    }

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public PrsStream getParseStream() {
        return this.prsStream;
    }

    public Node parser() {
        return this.parser(null, 0);
    }

    public Node parser(Monitor monitor) {
        return this.parser(monitor, 0);
    }

    public Node parser(int error_repair_count) {
        return this.parser(null, error_repair_count);
    }

    public Node parser(Monitor monitor, int error_repair_count) {
        this.btParser.setMonitor(monitor);
        try {
            return (Node)this.btParser.fuzzyParse(error_repair_count);
        }
        catch (BadParseException e) {
            this.prsStream.reset(e.error_token);
            DiagnoseParser diagnoseParser = new DiagnoseParser((TokenStream)this.prsStream, prsTable);
            diagnoseParser.diagnose(e.error_token);
            return null;
        }
    }

    protected JPGPosition posForObject(Object o) {
        if (o instanceof Node) {
            return this.pos((Node)o);
        }
        if (o instanceof Token) {
            return this.pos((Token)o);
        }
        if (o instanceof Type) {
            return this.pos((Type)o);
        }
        if (o instanceof List) {
            return this.pos((List)o);
        }
        if (o instanceof VarDeclarator) {
            return this.pos((VarDeclarator)o);
        }
        return null;
    }

    public JPGPosition pos(Object first, Object last) {
        return this.pos(first, last, first);
    }

    public JPGPosition pos(Object first, Object last, Object noEndDefault) {
        JPGPosition fpos = this.posForObject(first);
        JPGPosition epos = this.posForObject(last);
        if (fpos != null && epos != null) {
            if (epos.endColumn() != -2) {
                return epos;
            }
            return this.posForObject(noEndDefault);
        }
        return null;
    }

    public JPGPosition pos(Token t) {
        if (t == null) {
            return null;
        }
        return (JPGPosition)t.getPosition();
    }

    public JPGPosition pos(Type n) {
        if (n == null) {
            return null;
        }
        return (JPGPosition)n.position();
    }

    public JPGPosition pos(List l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return this.pos(l.get(0), l.get(l.size() - 1));
    }

    public JPGPosition pos(Node n) {
        if (n == null) {
            return null;
        }
        return (JPGPosition)n.position();
    }

    public TypeNode array(TypeNode n, int dims) {
        if (dims > 0) {
            if (n instanceof CanonicalTypeNode) {
                Type t = ((CanonicalTypeNode)n).type();
                return this.nf.CanonicalTypeNode(this.pos((Node)n), this.ts.arrayOf(t, dims));
            }
            return this.nf.ArrayTypeNode(this.pos((Node)n), this.array(n, dims - 1));
        }
        return n;
    }

    public void tokenCheck(IToken left, IToken right) {
        String s = this.prsStream.toString(left, right);
        int left_index = left.getTokenIndex();
        int right_index = right.getTokenIndex();
        if (s.length() != right_index - left_index + 1) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Indivitual tokens merged to form \"" + s + "\"", (Position)this.pos(left_index, right_index));
        }
    }

    private long parseNumber(Position pos, String s, boolean is_long_number) {
        int start_index;
        int radix;
        int end_index;
        int n = end_index = s.charAt(s.length() - 1) == 'l' || s.charAt(s.length() - 1) == 'L' ? s.length() - 1 : s.length();
        if (s.charAt(0) == '0') {
            if (s.length() > 1 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                radix = 16;
                start_index = 2;
            } else {
                radix = 8;
                start_index = 0;
            }
        } else {
            radix = 10;
            start_index = 0;
        }
        return is_long_number ? this.parseLong(pos, s.substring(start_index, end_index), radix) : (long)this.parseInt(pos, s.substring(start_index, end_index), radix);
    }

    private long parseInt(Position pos, String s) {
        return this.parseNumber(pos, s, false);
    }

    private int parseInt(Position pos, String s, int radix) {
        BigInteger x;
        try {
            int bits;
            x = new BigInteger(s, radix);
            boolean boundary = radix == 10 && s.equals("2147483648");
            int n = bits = radix == 10 ? 31 : 32;
            if (x.bitLength() > bits && !boundary) {
                this.eq.enqueue(3, "Integer literal \"" + s + "\" out of range.", pos);
            }
        }
        catch (NumberFormatException e) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Integer literal \"" + s + "\" is out of range.", pos);
            return 0;
        }
        return x.intValue();
    }

    private long parseLong(Position pos, String s) {
        return this.parseNumber(pos, s, true);
    }

    private long parseLong(Position pos, String s, int radix) {
        BigInteger x;
        try {
            int bits;
            x = new BigInteger(s, radix);
            boolean boundary = radix == 10 && s.equals("9223372036854775808");
            int n = bits = radix == 10 ? 63 : 64;
            if (x.bitLength() > bits && !boundary) {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(3, "Long literal \"" + s + "\" out of range.", pos);
            }
        }
        catch (NumberFormatException e) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Integer literal \"" + s + "\" is out of range.", pos);
            return 0L;
        }
        return x.longValue();
    }

    private float parseFloat(Position pos, String s) {
        try {
            Float x = Float.valueOf(s);
            boolean zero = true;
            for (int i = 0; i < s.length(); ++i) {
                if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
                    zero = false;
                    break;
                }
                if (s.charAt(i) == 'e' || s.charAt(i) == 'E') break;
            }
            if (x.isInfinite() || x.isNaN() || x.floatValue() == 0.0f && !zero) {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(3, "Illegal float literal \"" + s + "\"", pos);
            }
            return x.floatValue();
        }
        catch (NumberFormatException e) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Illegal float literal \"" + s + "\"", pos);
            return 0.0f;
        }
    }

    private double parseDouble(Position pos, String s) {
        try {
            Double x = Double.valueOf(s);
            boolean zero = true;
            for (int i = 0; i < s.length(); ++i) {
                if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
                    zero = false;
                    break;
                }
                if (s.charAt(i) == 'e' || s.charAt(i) == 'E') break;
            }
            if (x.isInfinite() || x.isNaN() || x == 0.0 && !zero) {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(3, "Illegal double literal \"" + s + "\"", pos);
            }
            return x;
        }
        catch (NumberFormatException e) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Illegal double literal \"" + s + "\"", pos);
            return 0.0;
        }
    }

    private LongLiteral int_lit(Position pos, String s, int radix) {
        return new LongLiteral(pos, (long)this.parseInt(pos, s, radix), 63);
    }

    private LongLiteral int_lit(Position pos, String s) {
        return new LongLiteral(pos, this.parseInt(pos, s), 63);
    }

    private LongLiteral long_lit(Position pos, String s, int radix) {
        return new LongLiteral(pos, this.parseLong(pos, s, radix), 64);
    }

    private LongLiteral long_lit(Position pos, String s) {
        return new LongLiteral(pos, this.parseLong(pos, s), 64);
    }

    private FloatLiteral float_lit(Position pos, String s) {
        return new FloatLiteral(pos, this.parseFloat(pos, s), 65);
    }

    private DoubleLiteral double_lit(Position pos, String s) {
        return new DoubleLiteral(pos, this.parseDouble(pos, s), 66);
    }

    private CharacterLiteral char_lit(Position pos, String s) {
        char x;
        if (s.charAt(1) == '\\') {
            switch (s.charAt(2)) {
                case 'u': {
                    x = (char)this.parseInt(pos, s.substring(3, s.length() - 1), 16);
                    break;
                }
                case 'b': {
                    x = '\b';
                    break;
                }
                case 't': {
                    x = '\t';
                    break;
                }
                case 'n': {
                    x = '\n';
                    break;
                }
                case 'f': {
                    x = '\f';
                    break;
                }
                case 'r': {
                    x = '\r';
                    break;
                }
                case '\"': {
                    x = '\"';
                    break;
                }
                case '\'': {
                    x = '\'';
                    break;
                }
                case '\\': {
                    x = '\\';
                    break;
                }
                default: {
                    x = (char)this.parseInt(pos, s.substring(2, s.length() - 1), 8);
                    if (x > '\u00ff') {
                        this.unrecoverableSyntaxError = true;
                        this.eq.enqueue(3, "Illegal character literal " + s, pos);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            assert (s.length() == 3);
            x = s.charAt(1);
        }
        return new CharacterLiteral(pos, x, 67);
    }

    private BooleanLiteral boolean_lit(Position pos, boolean value, int kind) {
        return new BooleanLiteral(pos, value, kind);
    }

    private StringLiteral string_lit(Position pos, String s) {
        char[] x = new char[s.length()];
        int j = 1;
        int k = 0;
        block11: while (j < s.length() - 1) {
            if (s.charAt(j) != '\\') {
                x[k++] = s.charAt(j++);
                continue;
            }
            switch (s.charAt(j + 1)) {
                case 'u': {
                    x[k++] = (char)this.parseInt(pos, s.substring(j + 2, j + 6), 16);
                    j += 6;
                    continue block11;
                }
                case 'b': {
                    x[k++] = 8;
                    j += 2;
                    continue block11;
                }
                case 't': {
                    x[k++] = 9;
                    j += 2;
                    continue block11;
                }
                case 'n': {
                    x[k++] = 10;
                    j += 2;
                    continue block11;
                }
                case 'f': {
                    x[k++] = 12;
                    j += 2;
                    continue block11;
                }
                case 'r': {
                    x[k++] = 13;
                    j += 2;
                    continue block11;
                }
                case '\"': {
                    x[k++] = 34;
                    j += 2;
                    continue block11;
                }
                case '\'': {
                    x[k++] = 39;
                    j += 2;
                    continue block11;
                }
                case '\\': {
                    x[k++] = 92;
                    j += 2;
                    continue block11;
                }
            }
            int n = j + 1;
            for (int l = 0; l < 3 && Character.isDigit(s.charAt(n)); ++l) {
                ++n;
            }
            char c = (char)this.parseInt(pos, s.substring(j + 1, n), 8);
            if (c > '\u00ff') {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(3, "Illegal character (" + s.substring(j, n) + ") in string literal " + s, pos);
            }
            x[k++] = c;
            j = n;
        }
        return new StringLiteral(pos, new String(x, 0, k), 68);
    }

    public boolean isFlagsNode(Object o) {
        return o instanceof FlagsNode;
    }

    public List handleLocalDecl(FlagAnnotations fl, List list) {
        TypedList l = new TypedList(new LinkedList(), LocalDecl.class, false);
        LocalDecl dc = (LocalDecl)list.get(0);
        l.add(this.nf.LocalDecl(dc.position(), fl, dc.type(), dc.name(), dc.init()));
        return l;
    }

    public List variableDeclarators(TypeNode a, List b, FlagAnnotations flags) {
        TypedList l = new TypedList(new LinkedList(), LocalDecl.class, false);
        for (VarDeclarator d : b) {
            l.add(this.nf.LocalDecl(this.pos(d), flags, this.array(a, d.dims), d.name, d.init));
        }
        return l;
    }

    public List variableDeclarators(TypeNode a, VarDeclarator b, FlagAnnotations flags) {
        if (flags == null) {
            flags = new FlagAnnotations(this.nf.FlagsNode(Position.COMPILER_GENERATED, Flags.NONE), (List)new TypedList(new LinkedList(), AnnotationElem.class, false));
        }
        TypedList l = new TypedList(new LinkedList(), LocalDecl.class, false);
        l.add(this.nf.LocalDecl(this.pos(b), flags, this.array(a, b.dims), b.name, b.init));
        return l;
    }

    public BoundedTypeNode toSuperType(TypeNode a) {
        BoundedTypeNode tn = this.nf.BoundedTypeNode(a.position(), BoundedTypeNode.SUPER, a);
        return tn;
    }

    public BoundedTypeNode toExtendsType(TypeNode a) {
        BoundedTypeNode tn = this.nf.BoundedTypeNode(a.position(), BoundedTypeNode.EXTENDS, a);
        return tn;
    }

    public BoundedTypeNode toBoundedType(Position pos) {
        BoundedTypeNode tn = this.nf.BoundedTypeNode(pos, null, null);
        return tn;
    }

    public ParamTypeNode toParamType(Position pos, String id, List bounds) {
        if (bounds == null) {
            bounds = new TypedList(new LinkedList(), TypeNode.class, false);
        }
        ParamTypeNode tn = this.nf.ParamTypeNode(pos, bounds, id);
        return tn;
    }

    public void initialize(TypeSystem t, NodeFactory n, FileSource source, ErrorQueue q) {
        this.ts = (HjTypeSystem)t;
        this.nf = (HjNodeFactory)n;
        this.source = source;
        this.eq = q;
    }

    public HjParser(LexStream lexStream, TypeSystem t, NodeFactory n, FileSource source, ErrorQueue q) {
        this((ILexStream)lexStream);
        this.initialize((TypeSystem)((HjTypeSystem)t), (NodeFactory)((HjNodeFactory)n), source, q);
    }

    public String getErrorLocation(int lefttok, int righttok) {
        return this.prsStream.getFileName() + ':' + this.prsStream.getLine(lefttok) + ":" + this.prsStream.getColumn(lefttok) + ":" + this.prsStream.getEndLine(righttok) + ":" + this.prsStream.getEndColumn(righttok) + ": ";
    }

    public Position getErrorPosition(int lefttok, int righttok) {
        return new Position(null, this.prsStream.getFileName(), this.prsStream.getLine(lefttok), this.prsStream.getColumn(lefttok), this.prsStream.getEndLine(righttok), this.prsStream.getEndColumn(righttok));
    }

    public Node parse() {
        try {
            SourceFile sf = (SourceFile)this.parser();
            if (!this.unrecoverableSyntaxError && sf != null) {
                return sf.source((Source)this.source);
            }
            this.eq.enqueue(4, "Unable to parse " + this.source.name() + ".", new Position(null, this.file(), 1, 1, 1, 1));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.eq.enqueue(4, e.getMessage(), new Position(null, this.file(), 1, 1, 1, 1));
        }
        return null;
    }

    public String file() {
        return this.prsStream.getFileName();
    }

    public JPGPosition pos() {
        return new JPGPosition("", this.prsStream.getFileName(), this.prsStream.getIToken(this.getLeftSpan()), this.prsStream.getIToken(this.getRightSpan()));
    }

    public JPGPosition pos(int i) {
        return new JPGPosition("", this.prsStream.getFileName(), this.prsStream.getIToken(i), this.prsStream.getIToken(i));
    }

    public JPGPosition pos(int i, int j) {
        return new JPGPosition("", this.prsStream.getFileName(), this.prsStream.getIToken(i), this.prsStream.getIToken(j));
    }

    public JPGPosition pos(VarDeclarator n) {
        if (n == null) {
            return null;
        }
        return (JPGPosition)n.pos;
    }

    public JPGPosition pos(JPGPosition start, JPGPosition end) {
        return new JPGPosition(start.path(), start.file(), start.leftIToken, end.rightIToken);
    }

    private void checkTypeName(Id identifier) {
        String clean_filename;
        String filename = this.file();
        String idname = identifier.toString();
        int dot = filename.lastIndexOf(46);
        int slash = filename.lastIndexOf(47, dot);
        if (slash == -1) {
            slash = filename.lastIndexOf(92, dot);
        }
        String string = clean_filename = slash >= 0 && dot >= 0 ? filename.substring(slash + 1, dot) : "";
        if (!clean_filename.equals(idname) && clean_filename.equalsIgnoreCase(idname)) {
            this.eq.enqueue(4, "This type name does not match the name of the containing file: " + filename.substring(slash + 1), identifier.position());
        }
    }

    private Operator op(int i) {
        return new Operator((Position)this.pos(i), this.prsStream.getName(i), this.prsStream.getKind(i));
    }

    private Identifier id(int i) {
        return new Identifier((Position)this.pos(i), this.prsStream.getName(i), 35);
    }

    private String comment(int i) {
        String s = this.prsStream.getName(i);
        if (s != null && s.startsWith("/**") && s.endsWith("*/")) {
            return s + "\n";
        }
        return null;
    }

    private FlagsNode extractFlags(Position pos, List l) {
        HjFlags f = HjFlags.toHjFlags(Flags.NONE);
        for (Object o : l) {
            if (o instanceof HjFlags) {
                f = f.setX((HjFlags)((Object)o));
                continue;
            }
            if (!(o instanceof Flags)) continue;
            f = HjFlags.toHjFlags(f.set((Flags)o));
        }
        return this.nf.FlagsNode(pos, f);
    }

    private Expr makeInitializer(Position pos, TypeNode resultType, HjFormal f, Block body) {
        FlagsNode flags = this.nf.FlagsNode(pos, Flags.PUBLIC);
        TypeNode appResultType = resultType;
        if (!(resultType instanceof CanonicalTypeNode)) {
            appResultType = this.nf.TypeNodeFromQualifiedName(pos, QName.make((String)"hj.compilergenerated.Parameter1"));
        }
        TypedList l1 = new TypedList(new LinkedList(), HjFormal.class, false);
        l1.add(f);
        l1.add(this.nf.Formal(pos, new FlagAnnotations(this.nf.FlagsNode(pos, Flags.FINAL), null), appResultType, this.nf.Id(pos, "_")));
        MethodDecl decl = this.nf.MethodDecl(pos, flags, appResultType, this.nf.Id(pos, "apply"), (List)l1, new LinkedList(), body);
        TypeNode tOperatorPointwise = this.nf.TypeNodeFromQualifiedName(pos, QName.make((String)"hj.array.Operator.Pointwise"));
        TypedList classDecl = new TypedList(new LinkedList(), MethodDecl.class, false);
        classDecl.add(decl);
        New initializer = this.nf.New(pos, tOperatorPointwise, new LinkedList(), this.nf.ClassBody(pos, (List)classDecl));
        return initializer;
    }

    private New XXmakeInitializer(Position pos, TypeNode resultType, HjFormal f, Block body) {
        FlagsNode flags = this.nf.FlagsNode(pos, Flags.PUBLIC);
        TypedList l1 = new TypedList(new LinkedList(), HjFormal.class, false);
        l1.add(f);
        MethodDecl decl = this.nf.MethodDecl(pos, new FlagAnnotations(flags, null), resultType, this.nf.Id(pos, "apply"), (List<Formal>)l1, new LinkedList<TypeNode>(), body);
        Expr tArray = this.nf.ExprFromQualifiedName(pos, QName.make((String)(resultType.toString() + "Array")));
        TypeNode tArrayPointwiseOp = this.nf.TypeNodeFromQualifiedName(pos, QName.make((String)(resultType.toString() + "Array.pointwiseOp")));
        TypedList classDecl = new TypedList(new LinkedList(), MethodDecl.class, false);
        classDecl.add(decl);
        New initializer = this.nf.New(pos, tArray, tArrayPointwiseOp, new LinkedList(), this.nf.ClassBody(pos, (List)classDecl));
        return initializer;
    }

    private long parseLong(String s, int radix) {
        long x = 0L;
        s = s.toLowerCase();
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            c = c < 48 || c > 57 ? c - 97 + 10 : (c -= 48);
            x *= (long)radix;
            x += (long)c;
        }
        return x;
    }

    private long parseLong(String s) {
        int start_index;
        int radix;
        int end_index;
        int n = end_index = s.charAt(s.length() - 1) == 'l' || s.charAt(s.length() - 1) == 'L' ? s.length() - 1 : s.length();
        if (s.charAt(0) == '0') {
            if (s.length() > 1 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                radix = 16;
                start_index = 2;
            } else {
                radix = 8;
                start_index = 0;
            }
        } else {
            radix = 10;
            start_index = 0;
        }
        return this.parseLong(s.substring(start_index, end_index), radix);
    }

    private LongLiteral int_lit(int i, int radix) {
        long x = this.parseLong(this.prsStream.getName(i), radix);
        return new LongLiteral((Position)this.pos(i), x, 63);
    }

    private LongLiteral int_lit(int i) {
        long x = this.parseLong(this.prsStream.getName(i));
        return new LongLiteral((Position)this.pos(i), x, 63);
    }

    private LongLiteral long_lit(int i, int radix) {
        long x = this.parseLong(this.prsStream.getName(i), radix);
        return new LongLiteral((Position)this.pos(i), x, 64);
    }

    private LongLiteral long_lit(int i) {
        long x = this.parseLong(this.prsStream.getName(i));
        return new LongLiteral((Position)this.pos(i), x, 64);
    }

    private FloatLiteral float_lit(int i) {
        try {
            String s = this.prsStream.getName(i);
            int end_index = s.charAt(s.length() - 1) == 'f' || s.charAt(s.length() - 1) == 'F' ? s.length() - 1 : s.length();
            float x = Float.parseFloat(s.substring(0, end_index));
            return new FloatLiteral((Position)this.pos(i), x, 65);
        }
        catch (NumberFormatException e) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Illegal float literal \"" + this.prsStream.getName(i) + "\"", (Position)this.pos(i));
            return null;
        }
    }

    private DoubleLiteral double_lit(int i) {
        try {
            String s = this.prsStream.getName(i);
            int end_index = s.charAt(s.length() - 1) == 'd' || s.charAt(s.length() - 1) == 'D' ? s.length() - 1 : s.length();
            double x = Double.parseDouble(s.substring(0, end_index));
            return new DoubleLiteral((Position)this.pos(i), x, 66);
        }
        catch (NumberFormatException e) {
            this.unrecoverableSyntaxError = true;
            this.eq.enqueue(3, "Illegal float literal \"" + this.prsStream.getName(i) + "\"", (Position)this.pos(i));
            return null;
        }
    }

    private CharacterLiteral char_lit(int i) {
        char x;
        String s = this.prsStream.getName(i);
        if (s.charAt(1) == '\\') {
            switch (s.charAt(2)) {
                case 'u': {
                    x = (char)this.parseLong(s.substring(3, s.length() - 1), 16);
                    break;
                }
                case 'b': {
                    x = '\b';
                    break;
                }
                case 't': {
                    x = '\t';
                    break;
                }
                case 'n': {
                    x = '\n';
                    break;
                }
                case 'f': {
                    x = '\f';
                    break;
                }
                case 'r': {
                    x = '\r';
                    break;
                }
                case '\"': {
                    x = '\"';
                    break;
                }
                case '\'': {
                    x = '\'';
                    break;
                }
                case '\\': {
                    x = '\\';
                    break;
                }
                default: {
                    x = (char)this.parseLong(s.substring(2, s.length() - 1), 8);
                    if (x > '\u00ff') {
                        this.unrecoverableSyntaxError = true;
                        this.eq.enqueue(3, "Illegal character literal " + s, (Position)this.pos(i));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            assert (s.length() == 3);
            x = s.charAt(1);
        }
        return new CharacterLiteral((Position)this.pos(i), x, 67);
    }

    private BooleanLiteral boolean_lit(int i) {
        return new BooleanLiteral((Position)this.pos(i), this.prsStream.getKind(i) == 72, this.prsStream.getKind(i));
    }

    private StringLiteral string_lit(int i) {
        String s = this.prsStream.getName(i);
        char[] x = new char[s.length()];
        int j = 1;
        int k = 0;
        block11: while (j < s.length() - 1) {
            if (s.charAt(j) != '\\') {
                x[k++] = s.charAt(j++);
                continue;
            }
            switch (s.charAt(j + 1)) {
                case 'u': {
                    x[k++] = (char)this.parseLong(s.substring(j + 2, j + 6), 16);
                    j += 6;
                    continue block11;
                }
                case 'b': {
                    x[k++] = 8;
                    j += 2;
                    continue block11;
                }
                case 't': {
                    x[k++] = 9;
                    j += 2;
                    continue block11;
                }
                case 'n': {
                    x[k++] = 10;
                    j += 2;
                    continue block11;
                }
                case 'f': {
                    x[k++] = 12;
                    j += 2;
                    continue block11;
                }
                case 'r': {
                    x[k++] = 13;
                    j += 2;
                    continue block11;
                }
                case '\"': {
                    x[k++] = 34;
                    j += 2;
                    continue block11;
                }
                case '\'': {
                    x[k++] = 39;
                    j += 2;
                    continue block11;
                }
                case '\\': {
                    x[k++] = 92;
                    j += 2;
                    continue block11;
                }
            }
            int n = j + 1;
            for (int l = 0; l < 3 && Character.isDigit(s.charAt(n)); ++l) {
                ++n;
            }
            char c = (char)this.parseLong(s.substring(j + 1, n), 8);
            if (c > '\u00ff') {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(3, "Illegal character (" + s.substring(j, n) + ") in string literal " + s, (Position)this.pos(i));
            }
            x[k++] = c;
            j = n;
        }
        return new StringLiteral((Position)this.pos(i), new String(x, 0, k), 68);
    }

    private NullLiteral null_lit(int i) {
        return new NullLiteral((Position)this.pos(i), 71);
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                ParsedName TypeName = (ParsedName)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), TypeName, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 2: {
                ParsedName PackageName = (ParsedName)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), PackageName, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 3: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), AmbiguousName, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 4: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), AmbiguousName, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 5: {
                ParsedName PackageOrTypeName = (ParsedName)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), PackageOrTypeName, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 6: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), AmbiguousName, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 7: {
                Expr Primary = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.Field(this.pos(), (Receiver)Primary, this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 8: {
                this.setResult(this.nf.Field(this.pos(this.getRightSpan()), (Receiver)this.nf.Super(this.pos(this.getLeftSpan())), this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 9: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                IToken sup = this.getRhsIToken(3);
                this.setResult(this.nf.Field(this.pos(this.getRightSpan()), (Receiver)this.nf.Super(this.pos(this.getRhsFirstTokenIndex(3)), ClassName.toType()), this.nf.Id(this.pos(this.getRightSpan()), "*")));
                break;
            }
            case 10: {
                Object MethodPrimaryPrefix = this.getRhsSym(1);
                List ArgumentListopt = (List)this.getRhsSym(3);
                Expr Primary = (Expr)((Object[])MethodPrimaryPrefix)[0];
                Identifier identifier = (Identifier)((Object[])MethodPrimaryPrefix)[1];
                this.setResult(this.nf.Call(this.pos(), (Receiver)Primary, this.nf.Id(this.pos(), identifier.getIdentifier()), ArgumentListopt));
                break;
            }
            case 11: {
                Identifier MethodSuperPrefix = (Identifier)this.getRhsSym(1);
                List ArgumentListopt = (List)this.getRhsSym(3);
                Identifier identifier = MethodSuperPrefix;
                this.setResult(this.nf.Call(this.pos(), (Receiver)this.nf.Super(this.pos(this.getLeftSpan())), this.nf.Id(this.pos(), identifier.getIdentifier()), ArgumentListopt));
                break;
            }
            case 12: {
                Object MethodClassNameSuperPrefix = this.getRhsSym(1);
                List ArgumentListopt = (List)this.getRhsSym(3);
                ParsedName ClassName = (ParsedName)((Object[])MethodClassNameSuperPrefix)[0];
                JPGPosition super_pos = (JPGPosition)((Object)((Object[])MethodClassNameSuperPrefix)[1]);
                Identifier identifier = (Identifier)((Object[])MethodClassNameSuperPrefix)[2];
                this.setResult(this.nf.Call(this.pos(), (Receiver)this.nf.Super(super_pos, ClassName.toType()), this.nf.Id(this.pos(), identifier.getIdentifier()), ArgumentListopt));
                break;
            }
            case 13: {
                Expr Primary = (Expr)this.getRhsSym(1);
                IToken ErrorId = this.getRhsIToken(3);
                Object[] a = new Object[]{Primary, this.id(this.getRhsFirstTokenIndex(3))};
                this.setResult(a);
                break;
            }
            case 14: {
                IToken ErrorId = this.getRhsIToken(3);
                this.setResult(this.id(this.getRhsFirstTokenIndex(3)));
                break;
            }
            case 15: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                IToken sup = this.getRhsIToken(3);
                IToken ErrorId = this.getRhsIToken(5);
                Object[] a = new Object[]{ClassName, this.pos(this.getRhsFirstTokenIndex(3)), this.id(this.getRhsFirstTokenIndex(5))};
                this.setResult(a);
                break;
            }
            case 16: {
                IToken ident = this.getRhsIToken(1);
                ident.setKind(35);
                this.setResult(this.nf.Id(this.pos(), ident.toString()));
                break;
            }
            case 19: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Byte()));
                break;
            }
            case 20: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Char()));
                break;
            }
            case 21: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Short()));
                break;
            }
            case 22: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Int()));
                break;
            }
            case 23: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Long()));
                break;
            }
            case 24: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Float()));
                break;
            }
            case 25: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Double()));
                break;
            }
            case 26: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), (Type)this.ts.Complex32()));
                break;
            }
            case 27: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), (Type)this.ts.Complex64()));
                break;
            }
            case 30: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 31: {
                ParsedName TypeName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), TypeName, identifier));
                break;
            }
            case 34: {
                TypeNode Type2 = (TypeNode)this.getRhsSym(1);
                List Annotationsopt = (List)this.getRhsSym(3);
                this.setResult(this.nf.array(Type2, this.pos(), 1));
                break;
            }
            case 35: {
                Id TypeVariable2 = (Id)this.getRhsSym(1);
                List TypeBoundopt = (List)this.getRhsSym(2);
                this.setResult(this.toParamType(this.pos(), TypeVariable2.toString(), TypeBoundopt));
                break;
            }
            case 36: {
                TypeNode ClassOrInterfaceType = (TypeNode)this.getRhsSym(2);
                List AdditionalBoundListopt = (List)this.getRhsSym(3);
                if (AdditionalBoundListopt.size() == 0) {
                    AdditionalBoundListopt.add(ClassOrInterfaceType);
                } else {
                    AdditionalBoundListopt.add(0, ClassOrInterfaceType);
                }
                this.setResult(AdditionalBoundListopt);
                break;
            }
            case 37: {
                TypeNode AdditionalBound = (TypeNode)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), TypeNode.class, false);
                l.add(AdditionalBound);
                this.setResult(l);
                break;
            }
            case 38: {
                List AdditionalBoundList = (List)this.getRhsSym(1);
                TypeNode AdditionalBound = (TypeNode)this.getRhsSym(2);
                AdditionalBoundList.add(0, AdditionalBound);
                break;
            }
            case 39: {
                TypeNode InterfaceType = (TypeNode)this.getRhsSym(2);
                this.setResult(InterfaceType);
                break;
            }
            case 40: {
                List ActualTypeArgumentList = (List)this.getRhsSym(2);
                this.setResult(ActualTypeArgumentList);
                break;
            }
            case 41: {
                TypeNode ActualTypeArgument = (TypeNode)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), TypeNode.class, false);
                l.add(ActualTypeArgument);
                this.setResult(l);
                break;
            }
            case 42: {
                List ActualTypeArgumentList = (List)this.getRhsSym(1);
                TypeNode ActualTypeArgument = (TypeNode)this.getRhsSym(3);
                ActualTypeArgumentList.add(ActualTypeArgument);
                break;
            }
            case 45: {
                TypeNode WildcardBoundsopt = (TypeNode)this.getRhsSym(2);
                this.setResult(WildcardBoundsopt == null ? this.toBoundedType(null) : WildcardBoundsopt);
                break;
            }
            case 46: {
                TypeNode ReferenceType = (TypeNode)this.getRhsSym(2);
                this.setResult(this.toExtendsType(ReferenceType));
                break;
            }
            case 47: {
                TypeNode ReferenceType = (TypeNode)this.getRhsSym(2);
                this.setResult(this.toSuperType(ReferenceType));
                break;
            }
            case 48: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 49: {
                ParsedName PackageName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), PackageName, identifier));
                break;
            }
            case 50: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 51: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), AmbiguousName, identifier));
                break;
            }
            case 52: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 53: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), AmbiguousName, identifier));
                break;
            }
            case 54: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 55: {
                ParsedName PackageOrTypeName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), PackageOrTypeName, identifier));
                break;
            }
            case 56: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 57: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(this.getLeftSpan(), this.getRightSpan()), AmbiguousName, identifier));
                break;
            }
            case 58: {
                PackageNode PackageDeclarationopt = (PackageNode)this.getRhsSym(1);
                List ImportDeclarationsopt = (List)this.getRhsSym(2);
                List TypeDeclarationsopt = (List)this.getRhsSym(3);
                int token_pos = ImportDeclarationsopt.size() == 0 ? (TypeDeclarationsopt.size() == 0 ? this.prsStream.getSize() - 1 : this.prsStream.getPrevious(this.getRhsFirstTokenIndex(3))) : this.getRhsLastTokenIndex(2);
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.phaser")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.phaserMode")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.accumulator")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.PhaserException")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.place")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.dist")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.region")));
                ImportDeclarationsopt.add(this.nf.Import(this.pos(token_pos), Import.CLASS, QName.make((String)"hj.lang.point")));
                this.setResult(this.nf.SourceFile(this.pos(this.getLeftSpan(), this.getRightSpan()), PackageDeclarationopt, ImportDeclarationsopt, TypeDeclarationsopt));
                break;
            }
            case 59: {
                Import ImportDeclaration = (Import)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Import.class, false);
                l.add(ImportDeclaration);
                this.setResult(l);
                break;
            }
            case 60: {
                List ImportDeclarations = (List)this.getRhsSym(1);
                Import ImportDeclaration = (Import)this.getRhsSym(2);
                if (ImportDeclaration == null) break;
                ImportDeclarations.add(ImportDeclaration);
                break;
            }
            case 61: {
                ClassDecl TypeDeclaration = (ClassDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), TopLevelDecl.class, false);
                if (TypeDeclaration != null) {
                    l.add(TypeDeclaration);
                }
                this.setResult(l);
                break;
            }
            case 62: {
                List TypeDeclarations = (List)this.getRhsSym(1);
                ClassDecl TypeDeclaration = (ClassDecl)this.getRhsSym(2);
                if (TypeDeclaration == null) break;
                TypeDeclarations.add(TypeDeclaration);
                break;
            }
            case 65: {
                ParsedName TypeName = (ParsedName)this.getRhsSym(2);
                this.setResult(this.nf.Import(this.pos(this.getLeftSpan(), this.getRightSpan()), Import.CLASS, QName.make((String)TypeName.toString())));
                break;
            }
            case 66: {
                ParsedName PackageOrTypeName = (ParsedName)this.getRhsSym(2);
                this.setResult(this.nf.Import(this.pos(this.getLeftSpan(), this.getRightSpan()), Import.PACKAGE, QName.make((String)PackageOrTypeName.toString())));
                break;
            }
            case 69: {
                this.setResult(null);
                break;
            }
            case 71: {
                List ClassModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(ClassModifier);
                this.setResult(l);
                break;
            }
            case 72: {
                List ClassModifiers = (List)this.getRhsSym(1);
                List ClassModifier = (List)this.getRhsSym(2);
                ClassModifiers.addAll(ClassModifier);
                break;
            }
            case 73: {
                AnnotationNode Annotation2 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation2));
                break;
            }
            case 74: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 75: {
                this.setResult(Collections.singletonList(Flags.PROTECTED));
                break;
            }
            case 76: {
                this.setResult(Collections.singletonList(Flags.PRIVATE));
                break;
            }
            case 77: {
                this.setResult(Collections.singletonList(Flags.ABSTRACT));
                break;
            }
            case 78: {
                this.setResult(Collections.singletonList(Flags.STATIC));
                break;
            }
            case 79: {
                this.setResult(Collections.singletonList(Flags.FINAL));
                break;
            }
            case 80: {
                this.setResult(Collections.singletonList(Flags.STRICTFP));
                break;
            }
            case 81: {
                List TypeParameterList = (List)this.getRhsSym(2);
                this.setResult(TypeParameterList);
                break;
            }
            case 82: {
                TypeNode TypeParameter = (TypeNode)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), TypeNode.class, false);
                l.add(TypeParameter);
                this.setResult(l);
                break;
            }
            case 83: {
                List TypeParameterList = (List)this.getRhsSym(1);
                TypeNode TypeParameter = (TypeNode)this.getRhsSym(3);
                TypeParameterList.add(TypeParameter);
                break;
            }
            case 84: {
                TypeNode ClassType2 = (TypeNode)this.getRhsSym(2);
                this.setResult(ClassType2);
                break;
            }
            case 85: {
                List InterfaceTypeList = (List)this.getRhsSym(2);
                this.setResult(InterfaceTypeList);
                break;
            }
            case 86: {
                TypeNode InterfaceType = (TypeNode)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), TypeNode.class, false);
                l.add(InterfaceType);
                this.setResult(l);
                break;
            }
            case 87: {
                List InterfaceTypeList = (List)this.getRhsSym(1);
                TypeNode InterfaceType = (TypeNode)this.getRhsSym(3);
                InterfaceTypeList.add(InterfaceType);
                this.setResult(InterfaceTypeList);
                break;
            }
            case 88: {
                List ClassBodyDeclarationsopt = (List)this.getRhsSym(2);
                this.setResult(this.nf.ClassBody(this.pos(this.getLeftSpan(), this.getRightSpan()), ClassBodyDeclarationsopt));
                break;
            }
            case 90: {
                List ClassBodyDeclarations = (List)this.getRhsSym(1);
                List ClassBodyDeclaration = (List)this.getRhsSym(2);
                ClassBodyDeclarations.addAll(ClassBodyDeclaration);
                break;
            }
            case 92: {
                Block InstanceInitializer = (Block)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(this.nf.Initializer(this.pos(), this.nf.FlagsNode(this.pos(), Flags.NONE), InstanceInitializer));
                this.setResult(l);
                break;
            }
            case 93: {
                Block StaticInitializer = (Block)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(this.nf.Initializer(this.pos(), this.nf.FlagsNode(this.pos(), Flags.STATIC), StaticInitializer));
                this.setResult(l);
                break;
            }
            case 94: {
                ConstructorDecl ConstructorDeclaration = (ConstructorDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(ConstructorDeclaration);
                this.setResult(l);
                break;
            }
            case 96: {
                MethodDecl MethodDeclaration = (MethodDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(MethodDeclaration);
                this.setResult(l);
                break;
            }
            case 97: {
                ClassDecl ClassDeclaration = (ClassDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(ClassDeclaration);
                this.setResult(l);
                break;
            }
            case 98: {
                ClassDecl InterfaceDeclaration = (ClassDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(InterfaceDeclaration);
                this.setResult(l);
                break;
            }
            case 99: {
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                this.setResult(l);
                break;
            }
            case 100: {
                VarDeclarator VariableDeclarator = (VarDeclarator)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), HjVarDeclarator.class, false);
                l.add(VariableDeclarator);
                this.setResult(l);
                break;
            }
            case 101: {
                List VariableDeclarators = (List)this.getRhsSym(1);
                VarDeclarator VariableDeclarator = (VarDeclarator)this.getRhsSym(3);
                VariableDeclarators.add(VariableDeclarator);
                break;
            }
            case 103: {
                Expr VariableInitializer;
                HjVarDeclarator VariableDeclaratorId = (HjVarDeclarator)((Object)this.getRhsSym(1));
                VariableDeclaratorId.init = VariableInitializer = (Expr)this.getRhsSym(3);
                VariableDeclaratorId.position(this.pos((JPGPosition)VariableDeclaratorId.pos, (JPGPosition)VariableInitializer.position()));
                break;
            }
            case 104: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult((Object)new HjVarDeclarator(this.pos(), identifier));
                break;
            }
            case 105: {
                HjVarDeclarator TraditionalVariableDeclaratorId = (HjVarDeclarator)((Object)this.getRhsSym(1));
                ++TraditionalVariableDeclaratorId.dims;
                TraditionalVariableDeclaratorId.position(this.pos());
                break;
            }
            case 107: {
                Id identifier = (Id)this.getRhsSym(1);
                List IdentifierList = (List)this.getRhsSym(3);
                this.setResult((Object)new HjVarDeclarator(this.pos(), identifier, IdentifierList));
                break;
            }
            case 108: {
                List IdentifierList = (List)this.getRhsSym(2);
                this.setResult((Object)new HjVarDeclarator(this.pos(), IdentifierList));
                break;
            }
            case 111: {
                List FieldModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(FieldModifier);
                this.setResult(l);
                break;
            }
            case 112: {
                List FieldModifiers = (List)this.getRhsSym(1);
                List FieldModifier = (List)this.getRhsSym(2);
                FieldModifiers.addAll(FieldModifier);
                break;
            }
            case 113: {
                AnnotationNode Annotation3 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation3));
                break;
            }
            case 114: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 115: {
                this.setResult(Collections.singletonList(Flags.PROTECTED));
                break;
            }
            case 116: {
                this.setResult(Collections.singletonList(Flags.PRIVATE));
                break;
            }
            case 117: {
                this.setResult(Collections.singletonList(Flags.STATIC));
                break;
            }
            case 118: {
                this.setResult(Collections.singletonList(Flags.FINAL));
                break;
            }
            case 119: {
                this.setResult(Collections.singletonList(Flags.TRANSIENT));
                break;
            }
            case 121: {
                this.setResult(this.nf.CanonicalTypeNode(this.pos(), this.ts.Void()));
                break;
            }
            case 122: {
                Formal LastFormalParameter = (Formal)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Formal.class, false);
                l.add(LastFormalParameter);
                this.setResult(l);
                break;
            }
            case 123: {
                List FormalParameters = (List)this.getRhsSym(1);
                Formal LastFormalParameter = (Formal)this.getRhsSym(3);
                FormalParameters.add(LastFormalParameter);
                break;
            }
            case 124: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Formal.class, false);
                l.add(FormalParameter);
                this.setResult(l);
                break;
            }
            case 125: {
                List FormalParameters = (List)this.getRhsSym(1);
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                FormalParameters.add(FormalParameter);
                break;
            }
            case 126: {
                List VariableModifiersopt = (List)this.getRhsSym(1);
                TypeNode Type3 = (TypeNode)this.getRhsSym(2);
                HjVarDeclarator VariableDeclaratorId = (HjVarDeclarator)((Object)this.getRhsSym(3));
                HjFormal f = VariableDeclaratorId != null ? this.nf.HjFormal((Position)this.pos(), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), VariableModifiersopt), this.nf.array(Type3, this.pos(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2)), VariableDeclaratorId.dims), VariableDeclaratorId.name, VariableDeclaratorId.names()) : this.nf.Formal(this.pos(), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), VariableModifiersopt), this.nf.array(Type3, this.pos(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2)), 1), this.nf.Id(this.pos(), ""));
                this.setResult(f);
                break;
            }
            case 127: {
                List VariableModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(VariableModifier);
                this.setResult(l);
                break;
            }
            case 128: {
                List VariableModifiers = (List)this.getRhsSym(1);
                List VariableModifier = (List)this.getRhsSym(2);
                VariableModifiers.addAll(VariableModifier);
                break;
            }
            case 129: {
                this.setResult(Collections.singletonList(Flags.FINAL));
                break;
            }
            case 130: {
                AnnotationNode Annotation4 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation4));
                break;
            }
            case 131: {
                List VariableModifiersopt = (List)this.getRhsSym(1);
                TypeNode Type4 = (TypeNode)this.getRhsSym(2);
                Object opt = this.getRhsSym(3);
                HjVarDeclarator VariableDeclaratorId = (HjVarDeclarator)((Object)this.getRhsSym(4));
                assert (opt == null);
                HjFormal f = this.nf.HjFormal((Position)this.pos(), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), VariableModifiersopt), this.nf.array(Type4, this.pos(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2)), VariableDeclaratorId.dims), VariableDeclaratorId.name, VariableDeclaratorId.names());
                this.setResult(f);
                break;
            }
            case 132: {
                List MethodModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(MethodModifier);
                this.setResult(l);
                break;
            }
            case 133: {
                List MethodModifiers = (List)this.getRhsSym(1);
                List MethodModifier = (List)this.getRhsSym(2);
                MethodModifiers.addAll(MethodModifier);
                break;
            }
            case 134: {
                AnnotationNode Annotation5 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation5));
                break;
            }
            case 135: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 136: {
                this.setResult(Collections.singletonList(Flags.PROTECTED));
                break;
            }
            case 137: {
                this.setResult(Collections.singletonList(Flags.PRIVATE));
                break;
            }
            case 138: {
                this.setResult(Collections.singletonList(Flags.ABSTRACT));
                break;
            }
            case 139: {
                this.setResult(Collections.singletonList(Flags.STATIC));
                break;
            }
            case 140: {
                this.setResult(Collections.singletonList(Flags.FINAL));
                break;
            }
            case 141: {
                this.setResult(Collections.singletonList(Flags.NATIVE));
                break;
            }
            case 142: {
                this.setResult(Collections.singletonList(Flags.STRICTFP));
                break;
            }
            case 143: {
                List ExceptionTypeList = (List)this.getRhsSym(2);
                this.setResult(ExceptionTypeList);
                break;
            }
            case 144: {
                TypeNode ExceptionType = (TypeNode)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), TypeNode.class, false);
                l.add(ExceptionType);
                this.setResult(l);
                break;
            }
            case 145: {
                List ExceptionTypeList = (List)this.getRhsSym(1);
                TypeNode ExceptionType = (TypeNode)this.getRhsSym(3);
                ExceptionTypeList.add(ExceptionType);
                break;
            }
            case 148: {
                this.setResult(null);
                break;
            }
            case 150: {
                Block Block2 = (Block)this.getRhsSym(2);
                this.setResult(Block2);
                break;
            }
            case 151: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 152: {
                List ConstructorModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(ConstructorModifier);
                this.setResult(l);
                break;
            }
            case 153: {
                List ConstructorModifiers = (List)this.getRhsSym(1);
                List ConstructorModifier = (List)this.getRhsSym(2);
                ConstructorModifiers.addAll(ConstructorModifier);
                break;
            }
            case 154: {
                AnnotationNode Annotation6 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation6));
                break;
            }
            case 155: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 156: {
                this.setResult(Collections.singletonList(Flags.PROTECTED));
                break;
            }
            case 157: {
                this.setResult(Collections.singletonList(Flags.PRIVATE));
                break;
            }
            case 158: {
                Stmt ExplicitConstructorInvocationopt = (Stmt)this.getRhsSym(2);
                List BlockStatementsopt = (List)this.getRhsSym(3);
                TypedList l = new TypedList(new LinkedList(), Stmt.class, false);
                if (ExplicitConstructorInvocationopt == null) {
                    l.add(this.nf.SuperCall(this.pos(), Collections.EMPTY_LIST));
                } else {
                    l.add(ExplicitConstructorInvocationopt);
                }
                l.addAll(BlockStatementsopt);
                this.setResult(this.nf.Block(this.pos(), (List)l));
                break;
            }
            case 159: {
                List ArgumentListopt = (List)this.getRhsSym(2);
                this.setResult(ArgumentListopt);
                break;
            }
            case 161: {
                List InterfaceModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(InterfaceModifier);
                this.setResult(l);
                break;
            }
            case 162: {
                List InterfaceModifiers = (List)this.getRhsSym(1);
                List InterfaceModifier = (List)this.getRhsSym(2);
                InterfaceModifiers.addAll(InterfaceModifier);
                break;
            }
            case 163: {
                AnnotationNode Annotation7 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation7));
                break;
            }
            case 164: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 165: {
                this.setResult(Collections.singletonList(Flags.PROTECTED));
                break;
            }
            case 166: {
                this.setResult(Collections.singletonList(Flags.PRIVATE));
                break;
            }
            case 167: {
                this.setResult(Collections.singletonList(Flags.ABSTRACT));
                break;
            }
            case 168: {
                this.setResult(Collections.singletonList(Flags.STATIC));
                break;
            }
            case 169: {
                this.setResult(Collections.singletonList(Flags.STRICTFP));
                break;
            }
            case 170: {
                TypeNode InterfaceType = (TypeNode)this.getRhsSym(2);
                TypedList l = new TypedList(new LinkedList(), TypeNode.class, false);
                l.add(InterfaceType);
                this.setResult(l);
                break;
            }
            case 171: {
                List ExtendsInterfaces = (List)this.getRhsSym(1);
                TypeNode InterfaceType = (TypeNode)this.getRhsSym(3);
                ExtendsInterfaces.add(InterfaceType);
                break;
            }
            case 172: {
                List InterfaceMemberDeclarationsopt = (List)this.getRhsSym(2);
                this.setResult(this.nf.ClassBody(this.pos(), InterfaceMemberDeclarationsopt));
                break;
            }
            case 174: {
                List InterfaceMemberDeclarations = (List)this.getRhsSym(1);
                List InterfaceMemberDeclaration = (List)this.getRhsSym(2);
                InterfaceMemberDeclarations.addAll(InterfaceMemberDeclaration);
                break;
            }
            case 176: {
                MethodDecl AbstractMethodDeclaration = (MethodDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(AbstractMethodDeclaration);
                this.setResult(l);
                break;
            }
            case 177: {
                ClassDecl ClassDeclaration = (ClassDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(ClassDeclaration);
                this.setResult(l);
                break;
            }
            case 178: {
                ClassDecl InterfaceDeclaration = (ClassDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                l.add(InterfaceDeclaration);
                this.setResult(l);
                break;
            }
            case 179: {
                this.setResult(Collections.EMPTY_LIST);
                break;
            }
            case 180: {
                List ConstantModifiersopt = (List)this.getRhsSym(1);
                TypeNode Type5 = (TypeNode)this.getRhsSym(2);
                List VariableDeclarators = (List)this.getRhsSym(3);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                for (HjVarDeclarator d : VariableDeclarators) {
                    if (d.hasExplodedVars()) {
                        throw new Error("Field Declarations may not have exploded variables." + (Object)((Object)this.pos()));
                    }
                    FieldDecl fd = this.nf.FieldDecl(this.pos(this.getRhsFirstTokenIndex(2), this.getRightSpan()), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), ConstantModifiersopt), this.nf.array(Type5, this.pos(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2)), d.dims), d.name, d.init);
                    l.add(fd);
                }
                this.setResult(l);
                break;
            }
            case 181: {
                List ConstantModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(ConstantModifier);
                this.setResult(l);
                break;
            }
            case 182: {
                List ConstantModifiers = (List)this.getRhsSym(1);
                List ConstantModifier = (List)this.getRhsSym(2);
                ConstantModifiers.addAll(ConstantModifier);
                break;
            }
            case 183: {
                AnnotationNode Annotation8 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation8));
                break;
            }
            case 184: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 185: {
                this.setResult(Collections.singletonList(Flags.STATIC));
                break;
            }
            case 186: {
                this.setResult(Collections.singletonList(Flags.FINAL));
                break;
            }
            case 187: {
                List AbstractMethodModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(AbstractMethodModifier);
                this.setResult(l);
                break;
            }
            case 188: {
                List AbstractMethodModifiers = (List)this.getRhsSym(1);
                List AbstractMethodModifier = (List)this.getRhsSym(2);
                AbstractMethodModifiers.addAll(AbstractMethodModifier);
                break;
            }
            case 189: {
                AnnotationNode Annotation9 = (AnnotationNode)this.getRhsSym(1);
                this.setResult(Collections.singletonList(Annotation9));
                break;
            }
            case 190: {
                this.setResult(Collections.singletonList(Flags.PUBLIC));
                break;
            }
            case 191: {
                this.setResult(Collections.singletonList(Flags.ABSTRACT));
                break;
            }
            case 192: {
                AnnotationNode Annotation10 = (AnnotationNode)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), AnnotationNode.class, false);
                l.add(Annotation10);
                this.setResult(l);
                break;
            }
            case 193: {
                List Annotations = (List)this.getRhsSym(1);
                AnnotationNode Annotation11 = (AnnotationNode)this.getRhsSym(2);
                Annotations.add(Annotation11);
                break;
            }
            case 194: {
                TypeNode InterfaceType = (TypeNode)this.getRhsSym(2);
                this.setResult(this.nf.AnnotationNode(this.pos(), InterfaceType));
                break;
            }
            case 195: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 196: {
                List VariableInitializersopt = (List)this.getRhsSym(2);
                Object opt = this.getRhsSym(3);
                if (VariableInitializersopt == null) {
                    this.setResult(this.nf.ArrayInit(this.pos()));
                    break;
                }
                this.setResult(this.nf.ArrayInit(this.pos(), VariableInitializersopt));
                break;
            }
            case 197: {
                Expr VariableInitializer = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(VariableInitializer);
                this.setResult(l);
                break;
            }
            case 198: {
                List VariableInitializers = (List)this.getRhsSym(1);
                Expr VariableInitializer = (Expr)this.getRhsSym(3);
                VariableInitializers.add(VariableInitializer);
                break;
            }
            case 199: {
                List Annotationsopt = (List)this.getRhsSym(1);
                List BlockStatementsopt = (List)this.getRhsSym(3);
                this.setResult(this.nf.Block(this.pos(), BlockStatementsopt));
                break;
            }
            case 200: {
                List BlockStatement = (List)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Stmt.class, false);
                l.addAll(BlockStatement);
                this.setResult(l);
                break;
            }
            case 201: {
                List BlockStatements = (List)this.getRhsSym(1);
                List BlockStatement = (List)this.getRhsSym(2);
                BlockStatements.addAll(BlockStatement);
                break;
            }
            case 203: {
                ClassDecl ClassDeclaration = (ClassDecl)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Stmt.class, false);
                l.add(this.nf.LocalClassDecl(this.pos(), ClassDeclaration));
                this.setResult(l);
                break;
            }
            case 204: {
                Stmt Statement = (Stmt)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Stmt.class, false);
                l.add(Statement);
                this.setResult(l);
                break;
            }
            case 206: {
                List VariableModifiersopt = (List)this.getRhsSym(1);
                TypeNode Type6 = (TypeNode)this.getRhsSym(2);
                List VariableDeclarators = (List)this.getRhsSym(3);
                TypedList l = new TypedList(new LinkedList(), LocalDecl.class, false);
                TypedList s = new TypedList(new LinkedList(), Stmt.class, false);
                if (VariableDeclarators != null) {
                    for (HjVarDeclarator d : VariableDeclarators) {
                        d.setFlag(this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), VariableModifiersopt));
                        LocalDecl ld = this.nf.LocalDecl(d.pos, d.flags, this.nf.array(Type6, this.pos(d), d.dims), d.name, d.init);
                        l.add(ld);
                        if (!d.hasExplodedVars()) continue;
                        s.addAll(HjFormal_c.explode((NodeFactory)this.nf, (TypeSystem)this.ts, d.name, this.pos(d), d.flags, d.names()));
                    }
                }
                l.addAll(s);
                this.setResult(l);
                break;
            }
            case 231: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Stmt Statement = (Stmt)this.getRhsSym(5);
                this.setResult(this.nf.If(this.pos(), Expression, Statement));
                break;
            }
            case 232: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(5);
                Stmt Statement = (Stmt)this.getRhsSym(7);
                this.setResult(this.nf.If(this.pos(), Expression, StatementNoShortIf, Statement));
                break;
            }
            case 233: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Stmt true_stmt = (Stmt)this.getRhsSym(5);
                Stmt false_stmt = (Stmt)this.getRhsSym(7);
                this.setResult(this.nf.If(this.pos(), Expression, true_stmt, false_stmt));
                break;
            }
            case 234: {
                this.setResult(this.nf.Empty(this.pos()));
                break;
            }
            case 235: {
                Id identifier = (Id)this.getRhsSym(1);
                Stmt Statement = (Stmt)this.getRhsSym(3);
                this.setResult(this.nf.Labeled(this.pos(), identifier, Statement));
                break;
            }
            case 236: {
                Id identifier = (Id)this.getRhsSym(1);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(3);
                this.setResult(this.nf.Labeled(this.pos(), identifier, StatementNoShortIf));
                break;
            }
            case 237: {
                Expr StatementExpression = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.Eval(this.pos(), StatementExpression));
                break;
            }
            case 247: {
                Expr Expression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Assert(this.pos(), Expression));
                break;
            }
            case 248: {
                Expr expr1 = (Expr)this.getRhsSym(2);
                Expr expr2 = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Assert(this.pos(), expr1, expr2));
                break;
            }
            case 249: {
                Expr Expression = (Expr)this.getRhsSym(3);
                List SwitchBlock2 = (List)this.getRhsSym(5);
                this.setResult(this.nf.Switch(this.pos(), Expression, SwitchBlock2));
                break;
            }
            case 250: {
                List SwitchBlockStatementGroupsopt = (List)this.getRhsSym(2);
                List SwitchLabelsopt = (List)this.getRhsSym(3);
                SwitchBlockStatementGroupsopt.addAll(SwitchLabelsopt);
                this.setResult(SwitchBlockStatementGroupsopt);
                break;
            }
            case 252: {
                List SwitchBlockStatementGroups = (List)this.getRhsSym(1);
                List SwitchBlockStatementGroup = (List)this.getRhsSym(2);
                SwitchBlockStatementGroups.addAll(SwitchBlockStatementGroup);
                break;
            }
            case 253: {
                List SwitchLabels = (List)this.getRhsSym(1);
                List BlockStatements = (List)this.getRhsSym(2);
                TypedList l = new TypedList(new LinkedList(), SwitchElement.class, false);
                l.addAll(SwitchLabels);
                l.add(this.nf.SwitchBlock(this.pos(), BlockStatements));
                this.setResult(l);
                break;
            }
            case 254: {
                Case SwitchLabel = (Case)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Case.class, false);
                l.add(SwitchLabel);
                this.setResult(l);
                break;
            }
            case 255: {
                List SwitchLabels = (List)this.getRhsSym(1);
                Case SwitchLabel = (Case)this.getRhsSym(2);
                SwitchLabels.add(SwitchLabel);
                break;
            }
            case 256: {
                Expr ConstantExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Case(this.pos(), ConstantExpression));
                break;
            }
            case 257: {
                this.setResult(this.nf.Default(this.pos()));
                break;
            }
            case 258: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Stmt Statement = (Stmt)this.getRhsSym(5);
                this.setResult(this.nf.While(this.pos(), Expression, Statement));
                break;
            }
            case 259: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(5);
                this.setResult(this.nf.While(this.pos(), Expression, StatementNoShortIf));
                break;
            }
            case 260: {
                Stmt Statement = (Stmt)this.getRhsSym(2);
                Expr Expression = (Expr)this.getRhsSym(5);
                this.setResult(this.nf.Do(this.pos(), Statement, Expression));
                break;
            }
            case 263: {
                List ForInitopt = (List)this.getRhsSym(3);
                Expr Expressionopt = (Expr)this.getRhsSym(5);
                List ForUpdateopt = (List)this.getRhsSym(7);
                Stmt Statement = (Stmt)this.getRhsSym(9);
                this.setResult(this.nf.For(this.pos(), ForInitopt, Expressionopt, ForUpdateopt, Statement));
                break;
            }
            case 266: {
                List ForInitopt = (List)this.getRhsSym(3);
                Expr Expressionopt = (Expr)this.getRhsSym(5);
                List ForUpdateopt = (List)this.getRhsSym(7);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(9);
                this.setResult(this.nf.For(this.pos(), ForInitopt, Expressionopt, ForUpdateopt, StatementNoShortIf));
                break;
            }
            case 268: {
                List LocalVariableDeclaration = (List)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ForInit.class, false);
                l.addAll(LocalVariableDeclaration);
                break;
            }
            case 270: {
                Expr StatementExpression = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Eval.class, false);
                l.add(this.nf.Eval(this.pos(), StatementExpression));
                this.setResult(l);
                break;
            }
            case 271: {
                List StatementExpressionList = (List)this.getRhsSym(1);
                Expr StatementExpression = (Expr)this.getRhsSym(3);
                StatementExpressionList.add(this.nf.Eval(this.pos(), StatementExpression));
                break;
            }
            case 272: {
                Id identifieropt = (Id)this.getRhsSym(2);
                if (identifieropt == null) {
                    this.setResult(this.nf.Break(this.pos()));
                    break;
                }
                this.setResult(this.nf.Break(this.pos(), identifieropt));
                break;
            }
            case 273: {
                Id identifieropt = (Id)this.getRhsSym(2);
                if (identifieropt == null) {
                    this.setResult(this.nf.Continue(this.pos()));
                    break;
                }
                this.setResult(this.nf.Continue(this.pos(), identifieropt));
                break;
            }
            case 274: {
                Expr Expressionopt = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Return(this.pos(), Expressionopt));
                break;
            }
            case 275: {
                Expr Expression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Throw(this.pos(), Expression));
                break;
            }
            case 276: {
                Block Block3 = (Block)this.getRhsSym(2);
                List Catches = (List)this.getRhsSym(3);
                this.setResult(this.nf.Try(this.pos(), Block3, Catches));
                break;
            }
            case 277: {
                Block Block4 = (Block)this.getRhsSym(2);
                List Catchesopt = (List)this.getRhsSym(3);
                Block Finally = (Block)this.getRhsSym(4);
                this.setResult(this.nf.Try(this.pos(), Block4, Catchesopt, Finally));
                break;
            }
            case 278: {
                Catch CatchClause = (Catch)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Catch.class, false);
                l.add(CatchClause);
                this.setResult(l);
                break;
            }
            case 279: {
                List Catches = (List)this.getRhsSym(1);
                Catch CatchClause = (Catch)this.getRhsSym(2);
                Catches.add(CatchClause);
                break;
            }
            case 280: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Block Block5 = (Block)this.getRhsSym(5);
                this.setResult(this.nf.Catch(this.pos(), (Formal)FormalParameter, Block5));
                break;
            }
            case 281: {
                Block Block6 = (Block)this.getRhsSym(2);
                this.setResult(Block6);
                break;
            }
            case 286: {
                TypeNode Type7 = (TypeNode)this.getRhsSym(1);
                if (Type7 instanceof ParsedName) {
                    ParsedName a = (ParsedName)Type7;
                    this.setResult(this.nf.ClassLit(this.pos(), a.toType()));
                    break;
                }
                if (Type7 instanceof TypeNode) {
                    this.setResult(this.nf.ClassLit(this.pos(), Type7));
                    break;
                }
                if (Type7 instanceof CanonicalTypeNode) {
                    CanonicalTypeNode a = (CanonicalTypeNode)Type7;
                    this.setResult(this.nf.ClassLit(this.pos(), (TypeNode)a));
                    break;
                }
                assert (false);
                break;
            }
            case 287: {
                this.setResult(this.nf.ClassLit(this.pos(), (TypeNode)this.nf.CanonicalTypeNode(this.pos(this.getLeftSpan()), this.ts.Void())));
                break;
            }
            case 288: {
                this.setResult(this.nf.This(this.pos()));
                break;
            }
            case 289: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                this.setResult(this.nf.This(this.pos(), ClassName.toType()));
                break;
            }
            case 290: {
                Expr Expression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.ParExpr(this.pos(), Expression));
                break;
            }
            case 297: {
                IToken IntegerLiteral = this.getRhsIToken(1);
                LongLiteral a = this.int_lit(this.getRhsFirstTokenIndex(1));
                this.setResult(this.nf.IntLit(this.pos(), IntLit.INT, a.getValue().longValue()));
                break;
            }
            case 298: {
                IToken LongLiteral2 = this.getRhsIToken(1);
                LongLiteral a = this.long_lit(this.getRhsFirstTokenIndex(1));
                this.setResult(this.nf.IntLit(this.pos(), IntLit.LONG, a.getValue().longValue()));
                break;
            }
            case 299: {
                IToken FloatLiteral2 = this.getRhsIToken(1);
                FloatLiteral a = this.float_lit(this.getRhsFirstTokenIndex(1));
                this.setResult(this.nf.FloatLit(this.pos(), FloatLit.FLOAT, a.getValue().floatValue()));
                break;
            }
            case 300: {
                IToken DoubleLiteral2 = this.getRhsIToken(1);
                DoubleLiteral a = this.double_lit(this.getRhsFirstTokenIndex(1));
                this.setResult(this.nf.FloatLit(this.pos(), FloatLit.DOUBLE, a.getValue().doubleValue()));
                break;
            }
            case 301: {
                BooleanLiteral BooleanLiteral2 = (BooleanLiteral)this.getRhsSym(1);
                this.setResult(this.nf.BooleanLit(this.pos(), BooleanLiteral2.getValue()));
                break;
            }
            case 302: {
                IToken CharacterLiteral2 = this.getRhsIToken(1);
                CharacterLiteral a = this.char_lit(this.getRhsFirstTokenIndex(1));
                this.setResult(this.nf.CharLit(this.pos(), a.getValue().charValue()));
                break;
            }
            case 303: {
                IToken str = this.getRhsIToken(1);
                StringLiteral a = this.string_lit(this.getRhsFirstTokenIndex(1));
                this.setResult(this.nf.StringLit(this.pos(), a.getValue()));
                break;
            }
            case 304: {
                this.setResult(this.nf.NullLit(this.pos()));
                break;
            }
            case 305: {
                IToken trueLiteral = this.getRhsIToken(1);
                this.setResult(this.boolean_lit(this.getRhsFirstTokenIndex(1)));
                break;
            }
            case 306: {
                IToken falseLiteral = this.getRhsIToken(1);
                this.setResult(this.boolean_lit(this.getRhsFirstTokenIndex(1)));
                break;
            }
            case 307: {
                Expr Expression = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(Expression);
                this.setResult(l);
                break;
            }
            case 308: {
                List ArgumentList = (List)this.getRhsSym(1);
                Expr Expression = (Expr)this.getRhsSym(3);
                ArgumentList.add(Expression);
                break;
            }
            case 309: {
                Expr DimExpr = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(DimExpr);
                this.setResult(l);
                break;
            }
            case 310: {
                List DimExprs = (List)this.getRhsSym(1);
                Expr DimExpr = (Expr)this.getRhsSym(2);
                DimExprs.add(DimExpr);
                break;
            }
            case 311: {
                Expr Expression = (Expr)this.getRhsSym(2);
                this.setResult(Expression.position((Position)this.pos()));
                break;
            }
            case 312: {
                this.setResult(new Integer(1));
                break;
            }
            case 313: {
                Integer Dims = (Integer)this.getRhsSym(1);
                this.setResult(new Integer(Dims + 1));
                break;
            }
            case 314: {
                Expr Primary = (Expr)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(this.nf.Field(this.pos(), (Receiver)Primary, identifier));
                break;
            }
            case 315: {
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(this.nf.Field(this.pos(this.getRightSpan()), (Receiver)this.nf.Super(this.pos(this.getLeftSpan())), identifier));
                break;
            }
            case 316: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                IToken sup = this.getRhsIToken(3);
                Id identifier = (Id)this.getRhsSym(5);
                this.setResult(this.nf.Field(this.pos(this.getRightSpan()), (Receiver)this.nf.Super(this.pos(this.getRhsFirstTokenIndex(3)), ClassName.toType()), identifier));
                break;
            }
            case 317: {
                ParsedName MethodName = (ParsedName)this.getRhsSym(1);
                List ArgumentListopt = (List)this.getRhsSym(3);
                this.setResult(this.nf.Call(this.pos(), MethodName.prefix == null ? null : MethodName.prefix.toReceiver(), MethodName.name, ArgumentListopt));
                break;
            }
            case 319: {
                ParsedName ExpressionName = (ParsedName)this.getRhsSym(1);
                this.setResult(ExpressionName.toExpr());
                break;
            }
            case 322: {
                Expr PostfixExpression = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.Unary(this.pos(), PostfixExpression, Unary.POST_INC));
                break;
            }
            case 323: {
                Expr PostfixExpression = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.Unary(this.pos(), PostfixExpression, Unary.POST_DEC));
                break;
            }
            case 326: {
                Expr UnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.POS, UnaryExpression));
                break;
            }
            case 327: {
                Expr UnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.NEG, UnaryExpression));
                break;
            }
            case 329: {
                Expr UnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.PRE_INC, UnaryExpression));
                break;
            }
            case 330: {
                Expr UnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.PRE_DEC, UnaryExpression));
                break;
            }
            case 332: {
                Expr UnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.BIT_NOT, UnaryExpression));
                break;
            }
            case 333: {
                Expr UnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.NOT, UnaryExpression));
                break;
            }
            case 336: {
                Expr MultiplicativeExpression = (Expr)this.getRhsSym(1);
                Expr UnaryExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), MultiplicativeExpression, Binary.MUL, UnaryExpression));
                break;
            }
            case 337: {
                Expr MultiplicativeExpression = (Expr)this.getRhsSym(1);
                Expr UnaryExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), MultiplicativeExpression, Binary.DIV, UnaryExpression));
                break;
            }
            case 338: {
                Expr MultiplicativeExpression = (Expr)this.getRhsSym(1);
                Expr UnaryExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), MultiplicativeExpression, Binary.MOD, UnaryExpression));
                break;
            }
            case 340: {
                Expr AdditiveExpression = (Expr)this.getRhsSym(1);
                Expr MultiplicativeExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), AdditiveExpression, Binary.ADD, MultiplicativeExpression));
                break;
            }
            case 341: {
                Expr AdditiveExpression = (Expr)this.getRhsSym(1);
                Expr MultiplicativeExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), AdditiveExpression, Binary.SUB, MultiplicativeExpression));
                break;
            }
            case 343: {
                Expr ShiftExpression = (Expr)this.getRhsSym(1);
                Expr AdditiveExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ShiftExpression, Binary.SHL, AdditiveExpression));
                break;
            }
            case 344: {
                Expr ShiftExpression = (Expr)this.getRhsSym(1);
                Expr AdditiveExpression = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Binary(this.pos(), ShiftExpression, Binary.SHR, AdditiveExpression));
                break;
            }
            case 345: {
                Expr ShiftExpression = (Expr)this.getRhsSym(1);
                Expr AdditiveExpression = (Expr)this.getRhsSym(5);
                this.setResult(this.nf.Binary(this.pos(), ShiftExpression, Binary.USHR, AdditiveExpression));
                break;
            }
            case 347: {
                Expr RelationalExpression = (Expr)this.getRhsSym(1);
                Expr ShiftExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), RelationalExpression, Binary.LT, ShiftExpression));
                break;
            }
            case 348: {
                Expr RelationalExpression = (Expr)this.getRhsSym(1);
                Expr ShiftExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), RelationalExpression, Binary.GT, ShiftExpression));
                break;
            }
            case 349: {
                Expr RelationalExpression = (Expr)this.getRhsSym(1);
                Expr ShiftExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), RelationalExpression, Binary.LE, ShiftExpression));
                break;
            }
            case 350: {
                Expr RelationalExpression = (Expr)this.getRhsSym(1);
                Expr ShiftExpression = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Binary(this.pos(), RelationalExpression, Binary.GE, ShiftExpression));
                break;
            }
            case 352: {
                Expr EqualityExpression = (Expr)this.getRhsSym(1);
                Expr RelationalExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), EqualityExpression, Binary.EQ, RelationalExpression));
                break;
            }
            case 353: {
                Expr EqualityExpression = (Expr)this.getRhsSym(1);
                Expr RelationalExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), EqualityExpression, Binary.NE, RelationalExpression));
                break;
            }
            case 355: {
                Expr AndExpression = (Expr)this.getRhsSym(1);
                Expr EqualityExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), AndExpression, Binary.BIT_AND, EqualityExpression));
                break;
            }
            case 357: {
                Expr ExclusiveOrExpression = (Expr)this.getRhsSym(1);
                Expr AndExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ExclusiveOrExpression, Binary.BIT_XOR, AndExpression));
                break;
            }
            case 359: {
                Expr InclusiveOrExpression = (Expr)this.getRhsSym(1);
                Expr ExclusiveOrExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), InclusiveOrExpression, Binary.BIT_OR, ExclusiveOrExpression));
                break;
            }
            case 361: {
                Expr ConditionalAndExpression = (Expr)this.getRhsSym(1);
                Expr InclusiveOrExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConditionalAndExpression, Binary.COND_AND, InclusiveOrExpression));
                break;
            }
            case 363: {
                Expr ConditionalOrExpression = (Expr)this.getRhsSym(1);
                Expr ConditionalAndExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConditionalOrExpression, Binary.COND_OR, ConditionalAndExpression));
                break;
            }
            case 365: {
                Expr ConditionalOrExpression = (Expr)this.getRhsSym(1);
                Expr Expression = (Expr)this.getRhsSym(3);
                Expr ConditionalExpression = (Expr)this.getRhsSym(5);
                this.setResult(this.nf.Conditional(this.pos(), ConditionalOrExpression, Expression, ConditionalExpression));
                break;
            }
            case 369: {
                Expr LeftHandSide = (Expr)this.getRhsSym(1);
                Assign.Operator AssignmentOperator = (Assign.Operator)this.getRhsSym(2);
                Expr AssignmentExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Assign(this.pos(), LeftHandSide, AssignmentOperator, AssignmentExpression));
                break;
            }
            case 370: {
                ParsedName ExpressionName = (ParsedName)this.getRhsSym(1);
                this.setResult(ExpressionName.toExpr());
                break;
            }
            case 373: {
                this.setResult(Assign.ASSIGN);
                break;
            }
            case 374: {
                this.setResult(Assign.MUL_ASSIGN);
                break;
            }
            case 375: {
                this.setResult(Assign.DIV_ASSIGN);
                break;
            }
            case 376: {
                this.setResult(Assign.MOD_ASSIGN);
                break;
            }
            case 377: {
                this.setResult(Assign.ADD_ASSIGN);
                break;
            }
            case 378: {
                this.setResult(Assign.SUB_ASSIGN);
                break;
            }
            case 379: {
                this.setResult(Assign.SHL_ASSIGN);
                break;
            }
            case 380: {
                this.setResult(Assign.SHR_ASSIGN);
                break;
            }
            case 381: {
                this.setResult(Assign.USHR_ASSIGN);
                break;
            }
            case 382: {
                this.setResult(Assign.BIT_AND_ASSIGN);
                break;
            }
            case 383: {
                this.setResult(Assign.BIT_XOR_ASSIGN);
                break;
            }
            case 384: {
                this.setResult(Assign.BIT_OR_ASSIGN);
                break;
            }
            case 387: {
                this.setResult(new Integer(0));
                break;
            }
            case 388: {
                break;
            }
            case 389: {
                this.setResult(new TypedList(new LinkedList(), Catch.class, false));
                break;
            }
            case 390: {
                break;
            }
            case 391: {
                this.setResult(null);
                break;
            }
            case 392: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 393: {
                this.setResult(new TypedList(new LinkedList(), ForUpdate.class, false));
                break;
            }
            case 394: {
                break;
            }
            case 395: {
                this.setResult(null);
                break;
            }
            case 396: {
                break;
            }
            case 397: {
                this.setResult(new TypedList(new LinkedList(), ForInit.class, false));
                break;
            }
            case 398: {
                break;
            }
            case 399: {
                this.setResult(new TypedList(new LinkedList(), Case.class, false));
                break;
            }
            case 400: {
                break;
            }
            case 401: {
                this.setResult(new TypedList(new LinkedList(), SwitchElement.class, false));
                break;
            }
            case 402: {
                break;
            }
            case 403: {
                this.setResult(new LinkedList());
                break;
            }
            case 404: {
                break;
            }
            case 405: {
                this.setResult(null);
                break;
            }
            case 406: {
                break;
            }
            case 407: {
                this.setResult(new LinkedList());
                break;
            }
            case 408: {
                break;
            }
            case 409: {
                this.setResult(new LinkedList());
                break;
            }
            case 410: {
                break;
            }
            case 411: {
                this.setResult(new TypedList(new LinkedList(), ClassMember.class, false));
                break;
            }
            case 412: {
                break;
            }
            case 413: {
                this.setResult(new TypedList(new LinkedList(), TypeNode.class, false));
                break;
            }
            case 414: {
                break;
            }
            case 415: {
                this.setResult(new LinkedList());
                break;
            }
            case 416: {
                break;
            }
            case 417: {
                this.setResult(null);
                break;
            }
            case 418: {
                break;
            }
            case 419: {
                this.setResult(new TypedList(new LinkedList(), Expr.class, false));
                break;
            }
            case 420: {
                break;
            }
            case 421: {
                this.setResult(null);
                break;
            }
            case 423: {
                this.setResult(new TypedList(new LinkedList(), Catch.class, false));
                break;
            }
            case 424: {
                break;
            }
            case 425: {
                this.setResult(new TypedList(new LinkedList(), Stmt.class, false));
                break;
            }
            case 426: {
                break;
            }
            case 427: {
                this.setResult(null);
                break;
            }
            case 428: {
                break;
            }
            case 429: {
                this.setResult(new LinkedList());
                break;
            }
            case 430: {
                break;
            }
            case 431: {
                this.setResult(null);
                break;
            }
            case 433: {
                this.setResult(new TypedList(new LinkedList(), Formal.class, false));
                break;
            }
            case 434: {
                break;
            }
            case 435: {
                this.setResult(new TypedList(new LinkedList(), TypeNode.class, false));
                break;
            }
            case 436: {
                break;
            }
            case 437: {
                this.setResult(new LinkedList());
                break;
            }
            case 438: {
                break;
            }
            case 439: {
                this.setResult(new LinkedList());
                break;
            }
            case 440: {
                break;
            }
            case 441: {
                this.setResult(new TypedList(new LinkedList(), ClassMember.class, false));
                break;
            }
            case 442: {
                break;
            }
            case 443: {
                this.setResult(new TypedList(new LinkedList(), TypeNode.class, false));
                break;
            }
            case 444: {
                break;
            }
            case 445: {
                this.setResult(this.nf.TypeNodeFromQualifiedName(this.pos(), QName.make((String)"hj.lang.Object")));
                break;
            }
            case 446: {
                break;
            }
            case 447: {
                this.setResult(new TypedList(new LinkedList(), TypeNode.class, false));
                break;
            }
            case 448: {
                break;
            }
            case 449: {
                this.setResult(new LinkedList());
                break;
            }
            case 451: {
                this.setResult(new TypedList(new LinkedList(), AnnotationNode.class, false));
                break;
            }
            case 452: {
                break;
            }
            case 453: {
                this.setResult(new TypedList(new LinkedList(), TopLevelDecl.class, false));
                break;
            }
            case 454: {
                break;
            }
            case 455: {
                this.setResult(new TypedList(new LinkedList(), Import.class, false));
                break;
            }
            case 456: {
                break;
            }
            case 457: {
                this.setResult(null);
                break;
            }
            case 458: {
                break;
            }
            case 459: {
                this.setResult(null);
                break;
            }
            case 460: {
                break;
            }
            case 461: {
                this.setResult(new TypedList(new LinkedList(), TypeNode.class, false));
                break;
            }
            case 462: {
                break;
            }
            case 463: {
                this.setResult(null);
                break;
            }
            case 464: {
                break;
            }
            case 465: {
                this.setResult(new TypedList(new LinkedList(), TypeNode.class, false));
                break;
            }
            case 466: {
                break;
            }
            case 467: {
                ParsedName TypeName = (ParsedName)this.getRhsSym(1);
                List TypeArgumentsopt = (List)this.getRhsSym(2);
                Object PlaceTypeSpecifieropt = this.getRhsSym(3);
                AmbTypeNode type_name = (AmbTypeNode)TypeName.toType();
                HjTypeNode type = (HjTypeNode)this.nf.AmbTypeNode(this.pos(), type_name.prefix(), type_name.name(), TypeArgumentsopt);
                this.setResult(type);
                break;
            }
            case 468: {
                ParsedName TypeName = (ParsedName)this.getRhsSym(1);
                List TypeArgumentsopt = (List)this.getRhsSym(2);
                Object PlaceTypeSpecifieropt = this.getRhsSym(3);
                AmbTypeNode type_name = (AmbTypeNode)TypeName.toType();
                HjTypeNode type = (HjTypeNode)this.nf.AmbTypeNode(this.pos(), type_name.prefix(), type_name.name(), TypeArgumentsopt);
                this.setResult(type);
                break;
            }
            case 469: {
                ParsedName PackageName = (ParsedName)this.getRhsSym(2);
                this.setResult(PackageName.toPackage());
                break;
            }
            case 470: {
                List HjClassModifiersopt = (List)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                List TypeParametersopt = (List)this.getRhsSym(4);
                TypeNode Superopt = (TypeNode)this.getRhsSym(5);
                List Interfacesopt = (List)this.getRhsSym(6);
                ClassBody ClassBody2 = (ClassBody)this.getRhsSym(7);
                this.checkTypeName(identifier);
                FlagsNode f = this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), HjClassModifiersopt);
                ValueClassDecl cd = HjFlags.isValue(f.flags()) ? this.nf.ValueClassDecl((Position)this.pos(), new FlagAnnotations(f, null), identifier, Superopt, (List<TypeNode>)Interfacesopt, ClassBody2, TypeParametersopt) : this.nf.ClassDecl(this.pos(), new FlagAnnotations(f, null), identifier, Superopt, Interfacesopt, ClassBody2, TypeParametersopt);
                this.setResult(cd);
                break;
            }
            case 471: {
                List HjClassModifier = (List)this.getRhsSym(1);
                LinkedList l = new LinkedList();
                l.addAll(HjClassModifier);
                this.setResult(l);
                break;
            }
            case 472: {
                List HjClassModifiers = (List)this.getRhsSym(1);
                List HjClassModifier = (List)this.getRhsSym(2);
                HjClassModifiers.addAll(HjClassModifier);
                break;
            }
            case 473: {
                List ClassModifier = (List)this.getRhsSym(1);
                this.setResult(ClassModifier);
                break;
            }
            case 474: {
                this.setResult(Collections.singletonList(HjFlags.SAFE));
                break;
            }
            case 475: {
                Integer e;
                List MethodModifiersopt = (List)this.getRhsSym(1);
                List TypeParametersopt = (List)this.getRhsSym(2);
                TypeNode ResultType = (TypeNode)this.getRhsSym(3);
                Object[] MethodDeclarator = (Object[])this.getRhsSym(4);
                List Throwsopt = (List)this.getRhsSym(5);
                Block MethodBody = (Block)this.getRhsSym(6);
                ParsedName c = MethodDeclarator != null ? (ParsedName)MethodDeclarator[0] : null;
                List d = MethodDeclarator != null ? (List)MethodDeclarator[1] : null;
                Integer n = e = MethodDeclarator != null ? (Integer)MethodDeclarator[2] : null;
                if (ResultType.type() == this.ts.Void() && e != null && e > 0) {
                    System.err.println("Fix me - encountered method returning void but with non-zero rank?");
                }
                FlagsNode f = this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), MethodModifiersopt);
                MethodDecl md = this.nf.MethodDecl(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(6)), new FlagAnnotations(f, null), this.nf.array(ResultType, this.pos(this.getRhsFirstTokenIndex(3), this.getRhsLastTokenIndex(3)), e != null ? e : 1), c != null ? c.name : this.nf.Id(this.pos(), ""), d, Throwsopt, MethodBody, TypeParametersopt);
                this.setResult(md);
                break;
            }
            case 476: {
                List ArgumentListopt = (List)this.getRhsSym(3);
                this.setResult(this.nf.ThisCall(this.pos(), ArgumentListopt));
                break;
            }
            case 477: {
                List ArgumentListopt = (List)this.getRhsSym(3);
                this.setResult(this.nf.SuperCall(this.pos(), ArgumentListopt));
                break;
            }
            case 478: {
                Expr Primary = (Expr)this.getRhsSym(1);
                List ArgumentListopt = (List)this.getRhsSym(5);
                this.setResult(this.nf.ThisCall(this.pos(), Primary, ArgumentListopt));
                break;
            }
            case 479: {
                Expr Primary = (Expr)this.getRhsSym(1);
                List ArgumentListopt = (List)this.getRhsSym(5);
                this.setResult(this.nf.SuperCall(this.pos(), Primary, ArgumentListopt));
                break;
            }
            case 480: {
                List InterfaceModifiersopt = (List)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                List TypeParametersopt = (List)this.getRhsSym(4);
                List ExtendsInterfacesopt = (List)this.getRhsSym(5);
                ClassBody InterfaceBody = (ClassBody)this.getRhsSym(6);
                this.checkTypeName(identifier);
                InterfaceModifiersopt.add(Flags.INTERFACE);
                FlagsNode f = this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), InterfaceModifiersopt);
                ClassDecl cd = this.nf.ClassDecl(this.pos(), new FlagAnnotations(f, null), identifier, null, ExtendsInterfacesopt, InterfaceBody, TypeParametersopt);
                this.setResult(cd);
                break;
            }
            case 481: {
                List AbstractMethodModifiersopt = (List)this.getRhsSym(1);
                List TypeParametersopt = (List)this.getRhsSym(2);
                TypeNode ResultType = (TypeNode)this.getRhsSym(3);
                Object[] MethodDeclarator = (Object[])this.getRhsSym(4);
                List Throwsopt = (List)this.getRhsSym(5);
                ParsedName c = (ParsedName)MethodDeclarator[0];
                List d = (List)MethodDeclarator[1];
                Integer e = (Integer)MethodDeclarator[2];
                if (ResultType.type() == this.ts.Void() && e > 0) assert (false);
                FlagsNode f = this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), AbstractMethodModifiersopt);
                MethodDecl md = this.nf.MethodDecl(this.pos(this.getRhsFirstTokenIndex(3), this.getRhsLastTokenIndex(4)), new FlagAnnotations(f, null), this.nf.array(ResultType, this.pos(this.getRhsFirstTokenIndex(3), this.getRhsLastTokenIndex(3)), e), this.nf.Id(c.pos, c.toString()), d, Throwsopt, null, TypeParametersopt);
                this.setResult(md);
                break;
            }
            case 482: {
                List ArgumentList = (List)this.getRhsSym(4);
                ClassBody ClassBodyopt = (ClassBody)this.getRhsSym(6);
                this.setResult(this.nf.HjArrayViewConstructor(this.pos(), ArgumentList));
                break;
            }
            case 483: {
                TypeNode ClassOrInterfaceType = (TypeNode)this.getRhsSym(2);
                List ArgumentListopt = (List)this.getRhsSym(4);
                ClassBody ClassBodyopt = (ClassBody)this.getRhsSym(6);
                if (ClassBodyopt == null) {
                    this.setResult(this.nf.New(this.pos(), ClassOrInterfaceType, ArgumentListopt));
                    break;
                }
                this.setResult(this.nf.New(this.pos(), ClassOrInterfaceType, ArgumentListopt, ClassBodyopt));
                break;
            }
            case 484: {
                Expr Primary = (Expr)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(4);
                List ArgumentListopt = (List)this.getRhsSym(6);
                ClassBody ClassBodyopt = (ClassBody)this.getRhsSym(8);
                ParsedName b = new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier);
                if (ClassBodyopt == null) {
                    this.setResult(this.nf.New(this.pos(), Primary, b.toType(), ArgumentListopt));
                    break;
                }
                this.setResult(this.nf.New(this.pos(), Primary, b.toType(), ArgumentListopt, ClassBodyopt));
                break;
            }
            case 485: {
                ParsedName AmbiguousName = (ParsedName)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(4);
                List ArgumentListopt = (List)this.getRhsSym(6);
                ClassBody ClassBodyopt = (ClassBody)this.getRhsSym(8);
                ParsedName b = new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier);
                if (ClassBodyopt == null) {
                    this.setResult(this.nf.New(this.pos(), AmbiguousName.toExpr(), b.toType(), ArgumentListopt));
                    break;
                }
                this.setResult(this.nf.New(this.pos(), AmbiguousName.toExpr(), b.toType(), ArgumentListopt, ClassBodyopt));
                break;
            }
            case 486: {
                Expr Primary = (Expr)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                List ArgumentListopt = (List)this.getRhsSym(5);
                this.setResult(this.nf.Call(this.pos(), (Receiver)Primary, identifier, ArgumentListopt));
                break;
            }
            case 487: {
                Id identifier = (Id)this.getRhsSym(3);
                List ArgumentListopt = (List)this.getRhsSym(5);
                this.setResult(this.nf.Call(this.pos(), (Receiver)this.nf.Super(this.pos(this.getLeftSpan())), identifier, ArgumentListopt));
                break;
            }
            case 488: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                IToken sup = this.getRhsIToken(3);
                Id identifier = (Id)this.getRhsSym(5);
                List ArgumentListopt = (List)this.getRhsSym(7);
                this.setResult(this.nf.Call(this.pos(), (Receiver)this.nf.Super(this.pos(this.getRhsFirstTokenIndex(3)), ClassName.toType()), identifier, ArgumentListopt));
                break;
            }
            case 492: {
                TypeNode Type8 = (TypeNode)this.getRhsSym(1);
                List Annotations = (List)this.getRhsSym(2);
                TypeNode tn = Type8;
                this.setResult(tn);
                break;
            }
            case 493: {
                TypeNode ResultType = (TypeNode)this.getRhsSym(3);
                FutureNode t = this.nf.FutureNode(this.pos(), ResultType);
                this.setResult(t);
                break;
            }
            case 496: {
                TypeNode NumericType = (TypeNode)this.getRhsSym(1);
                this.setResult(NumericType);
                break;
            }
            case 497: {
                HjTypeNode res = (HjTypeNode)this.nf.CanonicalTypeNode(this.pos(), this.ts.Boolean());
                this.setResult(res);
                break;
            }
            case 498: {
                HjTypeNode res = (HjTypeNode)this.nf.CanonicalTypeNode(this.pos(), (Type)this.ts.Complex32());
                this.setResult(res);
                break;
            }
            case 499: {
                HjTypeNode res = (HjTypeNode)this.nf.CanonicalTypeNode(this.pos(), (Type)this.ts.Complex64());
                this.setResult(res);
                break;
            }
            case 504: {
                HjTypeNode type;
                ParsedName TypeName = (ParsedName)this.getRhsSym(1);
                List TypeArgumentsopt = (List)this.getRhsSym(2);
                Object PlaceTypeSpecifieropt = this.getRhsSym(3);
                if (this.ts.isPrimitiveTypeName(TypeName.name.id())) {
                    try {
                        type = (HjTypeNode)this.nf.CanonicalTypeNode(this.pos(), this.ts.primitiveForName(TypeName.name.id()));
                    }
                    catch (SemanticException e) {
                        throw new InternalCompilerError("Unable to create primitive type for '" + TypeName.name.id() + "'!");
                    }
                } else {
                    AmbTypeNode type_name = (AmbTypeNode)TypeName.toType();
                    type = (HjTypeNode)this.nf.AmbTypeNode(this.pos(), type_name.prefix(), type_name.name(), TypeArgumentsopt);
                }
                this.setResult(type);
                break;
            }
            case 505: {
                Lit Literal = (Lit)this.getRhsSym(1);
                this.setResult(Literal);
                break;
            }
            case 506: {
                TypeNode Type9 = (TypeNode)this.getRhsSym(1);
                if (Type9 instanceof ParsedName) {
                    ParsedName a = (ParsedName)Type9;
                    this.setResult(this.nf.ClassLit(this.pos(), a.toType()));
                    break;
                }
                if (Type9 instanceof TypeNode) {
                    this.setResult(this.nf.ClassLit(this.pos(), Type9));
                    break;
                }
                if (Type9 instanceof CanonicalTypeNode) {
                    CanonicalTypeNode a = (CanonicalTypeNode)Type9;
                    this.setResult(this.nf.ClassLit(this.pos(), (TypeNode)a));
                    break;
                }
                assert (false);
                break;
            }
            case 507: {
                this.setResult(this.nf.ClassLit(this.pos(), (TypeNode)this.nf.CanonicalTypeNode(this.pos(this.getLeftSpan()), this.ts.Void())));
                break;
            }
            case 508: {
                this.setResult(this.nf.This(this.pos()));
                break;
            }
            case 509: {
                this.setResult(this.nf.Here(this.pos()));
                break;
            }
            case 510: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                this.setResult(this.nf.This(this.pos(), ClassName.toType()));
                break;
            }
            case 511: {
                Expr ConstExpression = (Expr)this.getRhsSym(2);
                this.setResult(ConstExpression);
                break;
            }
            case 512: {
                Expr ConstPrimary = (Expr)this.getRhsSym(1);
                this.setResult(ConstPrimary);
                break;
            }
            case 513: {
                ParsedName ExpressionName = (ParsedName)this.getRhsSym(1);
                this.setResult(ExpressionName.toExpr());
                break;
            }
            case 514: {
                Expr ConstPostfixExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstPostfixExpression);
                break;
            }
            case 515: {
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.POS, ConstUnaryExpression));
                break;
            }
            case 516: {
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.NEG, ConstUnaryExpression));
                break;
            }
            case 517: {
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(2);
                this.setResult(this.nf.Unary(this.pos(), Unary.NOT, ConstUnaryExpression));
                break;
            }
            case 518: {
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstUnaryExpression);
                break;
            }
            case 519: {
                Expr ConstMultiplicativeExpression = (Expr)this.getRhsSym(1);
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstMultiplicativeExpression, Binary.MUL, ConstUnaryExpression));
                break;
            }
            case 520: {
                Expr ConstMultiplicativeExpression = (Expr)this.getRhsSym(1);
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstMultiplicativeExpression, Binary.DIV, ConstUnaryExpression));
                break;
            }
            case 521: {
                Expr ConstMultiplicativeExpression = (Expr)this.getRhsSym(1);
                Expr ConstUnaryExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstMultiplicativeExpression, Binary.MOD, ConstUnaryExpression));
                break;
            }
            case 522: {
                Expr ConstMultiplicativeExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstMultiplicativeExpression);
                break;
            }
            case 523: {
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(1);
                Expr ConstMultiplicativeExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstAdditiveExpression, Binary.ADD, ConstMultiplicativeExpression));
                break;
            }
            case 524: {
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(1);
                Expr ConstMultiplicativeExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstAdditiveExpression, Binary.SUB, ConstMultiplicativeExpression));
                break;
            }
            case 525: {
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstAdditiveExpression);
                break;
            }
            case 526: {
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(1);
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstRelationalExpression, Binary.LT, ConstAdditiveExpression));
                break;
            }
            case 527: {
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(1);
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstRelationalExpression, Binary.GT, ConstAdditiveExpression));
                break;
            }
            case 528: {
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(1);
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstRelationalExpression, Binary.LE, ConstAdditiveExpression));
                break;
            }
            case 529: {
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(1);
                Expr ConstAdditiveExpression = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Binary(this.pos(), ConstRelationalExpression, Binary.GE, ConstAdditiveExpression));
                break;
            }
            case 530: {
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstRelationalExpression);
                break;
            }
            case 531: {
                Expr ConstEqualityExpression = (Expr)this.getRhsSym(1);
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstEqualityExpression, Binary.EQ, ConstRelationalExpression));
                break;
            }
            case 532: {
                Expr ConstEqualityExpression = (Expr)this.getRhsSym(1);
                Expr ConstRelationalExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstEqualityExpression, Binary.NE, ConstRelationalExpression));
                break;
            }
            case 533: {
                Expr ConstEqualityExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstEqualityExpression);
                break;
            }
            case 534: {
                Expr ConstAndExpression = (Expr)this.getRhsSym(1);
                Expr ConstEqualityExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstAndExpression, Binary.COND_AND, ConstEqualityExpression));
                break;
            }
            case 535: {
                Expr ConstAndExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstAndExpression);
                break;
            }
            case 536: {
                Expr ConstExclusiveOrExpression = (Expr)this.getRhsSym(1);
                Expr ConstAndExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstExclusiveOrExpression, Binary.BIT_XOR, ConstAndExpression));
                break;
            }
            case 537: {
                Expr ConstExclusiveOrExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstExclusiveOrExpression);
                break;
            }
            case 538: {
                Expr ConstInclusiveOrExpression = (Expr)this.getRhsSym(1);
                Expr ConstExclusiveOrExpression = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.Binary(this.pos(), ConstInclusiveOrExpression, Binary.COND_OR, ConstExclusiveOrExpression));
                break;
            }
            case 539: {
                Expr ConstInclusiveOrExpression = (Expr)this.getRhsSym(1);
                this.setResult(ConstInclusiveOrExpression);
                break;
            }
            case 540: {
                Expr ConstInclusiveOrExpression = (Expr)this.getRhsSym(1);
                Expr first = (Expr)this.getRhsSym(3);
                Expr ConstExpression = (Expr)this.getRhsSym(5);
                this.setResult(this.nf.Conditional(this.pos(), ConstInclusiveOrExpression, first, ConstExpression));
                break;
            }
            case 541: {
                Expr ConstPrimary = (Expr)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(this.nf.Field(this.pos(), (Receiver)ConstPrimary, identifier));
                break;
            }
            case 542: {
                Id identifier = (Id)this.getRhsSym(3);
                this.setResult(this.nf.Field(this.pos(this.getRightSpan()), (Receiver)this.nf.Super(this.pos(this.getLeftSpan())), identifier));
                break;
            }
            case 543: {
                ParsedName ClassName = (ParsedName)this.getRhsSym(1);
                IToken sup = this.getRhsIToken(3);
                Id identifier = (Id)this.getRhsSym(5);
                this.setResult(this.nf.Field(this.pos(this.getRightSpan()), (Receiver)this.nf.Super(this.pos(this.getRhsFirstTokenIndex(3)), ClassName.toType()), identifier));
                break;
            }
            case 545: {
                TypeNode Type10 = (TypeNode)this.getRhsSym(1);
                this.setResult(this.nf.HjArrayViewTypeNode(this.pos(), Type10, false));
                break;
            }
            case 546: {
                TypeNode Type11 = (TypeNode)this.getRhsSym(1);
                this.setResult(this.nf.HjArrayViewTypeNode(this.pos(), Type11, true));
                break;
            }
            case 547: {
                throw new Error("No action specified for rule 547");
            }
            case 548: {
                throw new Error("No action specified for rule 548");
            }
            case 549: {
                this.setResult(Collections.singletonList(Flags.NATIVE));
                break;
            }
            case 550: {
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "safe method modifier is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(Collections.singletonList(HjFlags.SAFE));
                break;
            }
            case 551: {
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "sequential method modifier is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(Collections.singletonList(HjFlags.SEQUENTIAL));
                break;
            }
            case 552: {
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "local method modifier is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(Collections.singletonList(HjFlags.LOCAL));
                break;
            }
            case 553: {
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "nonblocking method modifier is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(Collections.singletonList(HjFlags.NON_BLOCKING));
                break;
            }
            case 555: {
                List HjClassModifiersopt = (List)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                List TypeParametersopt = (List)this.getRhsSym(4);
                TypeNode Superopt = (TypeNode)this.getRhsSym(5);
                List Interfacesopt = (List)this.getRhsSym(6);
                ClassBody ClassBody3 = (ClassBody)this.getRhsSym(7);
                this.checkTypeName(identifier);
                ValueClassDecl cd = this.nf.ValueClassDecl((Position)this.pos(this.getLeftSpan(), this.getRightSpan()), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), HjClassModifiersopt), identifier, Superopt, (List<TypeNode>)Interfacesopt, ClassBody3, TypeParametersopt);
                this.setResult(cd);
                break;
            }
            case 556: {
                List HjClassModifiersopt = (List)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(4);
                List TypeParametersopt = (List)this.getRhsSym(5);
                TypeNode Superopt = (TypeNode)this.getRhsSym(6);
                List Interfacesopt = (List)this.getRhsSym(7);
                ClassBody ClassBody4 = (ClassBody)this.getRhsSym(8);
                this.checkTypeName(identifier);
                ValueClassDecl cd = this.nf.ValueClassDecl((Position)this.pos(this.getLeftSpan(), this.getRightSpan()), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), HjClassModifiersopt), identifier, Superopt, (List<TypeNode>)Interfacesopt, ClassBody4, TypeParametersopt);
                this.setResult(cd);
                break;
            }
            case 557: {
                List ConstructorModifiersopt = (List)this.getRhsSym(1);
                Object[] ConstructorDeclarator = (Object[])this.getRhsSym(2);
                List Throwsopt = (List)this.getRhsSym(3);
                Block ConstructorBody = (Block)this.getRhsSym(4);
                ParsedName a = (ParsedName)ConstructorDeclarator[1];
                List b = (List)ConstructorDeclarator[2];
                List n = (List)ConstructorDeclarator[3];
                ConstructorDecl cd = this.nf.ConstructorDecl(this.pos(), this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), ConstructorModifiersopt), this.nf.Id(this.pos(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2)), a.toString()), b, Throwsopt, ConstructorBody);
                this.setResult(cd);
                break;
            }
            case 558: {
                ParsedName SimpleTypeName = (ParsedName)this.getRhsSym(1);
                List Annotationsopt = (List)this.getRhsSym(2);
                List FormalParameterListopt = (List)this.getRhsSym(4);
                Object[] a = new Object[4];
                a[1] = SimpleTypeName;
                a[2] = FormalParameterListopt;
                a[3] = Annotationsopt;
                this.setResult(a);
                break;
            }
            case 559: {
                TypeNode DataType = (TypeNode)this.getRhsSym(2);
                this.setResult(DataType);
                break;
            }
            case 560: {
                Id identifier = (Id)this.getRhsSym(1);
                List FormalParameterListopt = (List)this.getRhsSym(3);
                Object[] a = new Object[]{new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier), FormalParameterListopt, new Integer(0)};
                this.setResult(a);
                break;
            }
            case 561: {
                Object[] MethodDeclarator = (Object[])this.getRhsSym(1);
                MethodDeclarator[2] = new Integer((Integer)MethodDeclarator[2] + 1);
                break;
            }
            case 562: {
                List FieldModifiersopt = (List)this.getRhsSym(1);
                TypeNode Type12 = (TypeNode)this.getRhsSym(2);
                List VariableDeclarators = (List)this.getRhsSym(3);
                TypedList l = new TypedList(new LinkedList(), ClassMember.class, false);
                if (VariableDeclarators != null && VariableDeclarators.size() > 0) {
                    boolean gt1 = VariableDeclarators.size() > 1;
                    for (HjVarDeclarator d : VariableDeclarators) {
                        if (d.hasExplodedVars()) {
                            throw new Error("Field Declarations may not have exploded variables." + (Object)((Object)this.pos()));
                        }
                        Position p = gt1 ? d.position() : this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(3));
                        d.setFlag(this.extractFlags(this.pos(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1)), FieldModifiersopt));
                        FieldDecl fd = this.nf.FieldDecl(p, d.flags, this.nf.array(Type12, Type12.position(), d.dims), d.name, d.init);
                        l.add(fd);
                    }
                }
                this.setResult(l);
                break;
            }
            case 563: {
                TypeNode ArrayBaseType = (TypeNode)this.getRhsSym(2);
                Object Unsafeopt = this.getRhsSym(3);
                Integer Dims = (Integer)this.getRhsSym(4);
                ArrayInit ArrayInitializer = (ArrayInit)this.getRhsSym(5);
                this.setResult(this.nf.NewArray(this.pos(), ArrayBaseType, Dims, ArrayInitializer));
                break;
            }
            case 564: {
                TypeNode ArrayBaseType = (TypeNode)this.getRhsSym(2);
                Object Unsafeopt = this.getRhsSym(3);
                Expr DimExpr = (Expr)this.getRhsSym(4);
                Integer Dimsopt = (Integer)this.getRhsSym(5);
                this.setResult(this.nf.NewArray(this.pos(), ArrayBaseType, Collections.singletonList(DimExpr), Dimsopt));
                break;
            }
            case 565: {
                TypeNode ArrayBaseType = (TypeNode)this.getRhsSym(2);
                Object Unsafeopt = this.getRhsSym(3);
                Expr DimExpr = (Expr)this.getRhsSym(4);
                List DimExprs = (List)this.getRhsSym(5);
                Integer Dimsopt = (Integer)this.getRhsSym(6);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(DimExpr);
                l.addAll(DimExprs);
                this.setResult(this.nf.NewArray(this.pos(), ArrayBaseType, (List)l, Dimsopt));
                break;
            }
            case 566: {
                this.setResult(null);
                break;
            }
            case 567: {
                this.setResult(this);
                break;
            }
            case 571: {
                TypeNode Type13 = (TypeNode)this.getRhsSym(2);
                this.setResult(Type13);
                break;
            }
            case 572: {
                ParsedName ExpressionName = (ParsedName)this.getRhsSym(1);
                List ArgumentList = (List)this.getRhsSym(3);
                if (ArgumentList.size() == 1) {
                    this.setResult(this.nf.HjArrayAccess1(this.pos(), ExpressionName.toExpr(), (Expr)ArgumentList.get(0)));
                    break;
                }
                this.setResult(this.nf.HjArrayAccess(this.pos(), ExpressionName.toExpr(), ArgumentList));
                break;
            }
            case 573: {
                Expr PrimaryNoNewArray = (Expr)this.getRhsSym(1);
                List ArgumentList = (List)this.getRhsSym(3);
                if (ArgumentList.size() == 1) {
                    this.setResult(this.nf.HjArrayAccess1(this.pos(), PrimaryNoNewArray, (Expr)ArgumentList.get(0)));
                    break;
                }
                this.setResult(this.nf.HjArrayAccess(this.pos(), PrimaryNoNewArray, ArgumentList));
                break;
            }
            case 591: {
                Expr Phaser = (Expr)this.getRhsSym(3);
                Stmt Statement = (Stmt)this.getRhsSym(5);
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "now statement is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.Now(this.pos(), Phaser, Statement));
                break;
            }
            case 592: {
                List PhaserList = (List)this.getRhsSym(3);
                this.setResult(PhaserList);
                break;
            }
            case 593: {
                this.setResult(new TypedList(new LinkedList(), Expr.class, false));
                break;
            }
            case 594: {
                List DDFList = (List)this.getRhsSym(3);
                this.setResult(DDFList);
                break;
            }
            case 595: {
                Expr Expression = (Expr)this.getRhsSym(3);
                this.setResult(Expression);
                break;
            }
            case 596: {
                Expr Expression = (Expr)this.getRhsSym(3);
                this.setResult(Expression);
                break;
            }
            case 597: {
                String clauseTypeError;
                TypeNode ResultType = (TypeNode)this.getRhsSym(3);
                AsyncClauseList AsyncClauseListopt = (AsyncClauseList)this.getRhsSym(5);
                Stmt Statement = (Stmt)this.getRhsSym(6);
                boolean hasExplicitPlaceClause = AsyncClauseListopt.hasPlaceClause();
                if (!hasExplicitPlaceClause) {
                    AsyncClauseListopt.add(this.nf.AsyncClausePlace(this.nf.Here(this.pos(this.getLeftSpan()))));
                }
                if ((clauseTypeError = AsyncClauseListopt.checkDuplicatedClauses()) != null) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "Syntax error async can only have one " + clauseTypeError + " clause", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.AsyncWithReturn(this.pos(), ResultType, AsyncClauseListopt, Statement, hasExplicitPlaceClause));
                break;
            }
            case 598: {
                String clauseTypeError;
                AsyncClauseList AsyncClauseListopt = (AsyncClauseList)this.getRhsSym(2);
                Stmt Statement = (Stmt)this.getRhsSym(3);
                boolean hasExplicitPlaceClause = AsyncClauseListopt.hasPlaceClause();
                if (!hasExplicitPlaceClause) {
                    AsyncClauseListopt.add(this.nf.AsyncClausePlace(this.nf.Here(this.pos(this.getLeftSpan()))));
                }
                if ((clauseTypeError = AsyncClauseListopt.checkDuplicatedClauses()) != null) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "Syntax error async can only have one " + clauseTypeError + " clause", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.Async(this.pos(), (TypeNode)this.nf.CanonicalTypeNode(this.pos(), this.ts.Void()), AsyncClauseListopt, Statement, hasExplicitPlaceClause));
                break;
            }
            case 600: {
                Stmt Statement = (Stmt)this.getRhsSym(2);
                this.setResult(this.nf.Isolated(this.pos(), new LinkedList(), Statement));
                break;
            }
            case 601: {
                List ArgumentList = (List)this.getRhsSym(3);
                Stmt Statement = (Stmt)this.getRhsSym(5);
                this.setResult(this.nf.Isolated(this.pos(), ArgumentList, Statement));
                break;
            }
            case 602: {
                Stmt Statement = (Stmt)this.getRhsSym(3);
                this.setResult(this.nf.NextWithSingle(this.pos(), Statement));
                break;
            }
            case 603: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                List PhasedClauseopt = (List)this.getRhsSym(7);
                Stmt Statement = (Stmt)this.getRhsSym(8);
                this.setResult(this.nf.ForEach(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, PhasedClauseopt, Statement));
                break;
            }
            case 604: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                List PhasedClauseopt = (List)this.getRhsSym(7);
                Stmt Statement = (Stmt)this.getRhsSym(8);
                this.setResult(this.nf.ForAll(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, PhasedClauseopt, Statement));
                break;
            }
            case 605: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                List PhasedClauseopt = (List)this.getRhsSym(7);
                Stmt Statement = (Stmt)this.getRhsSym(8);
                this.setResult(this.nf.AtEach(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, PhasedClauseopt, Statement));
                break;
            }
            case 606: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                Stmt Statement = (Stmt)this.getRhsSym(7);
                this.setResult(this.nf.ForLoop(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, Statement));
                break;
            }
            case 607: {
                List Accumulatorsopt = (List)this.getRhsSym(2);
                Stmt Statement = (Stmt)this.getRhsSym(3);
                this.setResult(this.nf.Finish(this.pos(), Accumulatorsopt, Statement));
                break;
            }
            case 608: {
                Expr Phaser = (Expr)this.getRhsSym(3);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(5);
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "now statement is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.Now(this.pos(), Phaser, StatementNoShortIf));
                break;
            }
            case 609: {
                String clauseTypeError;
                AsyncClauseList AsyncClauseListopt = (AsyncClauseList)this.getRhsSym(2);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(3);
                boolean hasExplicitPlaceClause = AsyncClauseListopt.hasPlaceClause();
                if (!hasExplicitPlaceClause) {
                    AsyncClauseListopt.add(this.nf.AsyncClausePlace(this.nf.Here(this.pos(this.getLeftSpan()))));
                }
                if ((clauseTypeError = AsyncClauseListopt.checkDuplicatedClauses()) != null) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "Syntax error async can only have one " + clauseTypeError + " clause", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.Async(this.pos(), (TypeNode)this.nf.CanonicalTypeNode(this.pos(), this.ts.Void()), AsyncClauseListopt, StatementNoShortIf, hasExplicitPlaceClause));
                break;
            }
            case 610: {
                String clauseTypeError;
                TypeNode ResultType = (TypeNode)this.getRhsSym(3);
                AsyncClauseList AsyncClauseListopt = (AsyncClauseList)this.getRhsSym(5);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(6);
                boolean hasExplicitPlaceClause = AsyncClauseListopt.hasPlaceClause();
                if (!hasExplicitPlaceClause) {
                    AsyncClauseListopt.add(this.nf.AsyncClausePlace(this.nf.Here(this.pos(this.getLeftSpan()))));
                }
                if ((clauseTypeError = AsyncClauseListopt.checkDuplicatedClauses()) != null) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "Syntax error async can only have one " + clauseTypeError + " clause", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.AsyncWithReturn(this.pos(), ResultType, AsyncClauseListopt, StatementNoShortIf, hasExplicitPlaceClause));
                break;
            }
            case 611: {
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(2);
                this.setResult(this.nf.Isolated(this.pos(), new LinkedList(), StatementNoShortIf));
                break;
            }
            case 612: {
                List ArgumentList = (List)this.getRhsSym(3);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(5);
                this.setResult(this.nf.Isolated(this.pos(), ArgumentList, StatementNoShortIf));
                break;
            }
            case 613: {
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(3);
                this.setResult(this.nf.NextWithSingle(this.pos(), StatementNoShortIf));
                break;
            }
            case 614: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                List PhasedClauseopt = (List)this.getRhsSym(7);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(8);
                this.setResult(this.nf.ForEach(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, PhasedClauseopt, StatementNoShortIf));
                break;
            }
            case 615: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                List PhasedClauseopt = (List)this.getRhsSym(7);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(8);
                this.setResult(this.nf.ForAll(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, PhasedClauseopt, StatementNoShortIf));
                break;
            }
            case 616: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                List PhasedClauseopt = (List)this.getRhsSym(7);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(8);
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "ateach statement is not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                this.setResult(this.nf.AtEach(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, PhasedClauseopt, StatementNoShortIf));
                break;
            }
            case 617: {
                HjFormal FormalParameter = (HjFormal)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(7);
                this.setResult(this.nf.ForLoop(this.pos(), FormalParameter.flags(FormalParameter.flags().flags(FormalParameter.flags().flags().Final())), Expression, StatementNoShortIf));
                break;
            }
            case 618: {
                List Accumulatorsopt = (List)this.getRhsSym(2);
                Stmt StatementNoShortIf = (Stmt)this.getRhsSym(3);
                this.setResult(this.nf.Finish(this.pos(), Accumulatorsopt, StatementNoShortIf));
                break;
            }
            case 619: {
                Expr PlaceExpression = (Expr)this.getRhsSym(3);
                this.setResult(PlaceExpression);
                break;
            }
            case 621: {
                this.setResult(this.nf.Next(this.pos()));
                break;
            }
            case 622: {
                this.setResult(this.nf.Signal(this.pos()));
                break;
            }
            case 623: {
                this.setResult(this.nf.Wait(this.pos()));
                break;
            }
            case 624: {
                this.setResult(new AsyncClauseList());
                break;
            }
            case 625: {
                AsyncClauseList AsyncClauseListopt = (AsyncClauseList)this.getRhsSym(1);
                AsyncClause AsyncClauseExpr = (AsyncClause)this.getRhsSym(2);
                AsyncClauseListopt.add(AsyncClauseExpr);
                this.setResult(AsyncClauseListopt);
                break;
            }
            case 626: {
                AsyncClause AsyncPlaceClause = (AsyncClause)this.getRhsSym(1);
                this.setResult(AsyncPlaceClause);
                break;
            }
            case 627: {
                AsyncClause AsyncSeqClause = (AsyncClause)this.getRhsSym(1);
                this.setResult(AsyncSeqClause);
                break;
            }
            case 628: {
                AsyncClause AsyncAwaitClause = (AsyncClause)this.getRhsSym(1);
                this.setResult(AsyncAwaitClause);
                break;
            }
            case 629: {
                AsyncClause AsyncPhasedClause = (AsyncClause)this.getRhsSym(1);
                this.setResult(AsyncPhasedClause);
                break;
            }
            case 630: {
                AsyncClause AsyncDelayClause = (AsyncClause)this.getRhsSym(1);
                this.setResult(AsyncDelayClause);
                break;
            }
            case 631: {
                Expr PlaceClause = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.AsyncClausePlace(PlaceClause));
                break;
            }
            case 632: {
                Expr SeqClause = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.AsyncClauseSeq(SeqClause));
                break;
            }
            case 633: {
                List PhasedClause = (List)this.getRhsSym(1);
                this.setResult(this.nf.AsyncClausePhaser(PhasedClause));
                break;
            }
            case 634: {
                List AwaitClause = (List)this.getRhsSym(1);
                this.setResult(this.nf.AsyncClauseAwait(AwaitClause));
                break;
            }
            case 635: {
                Expr WhenClause = (Expr)this.getRhsSym(1);
                this.setResult(this.nf.AsyncClauseWhen(WhenClause));
                break;
            }
            case 636: {
                Expr DDF = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(DDF);
                this.setResult(l);
                break;
            }
            case 637: {
                List DDFList = (List)this.getRhsSym(1);
                Expr DDF = (Expr)this.getRhsSym(3);
                DDFList.add(DDF);
                this.setResult(DDFList);
                break;
            }
            case 638: {
                Expr UnaryExpressionNotPlusMinus = (Expr)this.getRhsSym(1);
                this.setResult(UnaryExpressionNotPlusMinus);
                break;
            }
            case 639: {
                Expr Phaser = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(this.nf.Field(this.pos(), (Receiver)this.nf.TypeNodeFromQualifiedName(this.pos(), QName.make((String)"hj.lang.phaserMode")), this.nf.Id(this.pos(), "SIG_WAIT_SINGLE")));
                l.add(Phaser);
                this.setResult(l);
                break;
            }
            case 640: {
                List PhaserList = (List)this.getRhsSym(1);
                Expr Phaser = (Expr)this.getRhsSym(3);
                PhaserList.add(this.nf.Field(this.pos(), (Receiver)this.nf.TypeNodeFromQualifiedName(this.pos(), QName.make((String)"hj.lang.phaserMode")), this.nf.Id(this.pos(), "SIG_WAIT_SINGLE")));
                PhaserList.add(Phaser);
                this.setResult(PhaserList);
                break;
            }
            case 641: {
                Expr Phaser = (Expr)this.getRhsSym(1);
                Expr Expression = (Expr)this.getRhsSym(3);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(Expression);
                l.add(Phaser);
                this.setResult(l);
                break;
            }
            case 642: {
                List PhaserList = (List)this.getRhsSym(1);
                Expr Phaser = (Expr)this.getRhsSym(3);
                Expr Expression = (Expr)this.getRhsSym(5);
                PhaserList.add(Expression);
                PhaserList.add(Phaser);
                this.setResult(PhaserList);
                break;
            }
            case 643: {
                Expr UnaryExpressionNotPlusMinus = (Expr)this.getRhsSym(1);
                this.setResult(UnaryExpressionNotPlusMinus);
                break;
            }
            case 644: {
                TypeNode PrimitiveType2 = (TypeNode)this.getRhsSym(2);
                Expr UnaryExpression = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Cast(this.pos(), PrimitiveType2, UnaryExpression));
                break;
            }
            case 645: {
                TypeNode SpecialType = (TypeNode)this.getRhsSym(2);
                Expr UnaryExpressionNotPlusMinus = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Cast(this.pos(), SpecialType, UnaryExpressionNotPlusMinus));
                break;
            }
            case 646: {
                TypeNode ReferenceType = (TypeNode)this.getRhsSym(2);
                Expr UnaryExpressionNotPlusMinus = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Cast(this.pos(), ReferenceType, UnaryExpressionNotPlusMinus));
                break;
            }
            case 647: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Expr UnaryExpressionNotPlusMinus = (Expr)this.getRhsSym(5);
                this.setResult(this.nf.PlaceCast(this.pos(), Expression, UnaryExpressionNotPlusMinus));
                break;
            }
            case 648: {
                TypeNode AnnotatedType2 = (TypeNode)this.getRhsSym(2);
                Expr UnaryExpression = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.Cast(this.pos(), AnnotatedType2, UnaryExpression));
                break;
            }
            case 649: {
                Expr UnaryExpressionNotPlusMinus;
                List Annotations = (List)this.getRhsSym(2);
                Expr e = UnaryExpressionNotPlusMinus = (Expr)this.getRhsSym(4);
                this.setResult(e);
                break;
            }
            case 650: {
                Expr RelationalExpression = (Expr)this.getRhsSym(1);
                TypeNode Type14 = (TypeNode)this.getRhsSym(3);
                this.setResult(this.nf.Instanceof(this.pos(), RelationalExpression, Type14));
                break;
            }
            case 651: {
                Id identifier = (Id)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), ParsedName.class, false);
                l.add(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                this.setResult(l);
                break;
            }
            case 652: {
                List IdentifierList = (List)this.getRhsSym(1);
                Id identifier = (Id)this.getRhsSym(3);
                IdentifierList.add(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                this.setResult(IdentifierList);
                break;
            }
            case 653: {
                this.setResult(this.nf.Here(this.pos()));
                break;
            }
            case 656: {
                Expr expr1 = (Expr)this.getRhsSym(1);
                Expr expr2 = (Expr)this.getRhsSym(3);
                RegionMaker regionCall = this.nf.RegionMaker(this.pos(), expr1, expr2);
                this.setResult(regionCall);
                break;
            }
            case 657: {
                Expr RegionExpression = (Expr)this.getRhsSym(1);
                TypedList l = new TypedList(new LinkedList(), Expr.class, false);
                l.add(RegionExpression);
                this.setResult(l);
                break;
            }
            case 658: {
                List RegionExpressionList = (List)this.getRhsSym(1);
                Expr RegionExpression = (Expr)this.getRhsSym(3);
                RegionExpressionList.add(RegionExpression);
                break;
            }
            case 659: {
                List RegionExpressionList = (List)this.getRhsSym(2);
                Receiver hjLangPointFactory = this.nf.ReceiverFromQualifiedName(this.pos(), QName.make((String)"hj.lang.point.factory"));
                Receiver hjLangRegionFactory = this.nf.ReceiverFromQualifiedName(this.pos(), QName.make((String)"hj.lang.region.factory"));
                Tuple tuple = this.nf.Tuple(this.pos(), hjLangPointFactory, hjLangRegionFactory, RegionExpressionList);
                this.setResult(tuple);
                break;
            }
            case 660: {
                Expr expr1 = (Expr)this.getRhsSym(1);
                Expr expr2 = (Expr)this.getRhsSym(3);
                if (Configuration.HJ) {
                    this.unrecoverableSyntaxError = true;
                    this.eq.enqueue(4, "distribution expressions are currently not supported in Habanero-Java", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                }
                ConstantDistMaker call = this.nf.ConstantDistMaker(this.pos(), expr1, expr2);
                this.setResult(call);
                break;
            }
            case 663: {
                Expr expr1 = (Expr)this.getRhsSym(2);
                Expr expr2 = (Expr)this.getRhsSym(4);
                this.setResult(this.nf.HjComplexConstructor(this.pos(), expr1, expr2));
                break;
            }
            case 664: {
                Expr complex = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.ComplexAccessor(this.pos(), ComplexOperation.REAL, complex));
                break;
            }
            case 665: {
                Expr complex = (Expr)this.getRhsSym(3);
                this.setResult(this.nf.ComplexAccessor(this.pos(), ComplexOperation.IMAG, complex));
                break;
            }
            case 666: {
                this.setResult(Collections.singletonList(HjFlags.MUTABLE));
                break;
            }
            case 667: {
                this.setResult(Collections.singletonList(Flags.PUBLIC.set(Flags.STATIC).set(Flags.FINAL)));
                break;
            }
            case 668: {
                throw new Error("No action specified for rule 668");
            }
            case 669: {
                throw new Error("No action specified for rule 669");
            }
            case 670: {
                throw new Error("No action specified for rule 670");
            }
            case 671: {
                throw new Error("No action specified for rule 671");
            }
            case 672: {
                throw new Error("No action specified for rule 672");
            }
            case 673: {
                throw new Error("No action specified for rule 673");
            }
            case 674: {
                throw new Error("No action specified for rule 674");
            }
            case 675: {
                throw new Error("No action specified for rule 675");
            }
            case 676: {
                throw new Error("No action specified for rule 676");
            }
            case 677: {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(4, "\"synchronized\" is an invalid Hj Method Modifier", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                this.setResult(Collections.singletonList(Flags.SYNCHRONIZED));
                break;
            }
            case 678: {
                this.unrecoverableSyntaxError = true;
                this.eq.enqueue(4, "\"volatile\" is an invalid Hj Field Modifier", this.getErrorPosition(this.getLeftSpan(), this.getRightSpan()));
                this.setResult(Collections.singletonList(Flags.VOLATILE));
                break;
            }
            case 679: {
                Expr Expression = (Expr)this.getRhsSym(3);
                Block Block7 = (Block)this.getRhsSym(5);
                this.unrecoverableSyntaxError = true;
                this.setResult(this.nf.Synchronized(this.pos(), Expression, Block7));
                break;
            }
            case 680: {
                this.setResult(new TypedList(new LinkedList(), Expr.class, false));
                break;
            }
            case 681: {
                List ArgumentList = (List)this.getRhsSym(2);
                this.setResult(ArgumentList);
                break;
            }
            case 682: {
                this.setResult(null);
                break;
            }
            case 684: {
                this.setResult(null);
                break;
            }
            case 686: {
                this.setResult(null);
                break;
            }
            case 688: {
                this.setResult(null);
                break;
            }
            case 690: {
                this.setResult(null);
                break;
            }
            case 692: {
                this.setResult(Collections.singletonList(HjFlags.toHjFlags(Flags.NONE)));
                break;
            }
            case 694: {
                this.setResult(null);
                break;
            }
            case 695: {
                this.setResult(this);
                break;
            }
            case 696: {
                this.setResult(null);
                break;
            }
            case 697: {
                Id identifier = (Id)this.getRhsSym(1);
                this.setResult(new ParsedName((NodeFactory)this.nf, (TypeSystem)this.ts, (Position)this.pos(), identifier));
                break;
            }
            case 698: {
                this.setResult(null);
                break;
            }
            case 700: {
                this.setResult(null);
                break;
            }
        }
    }

    public static class JPGPosition
    extends Position {
        private static final long serialVersionUID = -1593187800129872262L;
        private final transient IToken leftIToken;
        private final transient IToken rightIToken;

        public JPGPosition(String path, String filename, IToken leftToken, IToken rightToken) {
            super(path, filename, leftToken.getLine(), leftToken.getColumn(), rightToken.getEndLine(), rightToken.getEndColumn(), leftToken.getStartOffset(), rightToken.getEndOffset());
            this.leftIToken = leftToken;
            this.rightIToken = rightToken;
        }

        public IToken getLeftIToken() {
            return this.leftIToken;
        }

        public IToken getRightIToken() {
            return this.rightIToken;
        }

        public String toText() {
            IPrsStream prsStream = this.leftIToken.getPrsStream();
            return new String(prsStream.getInputChars(), this.offset(), this.endOffset() - this.offset() + 1);
        }
    }
}

