/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.AsyncBlock_c;
import polyglot.ext.hj.ast.AsyncClauseList;
import polyglot.ext.hj.ast.AwaitableChecker;
import polyglot.ext.hj.ast.FutureNode;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.Phased;
import polyglot.ext.hj.ast.PhasedChecker;
import polyglot.ext.hj.ast.RemoteActivityInvocation;
import polyglot.ext.hj.types.AsyncDef;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.main.Report;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public class Async_c
extends Expr_c
implements Async,
CompoundStmt {
    protected Expr place;
    protected Expr seqCond;
    protected Stmt body;
    protected List phasers;
    protected List awaitables;
    protected Expr whenCondExpr;
    protected FutureNode returnType;
    protected boolean isAsyncWithReturn;
    protected AsyncDef ai;
    protected boolean hasExplicitPlaceClause;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context", (Object[])new String[0]);

    public Async_c(Position pos, FutureNode returnType, AsyncClauseList clauses, Stmt body, boolean isAsyncWithReturn, boolean hasExplicitPlaceClause) {
        super(pos);
        assert (clauses != null);
        assert (returnType instanceof FutureNode);
        this.returnType = returnType;
        this.body = body;
        this.isAsyncWithReturn = isAsyncWithReturn;
        this.place = clauses.getPlaceClause();
        this.phasers = clauses.getPhasedClause();
        this.whenCondExpr = clauses.getWhenClause();
        this.seqCond = clauses.getSeqClause();
        this.awaitables = clauses.getAwaitClause();
        this.hasExplicitPlaceClause = hasExplicitPlaceClause;
        assert (this.place != null);
    }

    private Block asAsyncBlock(Stmt statement) {
        List l;
        if (statement == null) {
            return (Block)statement;
        }
        if (statement instanceof Block) {
            Block b = (Block)statement;
            l = b.statements();
        } else {
            l = Collections.singletonList(statement);
        }
        return new AsyncBlock_c(statement.position(), l);
    }

    public Stmt body() {
        return this.body;
    }

    public boolean hasExplicitPlaceClause() {
        return this.hasExplicitPlaceClause;
    }

    public boolean hasSeqCond() {
        return this.seqCond != null;
    }

    public Expr seqCond() {
        return this.seqCond;
    }

    public Async seqCond(Expr seqCond) {
        if (seqCond != this.seqCond) {
            Async_c n = (Async_c)this.copy();
            n.seqCond = seqCond;
            return n;
        }
        return this;
    }

    public List phasers() {
        return this.phasers;
    }

    public List dataDrivenFutureList() {
        return this.awaitables;
    }

    public Phased phasers(List phasers) {
        Async_c n = (Async_c)this.copy();
        n.phasers = phasers;
        return n;
    }

    public Async body(Stmt body) {
        Async_c n = (Async_c)this.copy();
        n.body = body;
        return n;
    }

    public Expr cond() {
        return this.whenCondExpr;
    }

    public Expr place() {
        return this.place;
    }

    public RemoteActivityInvocation place(Expr place) {
        if (place != this.place) {
            Async_c n = (Async_c)this.copy();
            n.place = place;
            return n;
        }
        return this;
    }

    public Async asyncDef(AsyncDef ai) {
        if (ai == this.ai) {
            return this;
        }
        Async_c n = (Async_c)this.copy();
        n.ai = ai;
        return n;
    }

    protected Async reconstruct(FutureNode returnType, Expr place, Expr seqCond, List phasers, Stmt body, Expr condExpr, List dataDrivenFutureList) {
        if (returnType != this.returnType || place != this.place || seqCond != this.seqCond || body != this.body || phasers != this.phasers || condExpr != this.whenCondExpr || dataDrivenFutureList != this.awaitables) {
            Async_c n = (Async_c)this.copy();
            n.returnType = returnType;
            n.place = place;
            n.seqCond = seqCond;
            n.phasers = phasers;
            n.body = body;
            n.whenCondExpr = condExpr;
            n.awaitables = dataDrivenFutureList;
            n.isAsyncWithReturn = this.isAsyncWithReturn;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr place = (Expr)this.visitChild((Node)this.place, v);
        Expr seqCond = (Expr)this.visitChild((Node)this.seqCond, v);
        FutureNode returnType = (FutureNode)this.visitChild((Node)this.returnType, v);
        List phasers = this.visitList(this.phasers, v);
        List dataDrivenFutureList = this.visitList(this.awaitables, v);
        Expr condExpr = (Expr)this.visitChild((Node)this.whenCondExpr, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(returnType, place, seqCond, phasers, body, condExpr, dataDrivenFutureList);
    }

    public Context enterScope(Context c) {
        if (Report.should_report((Collection)TOPICS, (int)5)) {
            Report.report((int)5, (String)"enter async scope");
        }
        HjTypeSystem ts = (HjTypeSystem)c.typeSystem();
        if (c.inStaticContext()) {
            this.ai.setFlags(ts.Public().Static());
        }
        c = ((HjContext)c).pushAsync((CodeDef)this.ai, this.isAsyncWithReturn());
        return c;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tb.typeSystem();
        AsyncDef ai = this.isAsyncWithReturn ? xts.createAsyncWithReturnDef((Ref<? extends Type>)this.returnType().typeRef()) : xts.createAsyncDef((Ref<? extends Type>)this.returnType().typeRef());
        return this.asyncDef(ai);
    }

    public TypeNode returnType() {
        return this.returnType;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.whenCondExpr) {
            return ((HjContext)c).pushWhenBlock();
        }
        if (child != this.body) {
            c = c.pop();
        }
        return c;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjContext c;
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        Context ctx = tc.context();
        if (this.whenCondExpr != null && !this.whenCondExpr.type().isBoolean()) {
            throw new SemanticException("Conditional expression must be of Boolean type", this.position());
        }
        if (this.seqCond != null && !this.seqCond.type().isBoolean()) {
            throw new SemanticException("seq condition expression must be of Boolean type", this.position());
        }
        Type placeType = this.place.type();
        boolean placeIsPlace = ts.isImplicitCastValid(placeType, (Type)ts.place(), tc.context());
        if (!placeIsPlace) {
            if (ts.isCastValid(placeType, (Type)ts.HjObject(), ctx) && !placeType.isPrimitive()) {
                this.place = (Expr)nf.Field(this.position(), (Receiver)this.place, nf.Id(this.position(), "location")).del().typeCheck(tc);
            } else {
                throw new SemanticException("place expression must be of type hj.lang.place or inherit hj.lang.Object", this.position());
            }
        }
        if ((c = (HjContext)tc.context()).inSequentialCode()) {
            throw new SemanticException("async may not be invoked in sequential code.", this.position());
        }
        AwaitableChecker.typeCheck(tc, this.awaitables);
        PhasedChecker.typeCheck(tc, this.phasers);
        if (this.isAsyncWithReturn() && !this.baseType().isVoid()) {
            this.body = this.asAsyncBlock(this.body);
        }
        return this.type(this.returnType.type());
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.place) {
            return ts.Object();
        }
        return child.type();
    }

    public String toString() {
        return "async <" + this.type + "> (" + this.place + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("async (");
        this.printBlock((Node)this.place, w, tr);
        w.write(") ");
        if (this.hasPhasers()) {
            w.write("phased (");
            w.begin(0);
            Iterator i = this.phasers.iterator();
            while (i.hasNext()) {
                Formal f = (Formal)i.next();
                this.print((Node)f, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
            w.write(")");
        }
        this.printSubStmt(this.body, w, tr);
    }

    public Term firstChild() {
        if (this.place != null) {
            return this.place;
        }
        if (this.seqCond != null) {
            return this.seqCond;
        }
        if (this.phasers() == null || this.phasers().isEmpty()) {
            return this.body;
        }
        return (Term)this.phasers().get(0);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.place != null) {
            v.visitCFG((Term)this.place, FlowGraph.EDGE_KEY_TRUE, (Term)this.body, 1, FlowGraph.EDGE_KEY_FALSE, (Term)this, 0);
        }
        if (this.seqCond != null) {
            v.visitCFG((Term)this.seqCond, (Term)this, 0);
        }
        if (this.whenCondExpr != null) {
            v.visitCFG((Term)this.whenCondExpr, (Term)this, 0);
        }
        v.visitCFG((Term)this.returnType, (Term)this, 0);
        if (this.dataDrivenFutureList() == null || this.dataDrivenFutureList().isEmpty()) {
            v.visitCFG((Term)this.body, (Term)this, 0);
        } else {
            v.visitCFGList(this.awaitables, (Term)this.body, 1);
            v.visitCFG((Term)this.body, (Term)this, 0);
        }
        if (this.phasers() == null || this.phasers().isEmpty()) {
            v.visitCFG((Term)this.body, (Term)this, 0);
        } else {
            v.visitCFGList(this.phasers, (Term)this.body, 1);
            v.visitCFG((Term)this.body, (Term)this, 0);
        }
        return succs;
    }

    public Type baseType() {
        return this.returnType.base().type();
    }

    public Term codeBody() {
        return this.body();
    }

    public CodeDef codeDef() {
        return this.ai;
    }

    public boolean isAsyncWithReturn() {
        return this.isAsyncWithReturn;
    }

    public boolean hasPhasers() {
        return this.phasers != null && !this.phasers.isEmpty();
    }
}

