/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import hj.lang.dist;
import hj.lang.place;
import hj.lang.region;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Binary_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ext.hj.ast.HjBinary;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.visit.ExprFlattener;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class HjBinary_c
extends Binary_c
implements HjBinary {
    public HjBinary_c(Position pos, Expr left, Binary.Operator op, Expr right) {
        super(pos, left, op, right);
    }

    public Precedence precedence() {
        HjType l = (HjType)this.left.type();
        HjTypeSystem xts = (HjTypeSystem)l.typeSystem();
        if (xts.isPoint((Type)l) || xts.isPlace((Type)l) || xts.isDistribution((Type)l) || xts.isRegion((Type)l) || xts.isPrimitiveTypeArrayView((Type)l) || xts.isDistributedArray((Type)l)) {
            return Precedence.LITERAL;
        }
        return super.precedence();
    }

    public boolean isConstant() {
        if (super.isConstant()) {
            return true;
        }
        HjType lt = (HjType)this.left.type();
        HjType rt = (HjType)this.right.type();
        if (lt == null || rt == null) {
            return false;
        }
        return false;
    }

    public Object constantValue() {
        Object result = super.constantValue();
        if (result != null) {
            return result;
        }
        if (!this.isConstant()) {
            return null;
        }
        Object lv = this.left.constantValue();
        Object rv = this.right.constantValue();
        HjType lt = (HjType)this.left.type();
        HjType rt = (HjType)this.right.type();
        HjTypeSystem xts = (HjTypeSystem)lt.typeSystem();
        if (this.op == EQ) {
            return Boolean.FALSE;
        }
        if (this.op == NE) {
            return Boolean.TRUE;
        }
        try {
            dist l;
            if (xts.isDistribution((Type)lt)) {
                l = (dist)lv;
                if (xts.isDistribution((Type)rt) && this.op == COND_OR) {
                    return l.union((dist)rv);
                }
                if (xts.isPlace((Type)rt) && this.op == BIT_OR) {
                    return l.restriction((place)rv);
                }
                if (xts.isRegion((Type)rt)) {
                    if (this.op == BIT_OR) {
                        return l.restriction((region)rv);
                    }
                    if (this.op == SUB) {
                        return l.difference((region)rv);
                    }
                }
            }
            if (xts.isRegion((Type)lt)) {
                l = (region)lv;
                if (xts.isRegion((Type)rt)) {
                    region r = (region)rv;
                    if (this.op == SUB) {
                        return l.difference(r);
                    }
                    if (this.op == COND_OR) {
                        return l.union(r);
                    }
                    if (this.op == COND_AND) {
                        return l.intersection(r);
                    }
                }
            }
        }
        catch (ArithmeticException e) {
            // empty catch block
        }
        return null;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        Context ctx = tc.context();
        HjType l = (HjType)this.left.type();
        HjType r = (HjType)this.right.type();
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (this.op == EQ || this.op == NE) {
            if (!ts.isCastValid((Type)l, (Type)r, ctx) && !ts.isCastValid((Type)r, (Type)l, ctx)) {
                throw new SemanticException("The " + this.op + " operator must have operands of similar type.", this.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == COND_AND) {
            if (!ts.isSubtype((Type)l, ts.Boolean(), ctx) || !ts.isSubtype((Type)r, ts.Boolean(), ctx)) {
                throw new SemanticException("The " + this.op + " operator must have operands of similar type.", this.position());
            }
            return this.type(ts.Boolean());
        }
        if ((this.op == GT || this.op == LT || this.op == GE || this.op == LE) && (xts.isPoint((Type)l) || xts.isPlace((Type)l))) {
            if (xts.isPlace((Type)l) && !xts.isPlace((Type)r)) {
                throw new SemanticException("The " + this.op + " operator instance must have a place operand.", this.right.position());
            }
            if (xts.isPoint((Type)l) && !xts.isPoint((Type)r)) {
                throw new SemanticException("The " + this.op + " operator instance must have a point operand.", this.right.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == COND_OR && xts.isDistributedArray((Type)l)) {
            if (!ts.typeEquals((Type)l, (Type)r, ctx)) {
                throw new SemanticException("The operands of " + this.op + " have base types " + l + " and " + r + "; these must " + "be similar. ", this.right.position());
            }
            return this.type((Type)l);
        }
        if (this.op == COND_OR && xts.isRegion((Type)l)) {
            if (!xts.isRegion((Type)r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a region operand.", this.right.position());
            }
            return this.type((Type)ts.region());
        }
        if (this.op == COND_OR && xts.isDistribution((Type)l)) {
            if (!xts.isDistribution((Type)r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a distribution operand.", this.right.position());
            }
            return this.type((Type)ts.distribution());
        }
        if (this.op == COND_AND && xts.isRegion((Type)l)) {
            if (!xts.isRegion((Type)r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a region operand.", this.right.position());
            }
            return this.type((Type)ts.region());
        }
        if (this.op == COND_AND && xts.isDistribution((Type)l)) {
            if (!xts.isDistribution((Type)r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a distribution operand.", this.right.position());
            }
            return this.type((Type)ts.distribution());
        }
        if (this.op == BIT_OR && xts.isDistributedArray((Type)l)) {
            if (!(xts.isDistribution((Type)r) || xts.isRegion((Type)r) || xts.isPlace((Type)r))) {
                throw new SemanticException("This " + this.op + " operator instance must have a distribution operand.", this.right.position());
            }
            return this.type((Type)l);
        }
        if (this.op == BIT_OR && xts.isDistribution((Type)l)) {
            if (!xts.isPlace((Type)r) && !xts.isRegion((Type)r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a place or region operand.", this.right.position());
            }
            HjParsedClassType lType = (HjParsedClassType)l;
            HjParsedClassType type = (HjParsedClassType)ts.distribution();
            Expr result = this.type((Type)type);
            return result;
        }
        if (this.op == SUB && xts.isDistribution((Type)l)) {
            if (!xts.isRegion((Type)r) && !xts.isDistribution((Type)r)) {
                throw new SemanticException("The " + this.op + " operator must have a region or distribution operand.", this.right.position());
            }
            return this.type((Type)ts.distribution());
        }
        if (this.op == SUB && xts.isRegion((Type)l)) {
            if (!xts.isRegion((Type)r)) {
                throw new SemanticException("The " + this.op + " operator must have a region operands.", this.right.position());
            }
            return this.type((Type)ts.region());
        }
        if ((this.op == SUB || this.op == ADD || this.op == MUL || this.op == DIV) && xts.isPrimitiveTypeArrayView((Type)l)) {
            if (!xts.typeEquals((Type)l, (Type)r, ctx)) {
                throw new SemanticException("The types of operands to " + this.op + " are " + l + " and " + r + "; these types should be equal.", this.right.position());
            }
            return this.type((Type)l);
        }
        if ((this.op == SUB || this.op == ADD || this.op == MUL || this.op == DIV) && xts.isPoint((Type)l) && !ts.isSubtype((Type)r, ts.String(), ctx)) {
            if (!xts.isPoint((Type)r) && !r.isIntOrLess()) {
                throw new SemanticException("The " + this.op + " operator instance must have a point or integer operand.", this.right.position());
            }
            return this.type((Type)l);
        }
        if ((this.op == SUB || this.op == ADD || this.op == MUL || this.op == DIV) && xts.isPoint((Type)r) && !ts.isSubtype((Type)l, ts.String(), ctx)) {
            if (!l.isIntOrLess()) {
                throw new SemanticException("The " + this.op + " operator instance must have a point or integer operand.", this.left.position());
            }
            return this.type((Type)r);
        }
        return super.typeCheck(tc);
    }

    public Expr flatten(ExprFlattener.Flattener fc) {
        assert (this.op == Binary.COND_AND || this.op == Binary.COND_OR);
        HjContext xc = (HjContext)fc.context();
        NodeFactory nf = fc.nodeFactory();
        TypeSystem ts = fc.typeSystem();
        Position pos = this.position();
        Id resultVarName = nf.Id(pos, xc.getNewVarName());
        CanonicalTypeNode tn = nf.CanonicalTypeNode(pos, this.type);
        Flags flags = Flags.NONE;
        LocalDef li = ts.localDef(pos, flags, Types.ref((Object)this.type), resultVarName.id());
        Expr nLeft = (Expr)this.left.visit((NodeVisitor)fc);
        LocalDecl ld = nf.LocalDecl(pos, nf.FlagsNode(pos, flags), (TypeNode)tn, resultVarName, nLeft).localDef(li);
        fc.add((Stmt)ld);
        Local ldRef = (Local)nf.Local(pos, resultVarName).localInstance(li.asInstance()).type(this.type);
        ExprFlattener.Flattener newVisitor = (ExprFlattener.Flattener)new ExprFlattener.Flattener(fc.job(), ts, nf, (Node)this).context((Context)xc);
        Expr nRight = (Expr)this.right.visit((NodeVisitor)newVisitor);
        List condBody = newVisitor.stmtList();
        Expr assign = nf.Assign(pos, (Expr)ldRef, Assign.ASSIGN, nRight).type(this.type);
        Eval eval = nf.Eval(pos, assign);
        condBody.add(eval);
        Local ldRef2 = nf.Local(pos, resultVarName).localInstance(li.asInstance());
        if (this.op == Binary.COND_AND) {
            If ifStm = nf.If(pos, (Expr)ldRef2, (Stmt)nf.Block(pos, condBody));
            fc.add((Stmt)ifStm);
        } else {
            Expr cond = nf.Unary(pos, (Expr)ldRef2, Unary.NOT).type(this.type);
            If ifStm = nf.If(pos, cond, (Stmt)nf.Block(pos, condBody));
            fc.add((Stmt)ifStm);
        }
        Local ldRef3 = (Local)nf.Local(pos, resultVarName).localInstance(li.asInstance()).type(this.type);
        return ldRef3;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.op == COND_OR && (this.left instanceof dist || this.left instanceof region) || this.op == COND_AND && this.left instanceof region) {
            v.visitCFG((Term)this.left, (Term)this.right, 1);
            v.visitCFG((Term)this.right, (Term)this, 0);
            return succs;
        }
        return super.acceptCFG(v, succs);
    }
}

