/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.jl5.ast.JL5Conditional_c;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class HjConditional_c
extends JL5Conditional_c {
    public HjConditional_c(Position pos, Expr cond, Expr consequent, Expr alternative) {
        super(pos, cond, consequent, alternative);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        Context ctx = tc.context();
        Expr e1 = this.consequent;
        Expr e2 = this.alternative;
        HjType t1 = (HjType)e1.type();
        HjType t2 = (HjType)e2.type();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean(), ctx)) {
            throw new SemanticException("Condition of ternary expression must be of type boolean.", this.cond.position());
        }
        if (ts.typeEquals((Type)t1, (Type)t2, ctx)) {
            return this.type((Type)t1);
        }
        if (t1.isNumeric() && t2.isNumeric()) {
            if (t1.isByte() && t2.isShort() || t1.isShort() && t2.isByte()) {
                return this.type(ts.Short());
            }
            if (t1.isIntOrLess() && t2.isInt() && ts.numericConversionValid((Type)t1, e2.constantValue(), ctx)) {
                return this.type((Type)t1);
            }
            if (t2.isIntOrLess() && t1.isInt() && ts.numericConversionValid((Type)t2, e1.constantValue(), ctx)) {
                return this.type((Type)t2);
            }
            return this.type(ts.promote((Type)t1, (Type)t2));
        }
        if (t1.isNull() && t2.isReference()) {
            return this.type((Type)t2);
        }
        if (t2.isNull() && t1.isReference()) {
            return this.type((Type)t1);
        }
        if (t1.isReference() && t2.isReference()) {
            if (ts.isImplicitCastValid((Type)t1, (Type)t2, tc.context())) {
                return this.type((Type)t2);
            }
            if (ts.isImplicitCastValid((Type)t2, (Type)t1, tc.context())) {
                return this.type((Type)t1);
            }
        }
        throw new SemanticException("Could not determine type of ternary conditional expression; cannot assign " + t1 + " to " + t2 + " or vice versa.", this.position());
    }
}

