/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Loop;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjLoop;
import polyglot.ext.hj.ast.HjLoopDistribution;
import polyglot.ext.hj.ast.HjLoopRegion;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HjLoop_c
extends Loop_c
implements HjLoop,
Loop {
    protected Formal formal;
    protected Expr domain;
    protected Stmt body;
    protected List<Stmt> locals;

    protected HjLoop_c(Position pos) {
        super(pos);
    }

    protected HjLoop_c(Position pos, Formal formal, Expr domain, Stmt body) {
        super(pos);
        this.formal = formal;
        this.domain = domain;
        this.body = body;
    }

    protected HjLoop_c reconstruct(Formal formal, Expr domain, Stmt body) {
        if (formal != this.formal || domain != this.domain || body != this.body) {
            HjLoop_c n = (HjLoop_c)this.copy();
            n.formal = formal;
            n.domain = domain;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        Expr newDomain = this.domain;
        if (this instanceof HjLoopRegion) {
            if (ts.isHjArrayView(newDomain.type())) {
                newDomain = (Expr)nf.Field(this.position(), (Receiver)this.domain, nf.Id(this.position(), "region")).del().typeCheck(tc);
            }
            if (!ts.isRegion(newDomain.type())) {
                throw new SemanticException("Hj loop domain must be an arrayview or a region not a " + newDomain.type());
            }
        }
        if (this instanceof HjLoopDistribution && !ts.isDistribution(newDomain.type())) {
            throw new SemanticException("Hj loop domain must be a distribution not a " + newDomain.type());
        }
        HjFormal hjFormal = (HjFormal)this.formal;
        if (!hjFormal.isUnnamed() && hjFormal.vars().size() != 0) {
            throw new SemanticException("Invalid point declaration, uss 'point p' or 'point[i,...,k]' notation");
        }
        return this.domain(newDomain);
    }

    public Term firstChild() {
        return this.formal;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.formal, (Term)this.domain, 1);
        v.visitCFG((Term)this.domain, (Term)this.body, 1);
        v.visitCFG((Term)this.body, (Term)this, 0);
        return succs;
    }

    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    public Node visitChildren(NodeVisitor v) {
        Formal formal = (Formal)this.visitChild((Node)this.formal, v);
        Expr domain = (Expr)this.visitChild((Node)this.domain, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(formal, domain, body);
    }

    @Override
    public Stmt body() {
        return this.body;
    }

    @Override
    public Formal formal() {
        return this.formal;
    }

    @Override
    public Expr domain() {
        return this.domain;
    }

    @Override
    public List<Stmt> locals() {
        return this.locals == null ? Collections.EMPTY_LIST : this.locals;
    }

    @Override
    public HjLoop body(Stmt body) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.body = body;
        return n;
    }

    @Override
    public HjLoop formal(Formal formal) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.formal = formal;
        return n;
    }

    @Override
    public HjLoop domain(Expr domain) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.domain = domain;
        return n;
    }

    @Override
    public HjLoop locals(List locals) {
        HjLoop_c n = (HjLoop_c)this.copy();
        n.locals = locals;
        return n;
    }

    public Term continueTarget() {
        return this.formal;
    }

    public Expr cond() {
        return null;
    }
}

