/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.hj.ast.HjReturn;
import polyglot.ext.hj.types.AsyncDef;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.jl5.ast.JL5Return_c;
import polyglot.types.CodeDef;
import polyglot.types.Context;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.ContextVisitor;

public class HjReturn_c
extends JL5Return_c
implements HjReturn {
    public HjReturn_c(Position pos, Expr expr) {
        super(pos, expr);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        CodeDef ci = c.currentCode();
        if (ci instanceof AsyncDef) {
            AsyncDef mi = (AsyncDef)ci;
            Type futureBaseType = ((FutureType)Types.get((Ref)mi.returnType())).base();
            if (futureBaseType.isVoid()) {
                if (this.expr != null) {
                    throw new SemanticException("Cannot return a value from " + mi + ".", this.position());
                }
                return this;
            }
            if (this.expr == null) {
                throw new SemanticException("Must return a value from " + mi + ".", this.position());
            }
            if (ts.isImplicitCastValid(this.expr.type(), futureBaseType, c)) {
                return this;
            }
            throw new SemanticException("Cannot return expression of type " + this.expr.type() + " from " + mi + ".", this.expr.position());
        }
        return super.typeCheck(tc);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Context c;
        CodeDef ci;
        if (child == this.expr && (ci = (c = av.context()).currentCode()) instanceof AsyncDef) {
            AsyncDef mi = (AsyncDef)ci;
            return ((FutureType)mi.returnType().get()).base();
        }
        return super.childExpectedType(child, av);
    }
}

