/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Expr;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Unary;
import polyglot.ast.Unary_c;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class HjUnary_c
extends Unary_c {
    public HjUnary_c(Position pos, Unary.Operator op, Expr expr) {
        super(pos, op, expr);
    }

    public Precedence precedence() {
        HjType l = (HjType)this.expr.type();
        HjTypeSystem xts = (HjTypeSystem)l.typeSystem();
        if (xts.isPoint((Type)l)) {
            return Precedence.LITERAL;
        }
        return super.precedence();
    }

    public Object constantValue() {
        return super.constantValue();
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjType t = (HjType)this.expr.type();
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if ((this.op == NEG || this.op == POS) && ts.isPoint((Type)t)) {
            return this.type((Type)t);
        }
        Node res = super.typeCheck(tc);
        if ((this.op == POST_INC || this.op == POST_DEC || this.op == PRE_INC || this.op == PRE_DEC) && this.expr instanceof Local) {
            LocalInstance li;
            Local l = (Local)this.expr;
            Context c = tc.context();
            if (!c.isLocal((li = c.findLocal(l.name().id())).name())) {
                throw new SemanticException("Cannot modify a variable inherited from the parent scope");
            }
        }
        return res;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        HjType t = (HjType)this.expr.type();
        HjTypeSystem ts = (HjTypeSystem)t.typeSystem();
        if ((this.op == NEG || this.op == POS) && ts.isPoint((Type)t)) {
            this.printSubExpr(this.expr, true, w, tr);
            if (this.op == NEG) {
                w.write(".neg()");
            }
            return;
        }
        super.prettyPrint(w, tr);
    }
}

