/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collection;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Isolated;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class Isolated_c
extends Stmt_c
implements Isolated {
    public Stmt body;
    public List objects;

    public Isolated_c(Position p, List objects, Stmt body) {
        super(p);
        this.objects = objects;
        this.body = body;
    }

    public Isolated_c(Position p) {
        super(p);
    }

    public Stmt body() {
        return this.body;
    }

    public Isolated body(Stmt body) {
        Isolated_c n = (Isolated_c)this.copy();
        n.body = body;
        return n;
    }

    public List objects() {
        return this.objects;
    }

    protected Isolated reconstruct(Stmt body, List objects) {
        if (body != this.body || !CollectionUtil.allEqual((Collection)objects, (Collection)this.objects)) {
            Isolated_c n = (Isolated_c)this.copy();
            n.body = body;
            n.objects = TypedList.copyAndCheck((List)objects, Expr.class, (boolean)false);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List objects = this.visitList(this.objects, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(body, objects);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (this.objects.size() > 0) {
            throw new SemanticException("Multi-place isolated is currently not supported.");
        }
        for (Expr tn : this.objects()) {
            if (ts.isHjObject(tn.type())) continue;
            throw new SemanticException("Isolated object list argument of type \"" + tn.type() + "\" must extends hj.lang.Object.");
        }
        return this;
    }

    public Context enterScope(Context c) {
        HjContext cc = (HjContext)super.enterScope(c);
        cc = cc.pushIsolatedBlock();
        return cc;
    }

    public String toString() {
        return "isolated  { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("isolated ");
        this.printSubStmt(this.body, w, tr);
    }

    public Term firstChild() {
        if (this.objects() != null && this.objects().isEmpty()) {
            return this.body;
        }
        return (Term)this.objects().get(0);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFGList(this.objects(), (Term)this.body, 1);
        v.push((Stmt)this).visitCFG((Term)this.body, (Term)this, 0);
        return succs;
    }
}

