/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.visit.ContextVisitor;

public class PhasedChecker {
    private static Type javaListType = null;

    public static void typeCheck(ContextVisitor tc, List phasers) throws SemanticException {
        if (phasers != null) {
            HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
            HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
            Context ctx = tc.context();
            if (javaListType == null) {
                javaListType = ts.typeForName(QName.make((String)"java.util.List"));
            }
            boolean odd = true;
            Iterator i = phasers.iterator();
            while (i.hasNext()) {
                Expr tn = (Expr)i.next();
                Type t = tn.type();
                if (!odd) {
                    if (!ts.isSubtype(t, javaListType, ctx) && !ts.isSubtype(t, (Type)ts.phaser(), ctx)) {
                        throw new SemanticException("Type \"" + t + "\" in phaser list must be either java.util.List or hj.lang.phaser.", tn.position());
                    }
                } else if (!ts.isSubtype(t, (Type)ts.phaserMode(), ctx)) {
                    throw new SemanticException("Phaser mode must be of type hj.lang.phaserMode or java.lang.List", tn.position());
                }
                if ((odd = !odd) || i.hasNext()) continue;
                throw new SemanticException("Phaser list must end with hj.lang.phaser.", tn.position());
            }
        }
    }
}

