/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.extension.extern;

import java.util.ListIterator;
import polyglot.ast.Formal;
import polyglot.ast.Formal_c;
import polyglot.ast.MethodDecl;
import polyglot.ext.hj.extension.extern.HjClassBodyExtArrayViewHelper;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ClassType;
import polyglot.types.Type;

public class HjClassBodyExtHelperJNI {
    private static final String zeros = "0000";
    private HjTypeSystem ts;
    private static final String JNI_PREFIX = "Java_";

    public HjClassBodyExtHelperJNI(HjTypeSystem typeSystem) {
        this.ts = typeSystem;
    }

    public String JNImangle(String inName) {
        char[] charName = inName.toCharArray();
        StringBuffer buffer = new StringBuffer(inName.length());
        boolean seenForwardSlash = false;
        boolean inCommentMode = false;
        boolean lastCharAsterix = false;
        int lastChar = 97;
        for (int i = 0; i < inName.length(); ++i) {
            char ch = inName.charAt(i);
            if (inCommentMode) {
                if (ch == '/' && lastChar == 42) {
                    inCommentMode = false;
                }
            } else {
                switch (ch) {
                    case '/': {
                        break;
                    }
                    case '*': {
                        if (lastChar != 47) break;
                        inCommentMode = true;
                        break;
                    }
                    case '_': {
                        buffer.append("_1");
                        break;
                    }
                    case ';': {
                        buffer.append("_2");
                        break;
                    }
                    case '[': {
                        buffer.append("_3");
                        break;
                    }
                    case '.': {
                        buffer.append("_");
                        break;
                    }
                    default: {
                        if (Character.isLetterOrDigit(ch)) {
                            buffer.append(ch);
                            break;
                        }
                        String hex = Integer.toHexString(ch);
                        hex = zeros.substring(hex.length()) + hex;
                        buffer.append("_0").append(hex);
                    }
                }
            }
            lastChar = ch;
        }
        return buffer.toString();
    }

    public String canonicalTypeString(Type t) {
        String s = "";
        ClassType cl = t.toClass();
        while (cl.isNested()) {
            if (cl.isAnonymous()) {
                throw new RuntimeException("Anonymous inner classes not supported yet");
            }
            s = "$" + cl.name() + s;
            cl = cl.outer();
        }
        return cl.fullName() + s;
    }

    public String canonicalMangling(MethodDecl method) {
        return this.JNImangle(this.canonicalTypeString((Type)method.memberDef().container().get()));
    }

    public String generateMangledHjNativeName(MethodDecl method, boolean isOverloaded, HjClassBodyExtArrayViewHelper viewHelper) {
        String name = this.canonicalMangling(method) + "_" + this.generateHjNativeName(method);
        if (isOverloaded) {
            name = name + "__" + this.JNImangle(this.generateJavaSignature(method, viewHelper));
        }
        return name;
    }

    public String generateHjNativeName(MethodDecl method) {
        String mangledName = method.name().id().toString();
        return mangledName;
    }

    public String generateHjAliasName(MethodDecl method) {
        return this.canonicalMangling(method) + "_" + method.name();
    }

    public String generateJavaSignature(MethodDecl method, HjClassBodyExtArrayViewHelper viewHelper) {
        StringBuffer signature = new StringBuffer("");
        ListIterator i = method.formals().listIterator();
        while (i.hasNext()) {
            Formal_c parameter = (Formal_c)i.next();
            if (parameter.declType().isPrimitive() || parameter.declType().isArray()) {
                signature.append(HjClassBodyExtHelperJNI.typeToJavaSigString(parameter.declType()));
                continue;
            }
            viewHelper.generateViewJavaSignature((Formal)parameter, signature);
        }
        return signature.toString();
    }

    public static String typeToJavaSigString(Type theType) {
        if (theType.isPrimitive()) {
            if (theType.isInt()) {
                return "I";
            }
            if (theType.isChar()) {
                return "J";
            }
            if (theType.isBoolean()) {
                return "Z";
            }
            if (theType.isByte()) {
                return "B";
            }
            if (theType.isShort()) {
                return "S";
            }
            if (theType.isLong()) {
                return "J";
            }
            if (theType.isFloat()) {
                return "F";
            }
            if (theType.isDouble()) {
                return "D";
            }
            if (theType.isVoid()) {
                return "V";
            }
            throw new Error("Unexpected type" + theType.toString());
        }
        if (!theType.isArray()) {
            throw new Error("Only java arrays are supported, not " + theType.toString());
        }
        Type baseType = theType.toArray().base();
        if (!baseType.isPrimitive()) {
            throw new Error("Only primitive arrays are supported, not " + theType.toString());
        }
        return "[" + HjClassBodyExtHelperJNI.typeToJavaSigString(baseType);
    }

    public String generateJNIAlias(MethodDecl method, boolean isOverloaded, HjClassBodyExtArrayViewHelper viewHelper) {
        String name = JNI_PREFIX + this.canonicalMangling(method) + "_" + this.JNImangle(this.generateHjAliasName(method));
        if (isOverloaded) {
            name = name + "__" + this.JNImangle(this.generateJavaSignature(method, viewHelper));
        }
        return name;
    }

    public String generateJNIName(MethodDecl method, boolean isOverloaded, HjClassBodyExtArrayViewHelper viewHelper) {
        String name = JNI_PREFIX + this.canonicalMangling(method) + "_" + this.JNImangle(this.generateHjNativeName(method));
        if (isOverloaded) {
            name = name + "__" + this.JNImangle(this.generateJavaSignature(method, viewHelper));
        }
        return name;
    }

    public String typeToJNIString(Type theType) {
        if (theType.isPrimitive()) {
            if (theType.isInt()) {
                return "jint";
            }
            if (theType.isBoolean()) {
                return "jboolean";
            }
            if (theType.isByte()) {
                return "jbyte";
            }
            if (theType.isShort()) {
                return "jshort";
            }
            if (theType.isLong()) {
                return "jlong";
            }
            if (theType.isFloat()) {
                return "jfloat";
            }
            if (theType.isChar()) {
                return "jchar";
            }
            if (theType.isDouble()) {
                return "jdouble";
            }
            if (theType.isVoid()) {
                return "void";
            }
            throw new Error("Unhandled type:" + theType);
        }
        if (theType.isArray()) {
            return this.typeToJNIString(theType.toArray().base()) + "Array";
        }
        if (HjClassBodyExtHelperJNI.isString(theType)) {
            return "jstring";
        }
        return "<unknown>";
    }

    public static boolean isString(Type t) {
        return t.toString().equals("java.lang.String");
    }

    public String typeToCType(Type theType) {
        if (theType.isPrimitive()) {
            return HjClassBodyExtHelperJNI.typeToCString(theType);
        }
        if (theType.isArray()) {
            return this.typeToCType(theType.toArray().base()) + "*";
        }
        if (this.ts.isHjArrayView(theType)) {
            Type base = this.ts.baseType(theType);
            if (!base.isPrimitive()) {
                return "jobject*";
            }
            return HjClassBodyExtHelperJNI.typeToCString(base) + "*";
        }
        if (HjClassBodyExtHelperJNI.isString(theType)) {
            return "const char*";
        }
        return "jobject";
    }

    public static String typeToCString(Type theType) {
        if (theType.isPrimitive()) {
            if (theType.isInt()) {
                return "signed int";
            }
            if (theType.isChar()) {
                return "signed short";
            }
            if (theType.isBoolean()) {
                return "unsigned char";
            }
            if (theType.isByte()) {
                return "signed char";
            }
            if (theType.isShort()) {
                return "signed short";
            }
            if (theType.isLong()) {
                return "jlong";
            }
            if (theType.isFloat()) {
                return "float";
            }
            if (theType.isDouble()) {
                return "double";
            }
            if (theType.isVoid()) {
                return "void";
            }
            throw new Error("Unexpected type" + theType.toString());
        }
        if (!theType.isArray()) {
            throw new Error("Unexpected type" + theType.toString());
        }
        Type baseType = theType.toArray().base();
        if (!baseType.isPrimitive()) {
            throw new Error("Only primitive arrays are supported, not " + theType.toString());
        }
        return HjClassBodyExtHelperJNI.typeToCString(baseType) + "Array";
    }

    public String[] typeToCType(Type[] viewsTypes) {
        String[] res = new String[viewsTypes.length];
        for (int i = 0; i < viewsTypes.length; ++i) {
            res[i] = this.typeToCType(viewsTypes[i]);
        }
        return res;
    }
}

