/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.HjArrayViewType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.DerefTransform;
import polyglot.types.FieldAsTypeTransform;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.MethodAsTypeTransform;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.ReferenceType_c;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayViewType_c
extends ReferenceType_c
implements HjArrayViewType {
    protected Ref<? extends Type> base;
    protected List<FieldDef> fields;
    protected List<MethodDef> methods;
    protected List<Ref<? extends Type>> interfaces;
    private static final int maxViewDim = 5;

    protected HjArrayViewType_c() {
    }

    public HjArrayViewType_c(TypeSystem ts, Position pos, Ref<? extends Type> base) {
        super(ts, pos);
        this.base = base;
        this.methods = null;
        this.fields = null;
        this.interfaces = null;
    }

    protected void init() {
        if (this.methods == null) {
            List baseDefMethods = ((ClassDef)((ClassType)this.superClass()).def()).methods();
            this.methods = new ArrayList<MethodDef>(10 + baseDefMethods.size());
            this.initGetters();
            this.initSetters();
            Type baseRef = ((HjTypeSystem)this.ts).isPrimitiveTypeArrayView((Type)this) ? this.ts.arrayOf(this.base) : this.ts.arrayOf(Types.ref((Object)this.ts.Object()));
            MethodDef mi = this.ts.methodDef(this.position(), Types.ref((Object)this), this.ts.Public(), Types.ref((Object)baseRef), Name.make((String)"getBackingArray"), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            this.methods.add(mi);
            MethodDef mi2 = this.ts.methodDef(this.position(), Types.ref((Object)this), this.ts.Public(), Types.ref((Object)this.ts.arrayOf(this.ts.Int())), Name.make((String)"getDescriptor"), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            this.methods.add(mi2);
            this.methods.addAll(baseDefMethods);
        }
        if (this.fields == null) {
            List baseDefFields = ((ClassDef)((ClassType)this.superClass()).def()).fields();
            this.fields = new ArrayList<FieldDef>(baseDefFields.size());
            this.fields.addAll(baseDefFields);
        }
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<Ref<? extends Type>>(1);
            this.interfaces.add((Ref<? extends Type>)Types.ref((Object)((HjTypeSystem)this.ts).Indexable()));
        }
    }

    public Ref<? extends Type> theBaseType() {
        return this.base;
    }

    @Override
    public Type base() {
        return (Type)Types.get(this.base);
    }

    public HjArrayViewType base(Type base) {
        return this.base((Ref<? extends Type>)Types.ref((Object)base));
    }

    public HjArrayViewType base(Ref<? extends Type> base) {
        if (base == this.base) {
            return this;
        }
        HjArrayViewType_c n = (HjArrayViewType_c)this.copy();
        n.base = base;
        return n;
    }

    public Type ultimateBase() {
        return this.base();
    }

    public String toString() {
        return this.base.toString() + "[.]";
    }

    public void print(CodeWriter w) {
        this.base().print(w);
        w.write("[.]");
    }

    public String translate(Resolver c) {
        return this.base().translate(c) + "[.]";
    }

    public boolean isArray() {
        return false;
    }

    public List<MethodInstance> methods() {
        this.init();
        return new TransformingList(this.methods, (Transformation)new MethodAsTypeTransform());
    }

    public List<FieldInstance> fields() {
        this.init();
        return new TransformingList(this.fields, (Transformation)new FieldAsTypeTransform());
    }

    public Type superClass() {
        return ((HjTypeSystem)this.ts).arrayViewBase();
    }

    public List<Type> interfaces() {
        this.init();
        return new TransformingList(this.interfaces, (Transformation)new DerefTransform());
    }

    public int hashCode() {
        return this.base().hashCode() << 3;
    }

    public boolean equalsImpl(TypeObject t) {
        if (t instanceof HjArrayViewType) {
            HjArrayViewType a = (HjArrayViewType)t;
            return this.ts.equals((TypeObject)this.base(), (TypeObject)a.base());
        }
        return false;
    }

    private void initSetters() {
        for (int i = 0; i < 5; ++i) {
            List<Ref<? extends Type>> formals = this.createFormals(i);
            MethodDef mi = this.ts.methodDef(this.position(), Types.ref((Object)this), this.ts.Public(), Types.ref((Object)this.ts.Void()), Name.make((String)"set"), formals, Collections.EMPTY_LIST);
            this.methods.add(mi);
        }
    }

    private void initGetters() {
        for (int i = 0; i < 5; ++i) {
            List<Ref<? extends Type>> formals = this.createFormals(i);
            MethodDef mi = this.ts.methodDef(this.position(), Types.ref((Object)this), this.ts.Public(), this.base, Name.make((String)"get"), formals, Collections.EMPTY_LIST);
            this.methods.add(mi);
        }
    }

    private List<Ref<? extends Type>> createFormals(int nbDim) {
        ArrayList<Ref<? extends Type>> formals = new ArrayList<Ref<? extends Type>>(6);
        formals.add(this.base);
        for (int i = 0; i < nbDim; ++i) {
            formals.add((Ref<? extends Type>)Types.ref((Object)this.ts.Int()));
        }
        return formals;
    }

    @Override
    public boolean safe() {
        return false;
    }

    @Override
    public FutureType toFuture() {
        return null;
    }

    @Override
    public boolean isComplex32() {
        return false;
    }

    @Override
    public boolean isComplex64() {
        return false;
    }

    @Override
    public boolean isArrayView() {
        return true;
    }

    public boolean isTypeVariable() {
        return false;
    }
}

