/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.HjType_c;
import polyglot.ext.jl5.types.JL5ParsedClassType_c;
import polyglot.types.ClassDef;
import polyglot.types.Ref;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjParsedClassType_c
extends JL5ParsedClassType_c
implements HjParsedClassType {
    protected List<Type> paramTypeList = Collections.EMPTY_LIST;
    protected List<Ref<? extends Type>> paramRefTypeList = Collections.EMPTY_LIST;

    public HjParsedClassType_c(TypeSystem ts, Position pos, Ref<? extends ClassDef> def) {
        super(ts, pos, def);
    }

    @Override
    public boolean isParameterized() {
        return !this.paramTypeList.isEmpty();
    }

    @Override
    public Type makeParameterizedVariant(Ref<? extends Type> type) {
        HjParsedClassType_c ctVar = (HjParsedClassType_c)this.copy();
        ctVar.addParameterRefType(type);
        return ctVar;
    }

    protected void addParameterRefType(Ref<? extends Type> type) {
        if (this.paramRefTypeList.isEmpty()) {
            this.paramRefTypeList = new LinkedList<Ref<? extends Type>>();
        }
        this.paramRefTypeList.add(type);
    }

    @Override
    public void setParameterRefType(Ref<? extends Type> type) {
        this.paramRefTypeList.remove(0);
        this.paramRefTypeList.add(type);
    }

    @Override
    public Type typeParameter() {
        return this.paramRefTypeList.isEmpty() ? null : (Type)this.paramRefTypeList.get(0).get();
    }

    public void print(CodeWriter w) {
        super.print(w);
    }

    @Override
    public HjClassType superClassRoot() {
        HjTypeSystem xt = (HjTypeSystem)this.typeSystem();
        HjClassType hjLangObj = (HjClassType)xt.HjObject();
        HjClassType result = this;
        HjClassType next = (HjClassType)result.superClass();
        while (next != null) {
            boolean value = xt.typeEquals((Type)hjLangObj, (Type)result, null);
            if (value) {
                return hjLangObj;
            }
            result = next;
            next = (HjClassType)result.superClass();
        }
        return result;
    }

    @Override
    public boolean isJavaType() {
        TypeSystem ts = this.typeSystem();
        return ts.typeEquals((Type)this.superClassRoot(), ts.Object(), null);
    }

    @Override
    public boolean safe() {
        return HjFlags.toHjFlags(this.flags()).isSafe();
    }

    @Override
    public FutureType toFuture() {
        return HjType_c.toFuture(this);
    }

    @Override
    public boolean isComplex64() {
        return false;
    }

    @Override
    public boolean isComplex32() {
        return false;
    }

    @Override
    public boolean isArrayView() {
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }
}

