/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.jl5.types.JL5TypeEnv_c;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.PrimitiveType;
import polyglot.types.Type;

public class HjTypeEnv_c
extends JL5TypeEnv_c {
    protected HjTypeSystem xts;

    public HjTypeEnv_c(Context context) {
        super(context);
        this.xts = (HjTypeSystem)this.ts;
    }

    public boolean isImplicitCastValid(Type fromType, Type toType) {
        if (fromType.isPrimitive()) {
            if (this.xts.isComplex32(fromType) || this.xts.isComplex64(fromType)) {
                PrimitiveType baseFromType = ((HjComplexType)fromType).base();
                Type baseToType = toType;
                if (this.xts.isComplex32(toType) || this.xts.isComplex64(toType)) {
                    baseToType = ((HjComplexType)toType).base();
                    return this.isImplicitCastValid((Type)baseFromType, baseToType);
                }
                return this.xts.isString(baseToType);
            }
            if (this.isSubtype(fromType, toType)) {
                return true;
            }
            if (this.xts.isComplex32(toType) || this.xts.isComplex64(toType)) {
                toType = ((HjComplexType)toType).base();
            }
            return super.isImplicitCastValid(fromType, toType);
        }
        if (this.xts.isFuture(fromType)) {
            HjType targetType;
            FutureType target;
            if (Report.should_report((String)"debug", (int)5)) {
                Report.report((int)5, (String)("[FutureType_c] |" + (Object)((Object)this) + "|.isImplicitCastValidImpl(|" + toType + "|):"));
            }
            if ((target = (targetType = (HjType)toType).toFuture()) != null) {
                boolean result = this.isImplicitCastValid(((FutureType)fromType).base(), target.base());
                if (Report.should_report((String)"debug", (int)5)) {
                    Report.report((int)5, (String)("[FutureType_c] ..." + result));
                }
                return result;
            }
            boolean result = super.isImplicitCastValid(fromType, toType);
            if (Report.should_report((String)"debug", (int)5)) {
                Report.report((int)5, (String)("[FutureType_c] ... " + result));
            }
            return result;
        }
        if (fromType.isNull()) {
            return super.isImplicitCastValid(fromType, toType);
        }
        if (fromType.isClass() && this.isSubtype(fromType, toType)) {
            return true;
        }
        return super.isImplicitCastValid(fromType, toType);
    }

    public boolean isCastValid(Type fromType, Type toType) {
        if (this.xts.isFuture(fromType)) {
            HjType xToType;
            FutureType target;
            HjType xFromType = (HjType)fromType;
            if (Report.should_report((String)"debug", (int)5)) {
                Report.report((int)5, (String)("[FutureType_c] |" + (Object)((Object)this) + "|.isCastValidImpl(|" + toType + "|):"));
            }
            if (this.xts.isFuture(toType) && (target = (xToType = (HjType)toType).toFuture()) != null) {
                boolean result = this.isCastValid(((FutureType)xFromType).base(), target.base());
                if (Report.should_report((String)"debug", (int)5)) {
                    Report.report((int)5, (String)("[FutureType_c] ... target=|" + target + "|."));
                    Report.report((int)5, (String)("[FutureType_c] ... returns |" + result + "|."));
                }
                return result;
            }
            if (Report.should_report((String)"debug", (int)5)) {
                Report.report((int)5, (String)"[FutureType_c] ... false");
            }
        }
        if (fromType.isNull()) {
            return super.isCastValid(fromType, toType);
        }
        if (fromType.isClass()) {
            return super.isCastValid(fromType, toType);
        }
        if (fromType.isPrimitive()) {
            HjType xToType = (HjType)toType;
            if (xToType.isComplex32() || xToType.isComplex64()) {
                return true;
            }
            if (this.typeEquals(toType, this.xts.Object()) || this.typeEquals(toType, (Type)this.xts.HjObject())) {
                return false;
            }
        }
        return super.isCastValid(fromType, toType);
    }

    public boolean numericConversionValid(Type t, Object value) {
        return t.isLong() && value instanceof Long || t.isInt() && value instanceof Integer || t.isFloat() && value instanceof Float || t.isDouble() && value instanceof Double || t.isChar() && value instanceof Character || t.isShort() && value instanceof Short || t.isByte() && value instanceof Byte;
    }
}

