/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.Collections;
import polyglot.ast.Call;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.extension.HjExt;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;

public class HjBoxer
extends AscriptionVisitor {
    HjTypeSystem xts;

    public HjBoxer(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.xts = (HjTypeSystem)ts;
    }

    public static New box(HjTypeSystem ts, NodeFactory nf, Expr e, ClassType ct) {
        ConstructorInstance ci = ts.wrapperConstructor(ct.toPrimitive());
        Position p = e.position();
        New x = nf.New(p, (TypeNode)nf.CanonicalTypeNode(p, (Type)ci.container()), Collections.singletonList(e));
        x = (New)x.type((Type)ci.container());
        x = x.constructorInstance(ci);
        return x;
    }

    public static Call unbox(HjTypeSystem ts, NodeFactory nf, Expr e, ClassType ct) {
        MethodInstance xxxValueMi = ts.wrapperGetter(ct.toPrimitive());
        Call xxxValueCall = nf.Call(e.position(), (Receiver)e, nf.Id(e.position(), xxxValueMi.name()));
        xxxValueCall = xxxValueCall.methodInstance(xxxValueMi);
        xxxValueCall = (Call)xxxValueCall.type(xxxValueMi.returnType());
        return xxxValueCall;
    }

    public Expr ascribe(Expr e, Type toType) {
        boolean is_String_type;
        Type fromType = e.type();
        if (toType == null) {
            return e;
        }
        Position p = e.position();
        if (e instanceof Call) {
            Call call_n = (Call)e;
            String m_name = call_n.name().toString();
            Type target_t = call_n.target().type();
            if (m_name.equals("get") && this.xts.isFuture(target_t) && !this.xts.isFutureVoid(target_t)) {
                Cast ret_notype;
                if (fromType.isPrimitive()) {
                    ClassType boxed_t = ((HjTypeSystem)this.ts).classOf(fromType);
                    call_n = (Call)call_n.type((Type)boxed_t);
                    ret_notype = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, fromType), (Expr)call_n);
                } else {
                    ret_notype = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, fromType), (Expr)call_n);
                }
                return ret_notype.type(fromType);
            }
        }
        if (!(is_String_type = this.ts.typeEquals(toType, this.ts.String(), null)) && fromType.isPrimitive() && toType.isReference()) {
            Cast ret_notype = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, toType), e);
            return ret_notype.type(toType);
        }
        if (HjBoxer.isPrimitiveNonVoid(toType) && HjBoxer.isBoxableReference(this.xts, e.type())) {
            Call unboxCall = HjBoxer.unbox(this.xts, this.nf, e, (ClassType)e.type());
            return unboxCall;
        }
        if (HjBoxer.isBoxableReference(this.xts, toType) && HjBoxer.isPrimitiveNonVoid(e.type())) {
            New box = HjBoxer.box(this.xts, this.nf, e, (ClassType)toType);
            return box;
        }
        return e;
    }

    public static boolean isPrimitiveNonVoid(Type t) {
        return !t.isVoid() && t.isPrimitive();
    }

    public static boolean isBoxableReference(HjTypeSystem ts, Type t) {
        return t.isReference() && ts.isSubtype(t, (Type)ts.NumberWrapper(), null);
    }

    public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        if ((n = super.leaveCall(parent, old, n, v)).ext() instanceof HjExt) {
            return ((HjExt)n.ext()).rewrite((HjTypeSystem)this.typeSystem(), this.nodeFactory(), this.job.extensionInfo());
        }
        return n;
    }
}

