/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import polyglot.ast.Binary;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.FloatLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.StringLit;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.ComplexOperation;
import polyglot.ext.hj.ast.HjComplexConstructor;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjPrimitiveType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;

public class HjCaster
extends AscriptionVisitor {
    private HjTypeSystem xts;

    public HjCaster(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.xts = (HjTypeSystem)ts;
    }

    public NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        HjType t;
        if (parent instanceof Expr && n instanceof Expr && parent instanceof Binary && ((t = (HjType)((Expr)parent).type()).isComplex64() || t.isComplex32())) {
            n = ((Expr)n).type((Type)t);
        }
        return super.enterCall(parent, n);
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        return super.leaveCall(old, n, v);
    }

    private Expr createComplexCast(HjComplexType toType, Expr e) throws SemanticException {
        Position p = e.position();
        CanonicalTypeNode typeNode = this.nf.CanonicalTypeNode(p, (Type)toType);
        Cast cast = this.nf.Cast(p, (TypeNode)typeNode, e);
        return cast.type((Type)toType);
    }

    private Expr rewriteComplexConstructor(HjComplexType toType, HjComplexConstructor xcc) throws SemanticException {
        PrimitiveType baseType = toType.base();
        CanonicalTypeNode baseTypeNode = this.nf.CanonicalTypeNode(xcc.position(), (Type)baseType);
        Cast newReal = this.nf.Cast(xcc.position(), (TypeNode)baseTypeNode, xcc.real());
        newReal = newReal.type((Type)baseType);
        Cast newImag = this.nf.Cast(xcc.position(), (TypeNode)baseTypeNode, xcc.imag());
        newImag = newImag.type((Type)baseType);
        HjComplexConstructor newXcc = xcc.real((Expr)newReal);
        newXcc = newXcc.imag((Expr)newImag);
        return newXcc.type((Type)toType);
    }

    private Expr createComplexConstructor(HjComplexType toType, Expr e) throws SemanticException {
        Position p = e.position();
        HjPrimitiveType baseType = (HjPrimitiveType)toType.base();
        FloatLit.Kind floatKind = baseType.isDouble() ? FloatLit.DOUBLE : FloatLit.FLOAT;
        CanonicalTypeNode baseTypeNode = this.nf.CanonicalTypeNode(p, (Type)baseType);
        Cast newReal = this.nf.Cast(p, (TypeNode)baseTypeNode, e);
        newReal = newReal.type((Type)baseType);
        FloatLit zeroFloat = this.nf.FloatLit(p, floatKind, 0.0);
        zeroFloat = zeroFloat.type(this.ts.Float());
        Cast newImag = this.nf.Cast(p, (TypeNode)baseTypeNode, (Expr)zeroFloat);
        newImag = newImag.type((Type)baseType);
        HjComplexConstructor newXcc = ((HjNodeFactory)this.nf).HjComplexConstructor(p, (Expr)newReal, (Expr)newImag);
        return newXcc.type((Type)toType);
    }

    protected Node leaveCall(Node n) throws SemanticException {
        return super.leaveCall(n);
    }

    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        if (this.xts.isString(toType) && (((HjType)e.type()).isComplex32() || ((HjType)e.type()).isComplex64())) {
            Expr c = this.complexToString(e);
            return c;
        }
        if (this.xts.isComplex64(toType) && this.xts.isComplex32(e.type())) {
            Position p = e.position();
            if (e instanceof HjComplexConstructor) {
                return this.rewriteComplexConstructor((HjComplexType)toType, (HjComplexConstructor)e);
            }
            Cast newCast = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, toType), e);
            return newCast.type(toType);
        }
        if (this.xts.isComplex64(toType) || this.xts.isComplex32(toType)) {
            Type fromType = e.type();
            if (this.xts.isComplex64(fromType) || this.xts.isComplex32(fromType)) {
                Cast cast;
                if (e instanceof HjComplexConstructor) {
                    return this.rewriteComplexConstructor((HjComplexType)toType, (HjComplexConstructor)e);
                }
                if (e instanceof Cast && (cast = (Cast)e).type().typeEquals(cast.expr().type(), null)) {
                    return ((Cast)e).expr();
                }
            } else {
                return this.createComplexConstructor((HjComplexType)toType, e);
            }
        }
        return super.ascribe(e, toType);
    }

    private Expr complexToString(Expr e) throws SemanticException {
        HjNodeFactory hnf = (HjNodeFactory)this.nf;
        Position p = e.position();
        PrimitiveType baseType = ((HjComplexType)e.type()).base();
        Expr realPart = (Expr)hnf.ComplexAccessor(p, ComplexOperation.REAL, e);
        realPart = realPart.type((Type)baseType);
        Expr imagPart = (Expr)hnf.ComplexAccessor(p, ComplexOperation.IMAG, e);
        imagPart = imagPart.type((Type)baseType);
        StringLit lpar = hnf.StringLit(p, "(");
        lpar = lpar.type(this.ts.String());
        StringLit mid = hnf.StringLit(p, ",");
        mid = mid.type(this.ts.String());
        StringLit rpar = hnf.StringLit(p, ")");
        rpar = rpar.type(this.ts.String());
        Binary strConcat = this.nf.Binary(p, (Expr)lpar, Binary.ADD, realPart);
        strConcat = strConcat.type(this.ts.String());
        strConcat = this.nf.Binary(p, (Expr)strConcat, Binary.ADD, (Expr)mid);
        strConcat = strConcat.type(this.ts.String());
        strConcat = this.nf.Binary(p, (Expr)strConcat, Binary.ADD, imagPart);
        strConcat = strConcat.type(this.ts.String());
        strConcat = this.nf.Binary(p, (Expr)strConcat, Binary.ADD, (Expr)rpar);
        strConcat = strConcat.type(this.ts.String());
        return strConcat;
    }
}

