/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlock_c
extends Stmt_c
implements Block {
    protected List<Stmt> statements;

    public AbstractBlock_c(Position pos, List<Stmt> statements) {
        super(pos);
        assert (statements != null);
        this.statements = TypedList.copyAndCheck(statements, Stmt.class, true);
    }

    @Override
    public List<Stmt> statements() {
        return this.statements;
    }

    @Override
    public Block statements(List<Stmt> statements) {
        AbstractBlock_c n = (AbstractBlock_c)this.copy();
        n.statements = TypedList.copyAndCheck(statements, Stmt.class, true);
        return n;
    }

    @Override
    public Block append(Stmt stmt) {
        ArrayList<Stmt> l = new ArrayList<Stmt>(this.statements.size() + 1);
        l.addAll(this.statements);
        l.add(stmt);
        return this.statements(l);
    }

    @Override
    public Block prepend(Stmt stmt) {
        ArrayList<Stmt> l = new ArrayList<Stmt>(this.statements.size() + 1);
        l.add(stmt);
        l.addAll(this.statements);
        return this.statements(l);
    }

    protected AbstractBlock_c reconstruct(List<Stmt> statements) {
        if (!CollectionUtil.allEqual(statements, this.statements)) {
            AbstractBlock_c n = (AbstractBlock_c)this.copy();
            n.statements = TypedList.copyAndCheck(statements, Stmt.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List statements = this.visitList(this.statements, v);
        return this.reconstruct(statements);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        Iterator<Stmt> i = this.statements.iterator();
        while (i.hasNext()) {
            Stmt n = i.next();
            this.printBlock(n, w, tr);
            if (!i.hasNext()) continue;
            w.newline();
        }
        w.end();
    }

    @Override
    public Term firstChild() {
        return AbstractBlock_c.listChild(this.statements, null);
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFGList(this.statements, this, 0);
        return succs;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int count = 0;
        Iterator<Stmt> i = this.statements.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                sb.append(" ...");
                break;
            }
            Stmt n = i.next();
            sb.append(" ");
            sb.append(n.toString());
        }
        sb.append(" }");
        return sb.toString();
    }
}

