/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Assign_c;
import polyglot.ast.Expr;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAccessAssign_c
extends Assign_c
implements ArrayAccessAssign {
    Expr array;
    Expr index;

    public ArrayAccessAssign_c(Position pos, Expr array, Expr index, Assign.Operator op, Expr right) {
        super(pos, op, right);
        this.array = array;
        this.index = index;
    }

    @Override
    public Expr array() {
        return this.array;
    }

    @Override
    public Expr index() {
        return this.index;
    }

    @Override
    public ArrayAccessAssign array(Expr array) {
        ArrayAccessAssign_c n = (ArrayAccessAssign_c)this.copy();
        n.array = array;
        return n;
    }

    @Override
    public ArrayAccessAssign index(Expr index) {
        ArrayAccessAssign_c n = (ArrayAccessAssign_c)this.copy();
        n.index = index;
        return n;
    }

    @Override
    public Assign typeCheckLeft(ContextVisitor tc) throws SemanticException {
        Type at = this.array.type();
        if (!at.isArray()) {
            throw new SemanticException("Target of array assignment is not an array element.", this.array.position());
        }
        Type it = this.index.type();
        if (!it.isInt()) {
            throw new SemanticException("Array element must be indexed by an int.", this.index.position());
        }
        return this;
    }

    @Override
    public Type leftType() {
        Type at = this.array.type();
        if (at.isArray()) {
            return at.toArray().base();
        }
        return null;
    }

    @Override
    public Expr left(NodeFactory nf) {
        ArrayAccess aa = nf.ArrayAccess(this.position(), this.array, this.index);
        if (this.type != null) {
            return aa.type(this.type);
        }
        return aa;
    }

    @Override
    public Assign visitLeft(NodeVisitor v) {
        Expr array = (Expr)this.visitChild(this.array, v);
        Expr index = (Expr)this.visitChild(this.index, v);
        return this.reconstruct(array, index);
    }

    protected Assign reconstruct(Expr array, Expr index) {
        if (array != this.array || index != this.index) {
            ArrayAccessAssign_c n = (ArrayAccessAssign_c)this.copy();
            n.array = array;
            n.index = index;
            return n;
        }
        return this;
    }

    @Override
    public Term firstChild() {
        return this.array;
    }

    @Override
    protected void acceptCFGAssign(CFGBuilder v) {
        v.visitCFG(this.array, this.index, 1);
        v.visitCFG(this.index, this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    protected void acceptCFGOpAssign(CFGBuilder v) {
        v.visitCFG(this.array, this.index, 1);
        v.visitCFG(this.index, this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>(super.throwTypes(ts));
        if (this.throwsArrayStoreException()) {
            l.add(ts.ArrayStoreException());
        }
        l.add(ts.NullPointerException());
        l.add(ts.OutOfBoundsException());
        return l;
    }

    @Override
    public boolean throwsArrayStoreException() {
        return this.op == ASSIGN && this.array.type().isReference();
    }
}

