/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayInit_c
extends Expr_c
implements ArrayInit {
    protected List<Expr> elements;

    public ArrayInit_c(Position pos, List<Expr> elements) {
        super(pos);
        assert (elements != null);
        this.elements = TypedList.copyAndCheck(elements, Expr.class, true);
    }

    @Override
    public List<Expr> elements() {
        return this.elements;
    }

    @Override
    public ArrayInit elements(List<Expr> elements) {
        ArrayInit_c n = (ArrayInit_c)this.copy();
        n.elements = TypedList.copyAndCheck(elements, Expr.class, true);
        return n;
    }

    protected ArrayInit_c reconstruct(List<Expr> elements) {
        if (!CollectionUtil.allEqual(elements, this.elements)) {
            ArrayInit_c n = (ArrayInit_c)this.copy();
            n.elements = TypedList.copyAndCheck(elements, Expr.class, true);
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List elements = this.visitList(this.elements, v);
        return this.reconstruct(elements);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Type type = null;
        for (Expr e : this.elements) {
            if (type == null) {
                type = e.type();
                continue;
            }
            type = ts.leastCommonAncestor(type, e.type(), tc.context());
        }
        if (type == null) {
            return this.type(ts.Null());
        }
        return this.type(ts.arrayOf(type));
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (this.elements.isEmpty()) {
            return child.type();
        }
        Type t = av.toType();
        if (!t.isArray()) {
            throw new InternalCompilerError("Type of array initializer must be an array.", this.position());
        }
        t = t.toArray().base();
        TypeSystem ts = av.typeSystem();
        for (Expr e : this.elements) {
            if (e != child) continue;
            if (ts.numericConversionValid(t, e.constantValue(), av.context())) {
                return child.type();
            }
            return t;
        }
        return child.type();
    }

    @Override
    public void typeCheckElements(ContextVisitor tc, Type lhsType) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!lhsType.isArray()) {
            throw new SemanticException("Cannot initialize " + lhsType + " with " + this.type + ".", this.position());
        }
        Type t = lhsType.toArray().base();
        for (Expr e : this.elements) {
            Type s = e.type();
            if (e instanceof ArrayInit) {
                ((ArrayInit)e).typeCheckElements(tc, t);
                continue;
            }
            if (ts.isImplicitCastValid(s, t, tc.context()) || ts.typeEquals(s, t, tc.context()) || ts.numericConversionValid(t, e.constantValue(), tc.context())) continue;
            throw new SemanticException("Cannot assign " + s + " to " + t + ".", e.position());
        }
    }

    @Override
    public String toString() {
        return "{ ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("{ ");
        Iterator<Expr> i = this.elements.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(" }");
    }

    @Override
    public Term firstChild() {
        return ArrayInit_c.listChild(this.elements, null);
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFGList(this.elements, this, 0);
        return succs;
    }
}

