/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.FlagsNode;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.ConstructorDef;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.Flags;
import polyglot.types.MemberDef;
import polyglot.types.Name;
import polyglot.types.ProcedureDef;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorDecl_c
extends Term_c
implements ConstructorDecl {
    protected FlagsNode flags;
    protected Id name;
    protected List<Formal> formals;
    protected List<TypeNode> throwTypes;
    protected Block body;
    protected ConstructorDef ci;

    public ConstructorDecl_c(Position pos, FlagsNode flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        super(pos);
        assert (flags != null && name != null && formals != null && throwTypes != null);
        this.flags = flags;
        this.name = name;
        this.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        this.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        this.body = body;
    }

    public List<Def> defs() {
        return Collections.singletonList(this.ci);
    }

    @Override
    public MemberDef memberDef() {
        return this.ci;
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public ConstructorDecl flags(FlagsNode flags) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public ConstructorDecl name(Id name) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public List<Formal> formals() {
        return Collections.unmodifiableList(this.formals);
    }

    @Override
    public ConstructorDecl formals(List<Formal> formals) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        return n;
    }

    @Override
    public List<TypeNode> throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    @Override
    public ConstructorDecl throwTypes(List<TypeNode> throwTypes) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        return n;
    }

    @Override
    public Term codeBody() {
        return this.body;
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public CodeBlock body(Block body) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.body = body;
        return n;
    }

    @Override
    public ConstructorDef constructorDef() {
        return this.ci;
    }

    @Override
    public ProcedureDef procedureInstance() {
        return this.ci;
    }

    @Override
    public CodeDef codeDef() {
        return this.procedureInstance();
    }

    @Override
    public ConstructorDecl constructorDef(ConstructorDef ci) {
        if (ci == this.ci) {
            return this;
        }
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.ci = ci;
        return n;
    }

    protected ConstructorDecl_c reconstruct(FlagsNode flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        if (flags != this.flags || name != this.name || !CollectionUtil.allEqual(formals, this.formals) || !CollectionUtil.allEqual(throwTypes, this.throwTypes) || body != this.body) {
            ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
            n.flags = flags;
            n.name = name;
            n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
            n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.visitSignature(v);
        Block body = (Block)n.visitChild(n.body, v);
        return body == n.body ? n : n.body(body);
    }

    @Override
    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ClassDef ct = tb.currentClass();
        assert (ct != null);
        Flags flags = this.flags.flags();
        if (ct.flags().isInterface()) {
            flags = flags.Public().Abstract();
        }
        ConstructorDef ci = this.createConstructorDef(ts, ct, flags);
        ct.addConstructor(ci);
        TypeBuilder tbChk = tb.pushCode(ci);
        final TypeBuilder tbx = tb;
        final ConstructorDef mix = ci;
        ConstructorDecl_c n = (ConstructorDecl_c)this.visitSignature(new NodeVisitor(){
            int key = 0;

            public Node override(Node n) {
                return ConstructorDecl_c.this.visitChild(n, tbx.pushCode(mix));
            }
        });
        ArrayList<Ref<? extends Type>> formalTypes = new ArrayList<Ref<? extends Type>>(n.formals().size());
        for (Formal f : n.formals()) {
            formalTypes.add(f.type().typeRef());
        }
        ArrayList<Ref<? extends Type>> throwTypes = new ArrayList<Ref<? extends Type>>(n.throwTypes().size());
        for (TypeNode tn : n.throwTypes()) {
            throwTypes.add(tn.typeRef());
        }
        ci.setFormalTypes(formalTypes);
        ci.setThrowTypes(throwTypes);
        Block body = (Block)n.visitChild(n.body, tbChk);
        n = (ConstructorDecl_c)n.body(body);
        return n.constructorDef(ci);
    }

    protected ConstructorDef createConstructorDef(TypeSystem ts, ClassDef ct, Flags flags) {
        ConstructorDef ci = ts.constructorDef(this.position(), Types.ref(ct.asType()), flags, Collections.<Ref<Type>>emptyList(), Collections.<Ref<Type>>emptyList());
        return ci;
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushCode(this.ci);
    }

    public Node visitSignature(NodeVisitor v) {
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        Id name = (Id)this.visitChild(this.name, v);
        List formals = this.visitList(this.formals, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        return this.reconstruct(flags, name, formals, throwTypes, this.body);
    }

    public Node typeCheckBody(Node parent, TypeChecker tc, TypeChecker childtc) throws SemanticException {
        ConstructorDecl_c n = this;
        Block body = (Block)n.visitChild(n.body, childtc);
        n = (ConstructorDecl_c)n.body(body);
        return n;
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        for (TypeNode tn : this.throwTypes()) {
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + ts.Throwable() + "\".", tn.position());
        }
        return this;
    }

    @Override
    public Node conformanceCheck(ContextVisitor tc) throws SemanticException {
        Context c = tc.context();
        TypeSystem ts = tc.typeSystem();
        ClassType ct = c.currentClass();
        if (ct.flags().isInterface()) {
            throw new SemanticException("Cannot declare a constructor inside an interface.", this.position());
        }
        if (ct.isAnonymous()) {
            throw new SemanticException("Cannot declare a constructor inside an anonymous class.", this.position());
        }
        Name ctName = ct.name();
        if (!ctName.equals(this.name.id())) {
            throw new SemanticException("Constructor name \"" + this.name + "\" does not match name of containing class \"" + ctName + "\".", this.position());
        }
        Flags flags = this.flags().flags();
        try {
            ts.checkConstructorFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.body == null && !flags.isNative()) {
            throw new SemanticException("Missing constructor body.", this.position());
        }
        if (this.body != null && flags.isNative()) {
            throw new SemanticException("A native constructor cannot have a body.", this.position());
        }
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(new ExceptionChecker.CodeTypeReporter("Constructor " + this.ci.signature())).push(this.constructorDef().asInstance().throwTypes());
    }

    @Override
    public String toString() {
        return this.flags.flags().translate() + this.name + "(...)";
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        tr.print(this, this.flags, w);
        tr.print(this, this.name, w);
        w.write("(");
        w.begin(0);
        Iterator<Term> i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = i.next();
            this.print(f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintHeader(w, tr);
        if (this.body != null) {
            this.printSubStmt(this.body, w, tr);
        } else {
            w.write(";");
        }
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.ci != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.ci + ")");
            w.end();
        }
    }

    @Override
    public Term firstChild() {
        return ConstructorDecl_c.listChild(this.formals(), this.body() != null ? this.body() : null);
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.body() != null) {
            v.visitCFGList(this.formals(), this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        } else {
            v.visitCFGList(this.formals(), this, 0);
        }
        return succs;
    }
}

