/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Assign_c;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Id;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Term;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAssign_c
extends Assign_c
implements FieldAssign {
    boolean targetImplicit;
    Receiver target;
    Id name;
    protected FieldInstance fi;

    public FieldAssign_c(Position pos, Receiver target, Id name, Assign.Operator op, Expr right) {
        super(pos, op, right);
        assert (name != null);
        this.target = target;
        this.name = name;
    }

    @Override
    public Assign visitLeft(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        Receiver target = (Receiver)this.visitChild(this.target, v);
        return this.reconstruct(target, name);
    }

    protected Assign reconstruct(Receiver target, Id name) {
        if (name != this.name || target != this.target) {
            FieldAssign_c n = (FieldAssign_c)this.copy();
            n.target = target;
            n.name = name;
            return n;
        }
        return this;
    }

    @Override
    public boolean targetImplicit() {
        return this.targetImplicit;
    }

    @Override
    public FieldAssign targetImplicit(boolean f) {
        FieldAssign_c n = (FieldAssign_c)this.copy();
        n.targetImplicit = f;
        return n;
    }

    @Override
    public Expr left(NodeFactory nf) {
        Field f = nf.Field(this.position(), this.target, this.name);
        if (this.fi != null) {
            f = f.fieldInstance(this.fi);
        }
        f = f.targetImplicit(this.targetImplicit);
        if (this.type != null && this.fi != null) {
            f = (Field)f.type(this.fi.type());
        }
        return f;
    }

    @Override
    public Type leftType() {
        if (this.fi == null) {
            return null;
        }
        return this.fi.type();
    }

    @Override
    public Receiver target() {
        return this.target;
    }

    @Override
    public FieldAssign target(Receiver target) {
        FieldAssign_c n = (FieldAssign_c)this.copy();
        n.target = target;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public FieldAssign name(Id name) {
        FieldAssign_c n = (FieldAssign_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public Assign typeCheckLeft(ContextVisitor tc) throws SemanticException {
        Field left = (Field)this.left(tc.nodeFactory());
        left = (Field)left.del().typeCheck(tc);
        FieldAssign_c n = (FieldAssign_c)this.reconstruct(left.target(), left.name());
        return n.fieldInstance(left.fieldInstance());
    }

    @Override
    public FieldInstance fieldInstance() {
        return this.fi;
    }

    @Override
    public FieldAssign fieldInstance(FieldInstance fi) {
        FieldAssign_c n = (FieldAssign_c)this.copy();
        n.fi = fi;
        return n;
    }

    @Override
    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return this.right;
    }

    @Override
    protected void acceptCFGAssign(CFGBuilder v) {
        if (this.target instanceof Term) {
            v.visitCFG((Term)((Object)this.target), this.right(), 1);
        }
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    protected void acceptCFGOpAssign(CFGBuilder v) {
        if (this.target instanceof Term) {
            v.visitCFG((Term)((Object)this.target), this.right(), 1);
        }
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>(super.throwTypes(ts));
        if (this.target instanceof Expr) {
            l.add(ts.NullPointerException());
        }
        return l;
    }
}

