/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.FloatLit;
import polyglot.ast.Lit_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class FloatLit_c
extends Lit_c
implements FloatLit {
    protected FloatLit.Kind kind;
    protected double value;

    public FloatLit_c(Position pos, FloatLit.Kind kind, double value) {
        super(pos);
        assert (kind != null);
        this.kind = kind;
        this.value = value;
    }

    public FloatLit.Kind kind() {
        return this.kind;
    }

    public FloatLit kind(FloatLit.Kind kind) {
        FloatLit_c n = (FloatLit_c)this.copy();
        n.kind = kind;
        return n;
    }

    public double value() {
        return this.value;
    }

    public FloatLit value(double value) {
        FloatLit_c n = (FloatLit_c)this.copy();
        n.value = value;
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        if (this.kind == FLOAT) {
            return this.type(tc.typeSystem().Float());
        }
        if (this.kind == DOUBLE) {
            return this.type(tc.typeSystem().Double());
        }
        throw new InternalCompilerError("Unrecognized FloatLit kind " + this.kind);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.kind == FLOAT) {
            w.write(Float.toString((float)this.value) + "F");
        } else if (this.kind == DOUBLE) {
            w.write(Double.toString(this.value));
        } else {
            throw new InternalCompilerError("Unrecognized FloatLit kind " + this.kind);
        }
    }

    public Object constantValue() {
        if (this.kind == FLOAT) {
            return new Float(this.value);
        }
        return new Double(this.value);
    }

    public Precedence precedence() {
        if (this.value < 0.0) {
            return Precedence.UNARY;
        }
        return Precedence.LITERAL;
    }
}

