/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.FlagsNode;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.LocalDef;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formal_c
extends Term_c
implements Formal {
    protected LocalDef li;
    protected FlagsNode flags;
    protected TypeNode type;
    protected Id name;

    public Formal_c(Position pos, FlagsNode flags, TypeNode type, Id name) {
        super(pos);
        assert (flags != null && type != null && name != null);
        this.flags = flags;
        this.type = type;
        this.name = name;
    }

    public List<Def> defs() {
        return Collections.singletonList(this.li);
    }

    @Override
    public Type declType() {
        return this.type.type();
    }

    @Override
    public FlagsNode flags() {
        return this.flags;
    }

    @Override
    public Formal flags(FlagsNode flags) {
        Formal_c n = (Formal_c)this.copy();
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public Formal type(TypeNode type) {
        Formal_c n = (Formal_c)this.copy();
        n.type = type;
        return n;
    }

    @Override
    public Id name() {
        return this.name;
    }

    @Override
    public Formal name(Id name) {
        Formal_c n = (Formal_c)this.copy();
        n.name = name;
        return n;
    }

    @Override
    public LocalDef localDef() {
        return this.li;
    }

    @Override
    public Formal localDef(LocalDef li) {
        if (li == this.li) {
            return this;
        }
        Formal_c n = (Formal_c)this.copy();
        n.li = li;
        return n;
    }

    protected Formal_c reconstruct(FlagsNode flags, TypeNode type, Id name) {
        if (flags != this.flags || this.type != type || name != this.name) {
            Formal_c n = (Formal_c)this.copy();
            n.flags = flags;
            n.type = type;
            n.name = name;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        FlagsNode flags = (FlagsNode)this.visitChild(this.flags, v);
        TypeNode type = (TypeNode)this.visitChild(this.type, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(flags, type, name);
    }

    @Override
    public void addDecls(Context c) {
        c.addVariable(this.li.asInstance());
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.print(this.flags, w, tr);
        this.print(this.type, w, tr);
        w.write(" ");
        tr.print(this, this.name, w);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Formal_c n = (Formal_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalDef li = ts.localDef(this.position(), this.flags().flags(), this.type.typeRef(), this.name.id());
        li.setNotConstant();
        return n.localDef(li);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = null;
        try {
            outerLocal = c.findLocal(this.li.name());
        }
        catch (SemanticException e) {
            // empty catch block
        }
        if (outerLocal != null && !this.li.equals(outerLocal.def()) && c.isLocal(this.li.name())) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        TypeSystem ts = tc.typeSystem();
        try {
            ts.checkLocalFlags(this.flags().flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        return this;
    }

    @Override
    public Term firstChild() {
        return this.type;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.type, this, 0);
        return succs;
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    @Override
    public String toString() {
        return this.flags.flags().translate() + this.type + " " + this.name;
    }
}

