/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.If;
import polyglot.ast.Node;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class If_c
extends Stmt_c
implements If {
    protected Expr cond;
    protected Stmt consequent;
    protected Stmt alternative;

    public If_c(Position pos, Expr cond, Stmt consequent, Stmt alternative) {
        super(pos);
        assert (cond != null && consequent != null);
        this.cond = cond;
        this.consequent = consequent;
        this.alternative = alternative;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public If cond(Expr cond) {
        If_c n = (If_c)this.copy();
        n.cond = cond;
        return n;
    }

    @Override
    public Stmt consequent() {
        return this.consequent;
    }

    @Override
    public If consequent(Stmt consequent) {
        If_c n = (If_c)this.copy();
        n.consequent = consequent;
        return n;
    }

    @Override
    public Stmt alternative() {
        return this.alternative;
    }

    @Override
    public If alternative(Stmt alternative) {
        If_c n = (If_c)this.copy();
        n.alternative = alternative;
        return n;
    }

    protected If_c reconstruct(Expr cond, Stmt consequent, Stmt alternative) {
        if (cond != this.cond || consequent != this.consequent || alternative != this.alternative) {
            If_c n = (If_c)this.copy();
            n.cond = cond;
            n.consequent = consequent;
            n.alternative = alternative;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Node alternative;
        Expr cond = (Expr)this.visitChild(this.cond, v);
        Node consequent = this.visitChild(this.consequent, v);
        if (consequent instanceof NodeList) {
            consequent = ((NodeList)consequent).toBlock();
        }
        if ((alternative = this.visitChild(this.alternative, v)) instanceof NodeList) {
            alternative = ((NodeList)alternative).toBlock();
        }
        return this.reconstruct(cond, (Stmt)consequent, (Stmt)alternative);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean(), tc.context())) {
            throw new SemanticException("Condition of if statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "if (" + this.cond + ") " + this.consequent + (this.alternative != null ? " else " + this.alternative : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("if (");
        this.printBlock(this.cond, w, tr);
        w.write(")");
        this.printSubStmt(this.consequent, w, tr);
        if (this.alternative != null) {
            if (this.consequent instanceof Block) {
                w.write(" ");
            } else {
                w.allowBreak(0, " ");
            }
            if (this.alternative instanceof Block) {
                w.write("else ");
                this.print(this.alternative, w, tr);
            } else {
                w.begin(4);
                w.write("else");
                this.printSubStmt(this.alternative, w, tr);
                w.end();
            }
        }
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.alternative == null) {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
            v.visitCFG(this.consequent, this, 0);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this.alternative, 1);
            v.visitCFG(this.consequent, this, 0);
            v.visitCFG(this.alternative, this, 0);
        }
        return succs;
    }
}

