/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.frontend.Globals;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Named;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.PrettyPrinter;

public class Import_c
extends Node_c
implements Import {
    protected Import.Kind kind;
    protected QName name;

    public Import_c(Position pos, Import.Kind kind, QName name) {
        super(pos);
        assert (kind != null && name != null);
        this.name = name;
        this.kind = kind;
    }

    public QName name() {
        return this.name;
    }

    public Import name(QName name) {
        Import_c n = (Import_c)this.copy();
        n.name = name;
        return n;
    }

    public Import.Kind kind() {
        return this.kind;
    }

    public Import kind(Import.Kind kind) {
        Import_c n = (Import_c)this.copy();
        n.kind = kind;
        return n;
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        ClassType ct;
        Type t;
        Named n;
        TypeSystem ts = tc.typeSystem();
        if (this.kind == PACKAGE && ts.systemResolver().packageExists(this.name)) {
            return this;
        }
        try {
            n = ts.systemResolver().find(this.name);
        }
        catch (SemanticException e) {
            throw new SemanticException("Package or class " + this.name + " not found.");
        }
        if (n instanceof Type && (t = (Type)((Object)n)).isClass() && !ts.classAccessibleFromPackage((ClassDef)(ct = t.toClass()).def(), tc.context().package_())) {
            throw new SemanticException("Class " + ct + " is not accessible.");
        }
        return this;
    }

    public String toString() {
        return "import " + this.name + (this.kind == PACKAGE ? ".*" : "");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!Globals.Options().fully_qualified_names) {
            w.write("import ");
            w.write(this.name.toString());
            if (this.kind == PACKAGE) {
                w.write(".*");
            }
            w.write(";");
            w.newline(0);
        }
    }
}

