/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Instanceof;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instanceof_c
extends Expr_c
implements Instanceof {
    protected Expr expr;
    protected TypeNode compareType;

    public Instanceof_c(Position pos, Expr expr, TypeNode compareType) {
        super(pos);
        assert (expr != null && compareType != null);
        this.expr = expr;
        this.compareType = compareType;
    }

    @Override
    public Precedence precedence() {
        return Precedence.INSTANCEOF;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Instanceof expr(Expr expr) {
        Instanceof_c n = (Instanceof_c)this.copy();
        n.expr = expr;
        return n;
    }

    @Override
    public TypeNode compareType() {
        return this.compareType;
    }

    @Override
    public Instanceof compareType(TypeNode compareType) {
        Instanceof_c n = (Instanceof_c)this.copy();
        n.compareType = compareType;
        return n;
    }

    protected Instanceof_c reconstruct(Expr expr, TypeNode compareType) {
        if (expr != this.expr || compareType != this.compareType) {
            Instanceof_c n = (Instanceof_c)this.copy();
            n.expr = expr;
            n.compareType = compareType;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        TypeNode compareType = (TypeNode)this.visitChild(this.compareType, v);
        return this.reconstruct(expr, compareType);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!this.compareType.type().isReference()) {
            throw new SemanticException("Type operand " + this.compareType.type() + " must be a reference type.", this.compareType.position());
        }
        if (!ts.isCastValid(this.expr.type(), this.compareType.type(), tc.context())) {
            throw new SemanticException("Expression operand type " + this.expr.type() + " incompatible with type operand " + this.compareType.type() + ".", this.expr.position());
        }
        return this.type(ts.Boolean());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Object();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return this.expr + " instanceof " + this.compareType;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.expr, w, tr);
        w.write(" instanceof ");
        this.print(this.compareType, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG(this.expr, this.compareType, 1);
        v.visitCFG(this.compareType, this, 0);
        return succs;
    }
}

