/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.frontend.Goal;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Def;
import polyglot.types.ErrorRef_c;
import polyglot.types.Name;
import polyglot.types.ProcedureInstance;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class New_c
extends Expr_c
implements New {
    protected Expr qualifier;
    protected TypeNode tn;
    protected List<Expr> arguments;
    protected ClassBody body;
    protected ConstructorInstance ci;
    protected ClassDef anonType;
    Goal enable = null;

    public New_c(Position pos, Expr qualifier, TypeNode tn, List<Expr> arguments, ClassBody body) {
        super(pos);
        assert (tn != null && arguments != null);
        this.qualifier = qualifier;
        this.tn = tn;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        this.body = body;
    }

    public List<Def> defs() {
        if (this.body != null) {
            return Collections.singletonList(this.anonType);
        }
        return Collections.emptyList();
    }

    @Override
    public Expr qualifier() {
        return this.qualifier;
    }

    @Override
    public New qualifier(Expr qualifier) {
        New_c n = (New_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    @Override
    public TypeNode objectType() {
        return this.tn;
    }

    @Override
    public New objectType(TypeNode tn) {
        New_c n = (New_c)this.copy();
        n.tn = tn;
        return n;
    }

    @Override
    public ClassDef anonType() {
        return this.anonType;
    }

    @Override
    public New anonType(ClassDef anonType) {
        if (anonType == this.anonType) {
            return this;
        }
        New_c n = (New_c)this.copy();
        n.anonType = anonType;
        return n;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    @Override
    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    @Override
    public New constructorInstance(ConstructorInstance ci) {
        if (ci == this.ci) {
            return this;
        }
        New_c n = (New_c)this.copy();
        n.ci = ci;
        return n;
    }

    @Override
    public List<Expr> arguments() {
        return this.arguments;
    }

    @Override
    public ProcedureCall arguments(List<Expr> arguments) {
        New_c n = (New_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    @Override
    public ClassBody body() {
        return this.body;
    }

    @Override
    public New body(ClassBody body) {
        New_c n = (New_c)this.copy();
        n.body = body;
        return n;
    }

    protected New_c reconstruct(Expr qualifier, TypeNode tn, List<Expr> arguments, ClassBody body) {
        if (qualifier != this.qualifier || tn != this.tn || !CollectionUtil.allEqual(arguments, this.arguments) || body != this.body) {
            New_c n = (New_c)this.copy();
            n.tn = tn;
            n.qualifier = qualifier;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = (Expr)this.visitChild(this.qualifier, v);
        TypeNode tn = (TypeNode)this.visitChild(this.tn, v);
        List arguments = this.visitList(this.arguments, v);
        ClassBody body = (ClassBody)this.visitChild(this.body, v);
        return this.reconstruct(qualifier, tn, arguments, body);
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.body && this.anonType != null && this.body != null) {
            c = c.pushClass(this.anonType, this.anonType.asType());
        }
        return super.enterChildScope(child, c);
    }

    @Override
    public Node buildTypesOverride(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        New_c n = this;
        ConstructorInstance ci = ts.createConstructorInstance(this.position(), new ErrorRef_c(ts, this.position(), "Cannot get ConstructorDef before type-checking new expression."));
        n = (New_c)n.constructorInstance(ci);
        Expr qual = (Expr)n.visitChild(n.qualifier(), tb);
        TypeNode objectType = (TypeNode)n.visitChild(n.objectType(), tb);
        List arguments = n.visitList(n.arguments(), tb);
        ClassBody body = null;
        if (n.body() != null) {
            TypeBuilder tb2 = tb.pushAnonClass(this.position());
            ClassDef type = tb2.currentClass();
            n = (New_c)n.anonType(type);
            body = (ClassBody)n.visitChild(n.body(), tb2);
        }
        n = n.reconstruct(qual, objectType, arguments, body);
        return n.type(ts.unknownType(this.position()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public New_c typeCheckObjectType(TypeChecker childtc) throws SemanticException {
        New_c n = this;
        TypeSystem ts = childtc.typeSystem();
        NodeFactory nf = childtc.nodeFactory();
        Context c = childtc.context();
        Expr qualifier = n.qualifier;
        TypeNode tn = n.tn;
        List<Expr> arguments = n.arguments;
        ClassBody body = n.body;
        if (qualifier == null) {
            if ((tn = (TypeNode)n.visitChild(tn, childtc)).type() instanceof UnknownType) {
                throw new SemanticException();
            }
            if (!tn.type().isClass()) throw new SemanticException("Cannot instantiate type " + tn.type() + ".");
            ClassType ct = tn.type().toClass();
            if (!ct.isMember()) return n.reconstruct(qualifier, tn, arguments, body);
            if (ct.flags().isStatic()) return n.reconstruct(qualifier, tn, arguments, body);
            New k = n.findQualifier(childtc, ct);
            qualifier = (Expr)k.visitChild(k.qualifier(), childtc);
            return n.reconstruct(qualifier, tn, arguments, body);
        } else {
            qualifier = (Expr)n.visitChild(n.qualifier(), childtc);
            if (!(tn instanceof AmbTypeNode)) throw new SemanticException("Only simply-named member classes may be instantiated by a qualified new expression.", n.objectType().position());
            if (((AmbTypeNode)tn).prefix() != null) throw new SemanticException("Only simply-named member classes may be instantiated by a qualified new expression.", n.objectType().position());
            Name name = ((AmbTypeNode)tn).name().id();
            assert (name != null);
            if (!qualifier.type().isClass()) {
                throw new SemanticException("Cannot instantiate member class of non-class type.", n.position());
            }
            Type ct = ts.findMemberType(qualifier.type(), name, c);
            tn.typeRef().update(ct);
            tn = nf.CanonicalTypeNode(n.objectType().position(), tn.typeRef());
        }
        return n.reconstruct(qualifier, tn, arguments, body);
    }

    @Override
    public Node typeCheckOverride(Node parent, ContextVisitor tc) throws SemanticException {
        NodeVisitor childv = tc.enter(parent, this);
        if (!(childv instanceof TypeChecker)) {
            return this;
        }
        TypeChecker childtc = (TypeChecker)childv;
        New_c n = this.typeCheckHeader(childtc);
        ClassBody body = (ClassBody)n.visitChild(n.body, childtc);
        n = (New_c)n.body(body);
        n = (New_c)tc.leave(parent, this, n, childtc);
        return n;
    }

    protected New_c typeCheckHeader(TypeChecker childtc) throws SemanticException {
        TypeSystem ts = childtc.typeSystem();
        New_c n = this;
        n = n.typeCheckObjectType(childtc);
        Expr qualifier = n.qualifier;
        TypeNode tn = n.tn;
        List arguments = n.arguments;
        ClassBody body = n.body;
        if (body != null) {
            Ref<? extends Type> ct = tn.typeRef();
            ClassDef anonType = n.anonType();
            assert (anonType != null);
            if (!ct.get().toClass().flags().isInterface()) {
                anonType.superType(ct);
            } else {
                anonType.superType(Types.ref(ts.Object()));
                assert (anonType.interfaces().isEmpty() || anonType.interfaces().get(0) == ct);
                if (anonType.interfaces().isEmpty()) {
                    anonType.addInterface(ct);
                }
            }
        }
        arguments = this.visitList(arguments, childtc);
        n = n.reconstruct(qualifier, tn, arguments, body);
        return n;
    }

    protected New findQualifier(TypeChecker ar, ClassType ct) throws SemanticException {
        NodeFactory nf = ar.nodeFactory();
        TypeSystem ts = ar.typeSystem();
        Context c = ar.context();
        Type outer = null;
        Name name = ct.name();
        ClassType t = c.currentClass();
        if (t == this.anonType) {
            t = t.outer();
        }
        while (t != null) {
            try {
                ClassType cmt;
                Type mt = ts.findMemberType(t, name, c);
                if (mt instanceof ClassType && (cmt = (ClassType)mt).def() == ct.def()) {
                    outer = t;
                    break;
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
            t = t.outer();
        }
        if (outer == null) {
            throw new SemanticException("Could not find non-static member class \"" + name + "\".", this.position());
        }
        Expr q = outer.typeEquals(c.currentClass(), ar.context()) ? nf.This(this.position().startOf()) : nf.This(this.position().startOf(), nf.CanonicalTypeNode(this.position(), outer));
        q = q.type(outer);
        return this.qualifier(q);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        ConstructorInstance ci;
        TypeSystem ts = tc.typeSystem();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        for (Expr e : this.arguments) {
            argTypes.add(e.type());
        }
        this.typeCheckFlags(tc);
        this.typeCheckNested(tc);
        ClassType ct = this.tn.type().toClass();
        if (!ct.flags().isInterface()) {
            Context c = tc.context();
            if (this.anonType != null) {
                c = c.pushClass(this.anonType, this.anonType.asType());
            }
            ci = ts.findConstructor(ct, ts.ConstructorMatcher(ct, argTypes, c));
        } else {
            ConstructorDef dci = ts.defaultConstructor(this.position(), Types.ref(ct));
            ci = dci.asInstance();
        }
        New n = this.constructorInstance(ci);
        if (this.anonType != null) {
            ct = this.anonType.asType();
        }
        return n.type(ct);
    }

    protected void typeCheckNested(ContextVisitor tc) throws SemanticException {
        if (this.qualifier != null) {
            Type qt = this.qualifier.type();
            if (!qt.isClass()) {
                throw new SemanticException("Cannot instantiate member class of a non-class type.", this.qualifier.position());
            }
            ClassType ct = this.tn.type().toClass();
            if (!ct.isInnerClass()) {
                throw new SemanticException("Cannot provide a containing instance for non-inner class " + ct.fullName() + ".", this.qualifier.position());
            }
        } else {
            ClassType ct = this.tn.type().toClass();
            if (ct.isMember()) {
                ClassType t = ct;
                while (t.isMember()) {
                    if (!t.flags().isStatic()) {
                        throw new SemanticException("Cannot allocate non-static member class \"" + t + "\".", this.position());
                    }
                    t = t.outer();
                }
            }
        }
    }

    protected void typeCheckFlags(ContextVisitor tc) throws SemanticException {
        ClassType ct = this.tn.type().toClass();
        if (this.body == null) {
            if (ct.flags().isInterface()) {
                throw new SemanticException("Cannot instantiate an interface.", this.position());
            }
            if (ct.flags().isAbstract()) {
                throw new SemanticException("Cannot instantiate an abstract class.", this.position());
            }
        } else {
            if (ct.flags().isFinal()) {
                throw new SemanticException("Cannot create an anonymous subclass of a final class.", this.position());
            }
            if (ct.flags().isInterface() && !this.arguments.isEmpty()) {
                throw new SemanticException("Cannot pass arguments to an anonymous class that implements an interface.", this.arguments.get(0).position());
            }
        }
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.qualifier) {
            StructType t = this.ci.container();
            if (t.isClass() && t.toClass().isMember()) {
                t = t.toClass().container();
                return t;
            }
            return child.type();
        }
        Iterator<Expr> i = this.arguments.iterator();
        Iterator<Type> j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.ci == null) {
            throw new InternalCompilerError(this.position(), "Null constructor instance after type check.");
        }
        for (Type t : this.ci.throwTypes()) {
            ec.throwsException(t, this.position());
        }
        return super.exceptionCheck(ec);
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public String toString() {
        return (this.qualifier != null ? this.qualifier.toString() + "." : "") + "new " + this.tn + "(...)" + (this.body != null ? " " + this.body : "");
    }

    protected void printQualifier(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.print(this.qualifier, w, tr);
            w.write(".");
        }
    }

    protected void printArgs(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator<Expr> i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(")");
    }

    protected void printBody(CodeWriter w, PrettyPrinter tr) {
        if (this.body != null) {
            w.write(" {");
            this.print(this.body, w, tr);
            w.write("}");
        }
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printQualifier(w, tr);
        w.write("new ");
        if (this.qualifier != null) {
            w.write(this.tn.nameString());
        } else {
            this.print(this.tn, w, tr);
        }
        this.printArgs(w, tr);
        this.printBody(w, tr);
    }

    @Override
    public Term firstChild() {
        return this.qualifier != null ? this.qualifier : this.tn;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.qualifier != null) {
            v.visitCFG(this.qualifier, this.tn, 1);
        }
        if (this.body() != null) {
            v.visitCFG(this.tn, New_c.listChild(this.arguments, this.body()), 1);
            v.visitCFGList(this.arguments, this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        } else if (!this.arguments.isEmpty()) {
            v.visitCFG(this.tn, New_c.listChild(this.arguments, null), 1);
            v.visitCFGList(this.arguments, this, 0);
        } else {
            v.visitCFG(this.tn, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>();
        assert (this.ci != null) : "null ci for " + this;
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }
}

