/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.Node_c;
import polyglot.types.Context;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.NodeVisitor;

public class NodeList_c
extends Node_c
implements NodeList {
    protected NodeFactory nf;
    protected List<Node> nodes;

    public NodeList_c(Position pos, NodeFactory nf, List nodes) {
        super(pos);
        assert (nodes != null);
        this.nf = nf;
        this.nodes = TypedList.copyAndCheck(nodes, Node.class, true);
    }

    public List nodes() {
        return this.nodes;
    }

    public NodeList nodes(List nodes) {
        NodeList_c result = (NodeList_c)this.copy();
        result.nodes = TypedList.copyAndCheck(nodes, Node.class, true);
        return result;
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public Block toBlock() {
        return this.nf.Block(this.position, this.nodes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        Iterator<Node> i = this.nodes.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                sb.append(" ...");
                break;
            }
            Node n = i.next();
            sb.append(" ");
            sb.append(n.toString());
        }
        return sb.toString();
    }

    public void addDecls(Context c) {
        for (Node n : this.nodes) {
            n.addDecls(c);
        }
    }

    public Node visitChildren(NodeVisitor v) {
        List l = this.visitList(this.nodes, v);
        if (CollectionUtil.allEqual(l, this.nodes)) {
            return this;
        }
        return this.nodes(l);
    }
}

