/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Return;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.CodeDef;
import polyglot.types.ConstructorDef;
import polyglot.types.Context;
import polyglot.types.FunctionDef;
import polyglot.types.InitializerDef;
import polyglot.types.MethodDef;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Return_c
extends Stmt_c
implements Return {
    protected Expr expr;

    public Return_c(Position pos, Expr expr) {
        super(pos);
        this.expr = expr;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Return expr(Expr expr) {
        Return_c n = (Return_c)this.copy();
        n.expr = expr;
        return n;
    }

    protected Return_c reconstruct(Expr expr) {
        if (expr != this.expr) {
            Return_c n = (Return_c)this.copy();
            n.expr = expr;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild(this.expr, v);
        return this.reconstruct(expr);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        CodeDef ci = c.currentCode();
        if (ci instanceof InitializerDef) {
            throw new SemanticException("Cannot return from an initializer block.", this.position());
        }
        if (ci instanceof ConstructorDef) {
            if (this.expr != null) {
                throw new SemanticException("Cannot return a value from " + ci + ".", this.position());
            }
            return this;
        }
        if (ci instanceof FunctionDef) {
            FunctionDef fi = (FunctionDef)ci;
            Type returnType = Types.get(fi.returnType());
            if (returnType == null) {
                throw new InternalCompilerError("Null return type for " + fi);
            }
            if (returnType instanceof UnknownType) {
                throw new SemanticException();
            }
            if (returnType.isVoid()) {
                if (this.expr != null) {
                    throw new SemanticException("Cannot return a value from " + fi + ".", this.position());
                }
                return this;
            }
            if (this.expr == null) {
                throw new SemanticException("Must return a value from " + fi + ".", this.position());
            }
            if (ts.isImplicitCastValid(this.expr.type(), returnType, c)) {
                return this;
            }
            if (ts.numericConversionValid(returnType, this.expr.constantValue(), c)) {
                return this;
            }
            throw new SemanticException("Cannot return expression of type " + this.expr.type() + " from " + fi + ".", this.expr.position());
        }
        throw new SemanticException("Cannot return from this context.", this.position());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Context c;
        CodeDef ci;
        if (child == this.expr && (ci = (c = av.context()).currentCode()) instanceof MethodDef) {
            MethodDef mi = (MethodDef)ci;
            TypeSystem ts = av.typeSystem();
            if (ts.numericConversionValid(mi.returnType().get(), child.constantValue(), c)) {
                return child.type();
            }
            return mi.returnType().get();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "return" + (this.expr != null ? " " + this.expr : "") + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("return");
        if (this.expr != null) {
            w.write(" ");
            this.print(this.expr, w, tr);
        }
        w.write(";");
    }

    @Override
    public Term firstChild() {
        if (this.expr != null) {
            return this.expr;
        }
        return null;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.expr != null) {
            v.visitCFG(this.expr, this, 0);
        }
        v.visitReturn(this);
        return Collections.EMPTY_LIST;
    }
}

