/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Special_c
extends Expr_c
implements Special {
    protected Special.Kind kind;
    protected TypeNode qualifier;

    public Special_c(Position pos, Special.Kind kind, TypeNode qualifier) {
        super(pos);
        assert (kind != null);
        this.kind = kind;
        this.qualifier = qualifier;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Special.Kind kind() {
        return this.kind;
    }

    @Override
    public Special kind(Special.Kind kind) {
        Special_c n = (Special_c)this.copy();
        n.kind = kind;
        return n;
    }

    @Override
    public TypeNode qualifier() {
        return this.qualifier;
    }

    @Override
    public Special qualifier(TypeNode qualifier) {
        Special_c n = (Special_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    protected Special_c reconstruct(TypeNode qualifier) {
        if (qualifier != this.qualifier) {
            Special_c n = (Special_c)this.copy();
            n.qualifier = qualifier;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode qualifier = (TypeNode)this.visitChild(this.qualifier, v);
        return this.reconstruct(qualifier);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ClassType t = null;
        if (this.qualifier == null) {
            t = c.currentClass();
        } else if (this.qualifier.type().isClass()) {
            t = this.qualifier.type().toClass();
            if (!c.currentClass().hasEnclosingInstance(t)) {
                throw new SemanticException("The nested class \"" + c.currentClass() + "\" does not have " + "an enclosing instance of type \"" + t + "\".", this.qualifier.position());
            }
        } else {
            throw new SemanticException("Invalid qualifier for \"this\" or \"super\".", this.qualifier.position());
        }
        if (t == null || c.inStaticContext() && ts.typeEquals(t, c.currentClass(), c)) {
            throw new SemanticException("Cannot access a non-static member or refer to \"this\" or \"super\" from a static context.", this.position());
        }
        if (this.kind == THIS) {
            return this.type(t);
        }
        if (this.kind == SUPER) {
            return this.type(t.superClass());
        }
        return this;
    }

    @Override
    public Term firstChild() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        return null;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.qualifier != null) {
            v.visitCFG(this.qualifier, this, 0);
        }
        return succs;
    }

    @Override
    public String toString() {
        return (this.qualifier != null ? this.qualifier + "." : "") + this.kind;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.print(this.qualifier, w, tr);
            w.write(".");
        }
        w.write(this.kind.toString());
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.kind != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(kind " + this.kind + ")");
            w.end();
        }
    }
}

