/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.While;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class While_c
extends Loop_c
implements While {
    protected Expr cond;
    protected Stmt body;

    public While_c(Position pos, Expr cond, Stmt body) {
        super(pos);
        assert (cond != null && body != null);
        this.cond = cond;
        this.body = body;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public While cond(Expr cond) {
        While_c n = (While_c)this.copy();
        n.cond = cond;
        return n;
    }

    @Override
    public Stmt body() {
        return this.body;
    }

    @Override
    public While body(Stmt body) {
        While_c n = (While_c)this.copy();
        n.body = body;
        return n;
    }

    protected While_c reconstruct(Expr cond, Stmt body) {
        if (cond != this.cond || body != this.body) {
            While_c n = (While_c)this.copy();
            n.cond = cond;
            n.body = body;
            return n;
        }
        return this;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr cond = (Expr)this.visitChild(this.cond, v);
        Node body = this.visitChild(this.body, v);
        if (body instanceof NodeList) {
            body = ((NodeList)body).toBlock();
        }
        return this.reconstruct(cond, (Stmt)body);
    }

    @Override
    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean(), tc.context())) {
            throw new SemanticException("Condition of while statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "while (" + this.cond + ") ...";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("while (");
        this.printBlock(this.cond, w, tr);
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public List<Term> acceptCFG(CFGBuilder v, List<Term> succs) {
        if (this.condIsConstantTrue()) {
            v.visitCFG(this.cond, this.body, 1);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.body, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
        }
        v.push(this).visitCFG(this.body, this.cond, 1);
        return succs;
    }

    @Override
    public Term continueTarget() {
        return this.cond;
    }
}

