/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileResource;
import polyglot.frontend.FileSource;
import polyglot.frontend.JobExt;
import polyglot.frontend.Parser;
import polyglot.frontend.Resource;
import polyglot.frontend.Scheduler;
import polyglot.frontend.SourceLoader;
import polyglot.frontend.Stats;
import polyglot.frontend.TargetFactory;
import polyglot.main.Options;
import polyglot.main.Version;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.util.ErrorQueue;

public abstract class AbstractExtensionInfo
implements ExtensionInfo {
    protected Compiler compiler;
    private Options options;
    protected TypeSystem ts = null;
    protected NodeFactory nf = null;
    protected SourceLoader source_loader = null;
    protected TargetFactory target_factory = null;
    protected Stats stats;
    protected Scheduler scheduler;

    public abstract String compilerName();

    public abstract String defaultFileExtension();

    public abstract Version version();

    public Options getOptions() {
        if (this.options == null) {
            this.options = this.createOptions();
        }
        return this.options;
    }

    protected Options createOptions() {
        return new Options(this);
    }

    public Stats getStats() {
        if (this.stats == null) {
            this.stats = new Stats(this);
        }
        return this.stats;
    }

    public Compiler compiler() {
        return this.compiler;
    }

    public void initCompiler(Compiler compiler) {
        this.compiler = compiler;
        compiler.addExtension(this);
        this.typeSystem();
        this.nodeFactory();
        this.scheduler();
        this.initTypeSystem();
    }

    protected abstract void initTypeSystem();

    public String[] fileExtensions() {
        String[] sx;
        String[] stringArray = sx = this.getOptions() == null ? null : this.getOptions().source_ext;
        if (sx == null) {
            sx = this.defaultFileExtensions();
        }
        if (sx.length == 0) {
            return this.defaultFileExtensions();
        }
        return sx;
    }

    public String[] defaultFileExtensions() {
        String ext = this.defaultFileExtension();
        return new String[]{ext};
    }

    public SourceLoader sourceLoader() {
        if (this.source_loader == null) {
            this.source_loader = new SourceLoader(this, this.getOptions().source_path);
        }
        return this.source_loader;
    }

    public TargetFactory targetFactory() {
        if (this.target_factory == null) {
            this.target_factory = new TargetFactory(this.getOptions().output_directory, this.getOptions().output_ext, this.getOptions().output_stdout);
        }
        return this.target_factory;
    }

    protected abstract Scheduler createScheduler();

    public final Scheduler scheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.createScheduler();
        }
        return this.scheduler;
    }

    protected abstract TypeSystem createTypeSystem();

    public final TypeSystem typeSystem() {
        if (this.ts == null) {
            this.ts = this.createTypeSystem();
        }
        return this.ts;
    }

    protected abstract NodeFactory createNodeFactory();

    public final NodeFactory nodeFactory() {
        if (this.nf == null) {
            this.nf = this.createNodeFactory();
        }
        return this.nf;
    }

    public JobExt jobExt() {
        return null;
    }

    public abstract Parser parser(Reader var1, FileSource var2, ErrorQueue var3);

    public String toString() {
        return this.getClass().getName();
    }

    public ClassFile createClassFile(File classFileSource, byte[] code) {
        return new ClassFile(classFileSource, code, this);
    }

    public FileSource createFileSource(File f, boolean user) throws IOException {
        return this.createFileSource(new FileResource(f), user);
    }

    public FileSource createFileSource(Resource f, boolean user) throws IOException {
        return new FileSource(f, user);
    }
}

