/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Globals;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.Source;
import polyglot.frontend.SourceLoader;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.util.CodeWriter;
import polyglot.util.ErrorLimitError;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.OptimalCodeWriter;
import polyglot.util.SimpleCodeWriter;
import polyglot.util.StdErrorQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    private ExtensionInfo extensionInfo;
    private List allExtensions;
    private ErrorQueue eq;
    private ClassFileLoader loader;
    private Collection outputFiles = new HashSet();

    public Compiler(ExtensionInfo extensionInfo) {
        this(extensionInfo, new StdErrorQueue(System.err, extensionInfo.getOptions().error_count, extensionInfo.compilerName()));
    }

    public Compiler(ExtensionInfo extensionInfo, ErrorQueue eq) {
        this.extensionInfo = extensionInfo;
        this.eq = eq;
        this.allExtensions = new ArrayList(2);
        this.loader = new ClassFileLoader(extensionInfo);
        extensionInfo.initCompiler(this);
    }

    public Collection outputFiles() {
        return this.outputFiles;
    }

    public boolean compileFiles(Collection filenames) {
        ArrayList<Source> sources = new ArrayList<Source>(filenames.size());
        try {
            try {
                SourceLoader source_loader = this.sourceExtension().sourceLoader();
                for (String sourceName : filenames) {
                    FileSource source = source_loader.fileSource(sourceName, true);
                    sources.add(source);
                }
            }
            catch (FileNotFoundException e) {
                this.eq.enqueue(2, "Cannot find source file \"" + e.getMessage() + "\".");
                this.eq.flush();
                return false;
            }
            catch (IOException e) {
                this.eq.enqueue(2, e.getMessage());
                this.eq.flush();
                return false;
            }
            catch (InternalCompilerError e) {
                try {
                    this.eq.enqueue(1, e.message(), e.position());
                }
                catch (ErrorLimitError e2) {
                    // empty catch block
                }
                this.eq.flush();
                throw e;
            }
            catch (RuntimeException e) {
                this.eq.flush();
                throw e;
            }
        }
        catch (ErrorLimitError e) {
            this.eq.flush();
            return false;
        }
        return this.compile(sources);
    }

    public boolean compile(Collection<Source> sources) {
        boolean okay = false;
        try {
            try {
                Scheduler scheduler = this.sourceExtension().scheduler();
                ArrayList<Job> jobs = new ArrayList<Job>();
                for (Source source : sources) {
                    Job job = scheduler.addJob(source);
                    jobs.add(job);
                }
                scheduler.setCommandLineJobs(jobs);
                for (Job job : jobs) {
                    scheduler.addDependenciesForJob(job, true);
                }
                okay = scheduler.runToCompletion();
            }
            catch (InternalCompilerError e) {
                try {
                    this.eq.enqueue(1, e.message() != null ? e.message() : "InternalCompilerError", e.position());
                }
                catch (ErrorLimitError e2) {
                    // empty catch block
                }
                this.eq.flush();
                throw e;
            }
            catch (StackOverflowError e) {
                this.eq.flush();
                throw e;
            }
            catch (RuntimeException e) {
                this.eq.flush();
                throw e;
            }
        }
        catch (ErrorLimitError e) {
            // empty catch block
        }
        this.eq.flush();
        for (ExtensionInfo ext : this.allExtensions) {
            ext.getStats().report();
        }
        return okay;
    }

    public ClassFileLoader loader() {
        return this.loader;
    }

    public boolean useFullyQualifiedNames() {
        return this.extensionInfo.getOptions().fully_qualified_names;
    }

    public void addExtension(ExtensionInfo ext) {
        this.allExtensions.add(ext);
    }

    public List allExtensions() {
        return this.allExtensions;
    }

    public ExtensionInfo sourceExtension() {
        return this.extensionInfo;
    }

    public int outputWidth() {
        return this.extensionInfo.getOptions().output_width;
    }

    public boolean serializeClassInfo() {
        return this.extensionInfo.getOptions().serialize_type_info;
    }

    public ErrorQueue errorQueue() {
        return this.eq;
    }

    public static CodeWriter createCodeWriter(OutputStream w) {
        return Compiler.createCodeWriter(w, Globals.Options().output_width);
    }

    public static CodeWriter createCodeWriter(OutputStream w, int width) {
        if (Globals.Options().use_simple_code_writer) {
            return new SimpleCodeWriter(w, width);
        }
        return new OptimalCodeWriter(w, width);
    }

    public static CodeWriter createCodeWriter(Writer w) {
        return Compiler.createCodeWriter(w, Globals.Options().output_width);
    }

    public static CodeWriter createCodeWriter(Writer w, int width) {
        if (Globals.Options().use_simple_code_writer) {
            return new SimpleCodeWriter(w, width);
        }
        return new OptimalCodeWriter(w, width);
    }

    static {
        try {
            ClassLoader loader = Compiler.class.getClassLoader();
            loader.loadClass("polyglot.util.StdErrorQueue");
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e.getMessage());
        }
    }
}

