/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import polyglot.frontend.Resource;

public class FileResource
implements Resource {
    private final File source;
    private String cachedCanonicalPath = null;

    public FileResource(File source) {
        this.source = source;
    }

    public int hashCode() {
        return this.canonicalPath().hashCode();
    }

    private String canonicalPath() {
        if (this.cachedCanonicalPath == null) {
            try {
                this.cachedCanonicalPath = this.source.getCanonicalPath();
            }
            catch (IOException e) {
                this.cachedCanonicalPath = this.source.getAbsolutePath();
            }
        }
        return this.cachedCanonicalPath;
    }

    public boolean equals(Object o) {
        if (o instanceof FileResource) {
            FileResource r = (FileResource)o;
            return this.canonicalPath().equals(r.canonicalPath());
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        FileInputStream in = new FileInputStream(this.source);
        return in;
    }

    public File file() {
        return this.source;
    }

    public String name() {
        return this.source.getName();
    }

    public String toString() {
        return this.source.getPath();
    }
}

