/*
 * Decompiled with CFR 0.152.
 */
package polyglot.main;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.util.SimpleErrorQueue;

public class Report {
    public static final Collection topics = new HashSet();
    protected static final Stack should_report = new Stack();
    protected static final Map reportTopics = new HashMap();
    protected static ErrorQueue eq;
    protected static boolean noReporting;
    public static final String cfg = "cfg";
    public static final String context = "context";
    public static final String dataflow = "dataflow";
    public static final String errors = "errors";
    public static final String frontend = "frontend";
    public static final String imports = "imports";
    public static final String loader = "loader";
    public static final String resolver = "resolver";
    public static final String serialize = "serialize";
    public static final String time = "time";
    public static final String types = "types";
    public static final String visit = "visit";
    public static final String verbose = "verbose";
    public static final String debug = "debug";

    public static boolean should_report(String topic, int level) {
        if (noReporting) {
            return false;
        }
        return Report.should_report(Collections.singletonList(topic), level);
    }

    public static boolean should_report(String[] topics, int level) {
        if (noReporting) {
            return false;
        }
        return Report.should_report(Arrays.asList(topics), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start_reporting(String topic) {
        Stack stack = should_report;
        synchronized (stack) {
            should_report.push(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop_reporting(String topic) {
        Stack stack = should_report;
        synchronized (stack) {
            should_report.remove(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean should_report(Collection topics, int level) {
        if (noReporting) {
            return false;
        }
        Collection collection = should_report;
        synchronized (collection) {
            for (String topic : should_report) {
                if (Report.level(topic) < level) continue;
                return true;
            }
        }
        if (topics != null) {
            collection = topics;
            synchronized (collection) {
                for (String topic : topics) {
                    if (Report.level(topic) < level) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTopic(String topic, int level) {
        Map map = reportTopics;
        synchronized (map) {
            Integer i = (Integer)reportTopics.get(topic);
            if (i == null || i < level) {
                reportTopics.put(topic, new Integer(level));
            }
        }
        noReporting = false;
    }

    public static ErrorQueue getQueue() {
        if (eq == null) {
            eq = new SimpleErrorQueue();
        }
        return eq;
    }

    public static void setQueue(ErrorQueue eq) {
        Report.eq = eq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int level(String name) {
        Map map = reportTopics;
        synchronized (map) {
            Object i = reportTopics.get(name);
            if (i == null) {
                return 0;
            }
            return (Integer)i;
        }
    }

    public static void report(int level, String message) {
        Report.report(level, message, null);
    }

    public static void report(int level, String message, Position pos) {
        StringBuffer buf = new StringBuffer(message.length() + level);
        for (int j = 1; j < level; ++j) {
            buf.append(" ");
        }
        buf.append(message);
        Report.getQueue().enqueue(7, buf.toString(), pos);
    }

    static {
        noReporting = true;
        topics.add(cfg);
        topics.add(context);
        topics.add(dataflow);
        topics.add(errors);
        topics.add(frontend);
        topics.add(imports);
        topics.add(loader);
        topics.add(resolver);
        topics.add(serialize);
        topics.add(time);
        topics.add(types);
        topics.add(visit);
        topics.add(verbose);
        topics.add(debug);
        should_report.push(verbose);
    }
}

