/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.frontend.Job;
import polyglot.frontend.Source;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.Def_c;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.MethodDef;
import polyglot.types.Name;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDef_c
extends Def_c
implements ClassDef {
    protected transient Source fromSource;
    protected Ref<? extends Type> superType;
    protected List<Ref<? extends Type>> interfaces;
    protected List<MethodDef> methods;
    protected List<FieldDef> fields;
    protected List<ConstructorDef> constructors;
    protected Ref<? extends Package> package_;
    protected Flags flags;
    protected ClassDef.Kind kind;
    protected Name name;
    protected Ref<ClassDef> outer;
    protected List<Ref<? extends ClassType>> memberClasses;
    protected transient ClassType asType;
    protected boolean inStaticContext = false;
    protected boolean needSerialization = true;
    protected SourceKind sourceKind;
    Job job;

    @Override
    public ClassType asType() {
        if (this.asType == null) {
            this.asType = this.ts.createClassType(this.position(), Types.ref(this));
        }
        return this.asType;
    }

    @Override
    public boolean isMember() {
        return this.kind == MEMBER;
    }

    @Override
    public boolean isTopLevel() {
        return this.kind == TOP_LEVEL;
    }

    @Override
    public boolean isLocal() {
        return this.kind == LOCAL;
    }

    @Override
    public boolean isAnonymous() {
        return this.kind == ANONYMOUS;
    }

    @Override
    public boolean isNested() {
        return !this.isTopLevel();
    }

    @Override
    public boolean isInnerClass() {
        return !this.flags().isInterface() && this.isNested() && !this.flags().isStatic() && !this.inStaticContext();
    }

    protected ClassDef_c() {
    }

    public ClassDef_c(TypeSystem ts, Source fromSource) {
        super(ts);
        this.fromSource = fromSource;
        this.interfaces = new ArrayList<Ref<? extends Type>>();
        this.methods = new ArrayList<MethodDef>();
        this.fields = new ArrayList<FieldDef>();
        this.constructors = new ArrayList<ConstructorDef>();
        this.memberClasses = new ArrayList<Ref<? extends ClassType>>();
        this.sourceKind = fromSource != null ? SourceKind.SOURCE : SourceKind.UNKNOWN;
    }

    @Override
    public Source sourceFile() {
        return this.fromSource;
    }

    @Override
    public boolean fromSourceFile() {
        return this.sourceKind == SourceKind.SOURCE;
    }

    @Override
    public void setFromSourceFile() {
        this.sourceKind = SourceKind.SOURCE;
    }

    @Override
    public boolean fromEncodedClassFile() {
        return this.sourceKind == SourceKind.ENCODED;
    }

    @Override
    public void setFromEncodedClassFile() {
        this.sourceKind = SourceKind.ENCODED;
    }

    @Override
    public boolean fromJavaClassFile() {
        return this.sourceKind == SourceKind.JAVA;
    }

    @Override
    public void setFromJavaClassFile() {
        this.sourceKind = SourceKind.JAVA;
    }

    @Override
    public Job job() {
        return this.job;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    @Override
    public ClassDef.Kind kind() {
        return this.kind;
    }

    @Override
    public void inStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    @Override
    public boolean inStaticContext() {
        return this.inStaticContext;
    }

    @Override
    public Ref<? extends ClassDef> outer() {
        if (this.kind() == TOP_LEVEL) {
            return null;
        }
        if (this.outer == null) {
            throw new InternalCompilerError("Nested class " + this + " must have outer classes.");
        }
        return this.outer;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public void setContainer(Ref<? extends StructType> container) {
        throw new InternalCompilerError("Call outer(container.def()) instead.");
    }

    @Override
    public Ref<? extends Type> superType() {
        return this.superType;
    }

    @Override
    public Ref<? extends Package> package_() {
        return this.package_;
    }

    @Override
    public Flags flags() {
        if (this.kind() == ANONYMOUS) {
            return Flags.NONE;
        }
        return this.flags;
    }

    @Override
    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void flags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void kind(ClassDef.Kind kind) {
        this.kind = kind;
    }

    @Override
    public void outer(Ref<ClassDef> outer) {
        if (outer != null && this.kind() == TOP_LEVEL) {
            throw new InternalCompilerError("Top-level classes cannot have outer classes.");
        }
        this.outer = outer;
    }

    @Override
    public Ref<? extends StructType> container() {
        return Types.ref(this.ts.createClassType(this.position(), this.outer));
    }

    @Override
    public void name(Name name) {
        if (this.kind() == ANONYMOUS) {
            throw new InternalCompilerError("Anonymous classes cannot have names.");
        }
        this.name = name;
    }

    @Override
    public void position(Position pos) {
        this.position = pos;
    }

    @Override
    public void setPackage(Ref<? extends Package> p) {
        this.package_ = p;
    }

    @Override
    public void superType(Ref<? extends Type> t) {
        this.superType = t;
    }

    @Override
    public void addInterface(Ref<? extends Type> t) {
        this.interfaces.add(t);
    }

    @Override
    public void addMethod(MethodDef mi) {
        this.methods.add(mi);
    }

    @Override
    public void addConstructor(ConstructorDef ci) {
        this.constructors.add(ci);
    }

    @Override
    public void addField(FieldDef fi) {
        this.fields.add(fi);
    }

    @Override
    public void addMemberClass(Ref<? extends ClassType> t) {
        this.memberClasses.add(t);
    }

    @Override
    public void setConstructors(List<? extends ConstructorDef> l) {
        this.constructors = new ArrayList<ConstructorDef>(l);
    }

    @Override
    public void setFields(List<? extends FieldDef> l) {
        this.fields = new ArrayList<FieldDef>(l);
    }

    @Override
    public void setInterfaces(List<Ref<? extends Type>> l) {
        this.interfaces = new ArrayList<Ref<? extends Type>>(l);
    }

    @Override
    public void setMemberClasses(List<Ref<? extends ClassType>> l) {
        this.memberClasses = new ArrayList<Ref<? extends ClassType>>(l);
    }

    @Override
    public void setMethods(List<? extends MethodDef> l) {
        this.methods = new ArrayList<MethodDef>(l);
    }

    @Override
    public List<ConstructorDef> constructors() {
        return Collections.unmodifiableList(this.constructors);
    }

    @Override
    public List<Ref<? extends ClassType>> memberClasses() {
        return Collections.unmodifiableList(this.memberClasses);
    }

    @Override
    public List<MethodDef> methods() {
        return Collections.unmodifiableList(this.methods);
    }

    @Override
    public List<FieldDef> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public List<Ref<? extends Type>> interfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public String toString() {
        Name name = this.name();
        if (this.kind() == null) {
            return "<unknown class " + name + ">";
        }
        if (this.kind() == ANONYMOUS) {
            if (this.interfaces != null && !this.interfaces.isEmpty()) {
                return "<anonymous subtype of " + this.interfaces.get(0) + ">";
            }
            if (this.superType != null) {
                return "<anonymous subclass of " + this.superType + ">";
            }
        }
        if (this.kind() == TOP_LEVEL) {
            Package p = Types.get(this.package_());
            return (p != null ? p.toString() + "." : "") + name;
        }
        if (this.kind() == MEMBER) {
            ClassDef outer = Types.get(this.outer());
            return (outer != null ? outer.toString() + "." : "") + name;
        }
        return name.toString();
    }

    public void needSerialization(boolean b) {
        this.needSerialization = b;
    }

    public boolean needSerialization() {
        return this.needSerialization;
    }

    @Override
    public QName fullName() {
        Name name = this.name();
        if (this.kind() == TOP_LEVEL) {
            Package p = Types.get(this.package_());
            return QName.make(p != null ? p.fullName() : null, name);
        }
        if (this.kind() == MEMBER) {
            ClassDef outer = Types.get(this.outer());
            return QName.make(outer != null ? outer.fullName() : null, name);
        }
        if (this.kind() == LOCAL) {
            return QName.make(null, name);
        }
        if (this.kind() == ANONYMOUS) {
            return QName.make(null, Name.make("<anonymous class>"));
        }
        return QName.make(null, Name.make("<unknown class>"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SourceKind {
        SOURCE,
        JAVA,
        ENCODED,
        UNKNOWN;

    }
}

