/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.Importable;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.types.Types;
import polyglot.util.CollectionUtil;

public class SystemResolver
extends CachingResolver
implements TopLevelResolver {
    protected Map<QName, Boolean> packageCache;
    protected ExtensionInfo extInfo;
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver", "sysresolver");

    public SystemResolver(TopLevelResolver inner, ExtensionInfo extInfo) {
        super(inner);
        this.extInfo = extInfo;
        this.packageCache = new HashMap<QName, Boolean>();
    }

    public Object copy() {
        SystemResolver r = (SystemResolver)super.copy();
        r.packageCache = new HashMap<QName, Boolean>(this.packageCache);
        return r;
    }

    public void installInAll(QName name, Named n) {
        this.install(name, n);
    }

    public boolean installedInAll(QName name, Named q) {
        return this.check(name) == q;
    }

    protected boolean packageExistsInCache(QName name) {
        for (Named o : this.cachedObjects()) {
            Importable im;
            if (!(o instanceof Importable) || (im = (Importable)o).package_() == null || im.package_().fullName() == null || !im.package_().fullName().equals(name) && !im.package_().fullName().startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public boolean packageExists(QName name) {
        Boolean b = this.packageCache.get(name);
        if (b != null) {
            return b;
        }
        QName prefix = name.qualifier();
        if (prefix != null && this.packageCache.get(prefix) == Boolean.FALSE) {
            this.packageCache.put(name, Boolean.FALSE);
            return false;
        }
        boolean exists = this.packageExistsInCache(name);
        if (!exists) {
            exists = this.inner.packageExists(name);
        }
        if (exists) {
            this.packageCache.put(name, Boolean.TRUE);
            while (prefix != null) {
                this.packageCache.put(prefix, Boolean.TRUE);
                prefix = prefix.qualifier();
            }
        } else {
            this.packageCache.put(name, Boolean.FALSE);
        }
        return exists;
    }

    protected void cachePackage(Package p) {
        if (p != null) {
            this.packageCache.put(QName.make(p.fullName()), Boolean.TRUE);
            Package prefix = Types.get(p.prefix());
            this.cachePackage(prefix);
        }
    }

    public Type checkType(QName name) {
        return (Type)((Object)this.check(name));
    }

    public Named find(QName name) throws SemanticException {
        Named n = super.find(name);
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Returning from SR.find(" + name + "): " + n);
        }
        return n;
    }

    public void install(QName name, Named q) {
        if (Report.should_report(TOPICS, 2) && this.check(name) == null) {
            Report.report(2, "SR installing " + name + "->" + q);
        }
        super.install(name, q);
    }

    public void addNamed(QName name, Named q) throws SemanticException {
        super.addNamed(name, q);
        if (q instanceof ClassType) {
            ClassType ct = (ClassType)q;
            QName containerName = name.qualifier();
            if (containerName != null) {
                if (ct.isTopLevel()) {
                    Package p = ((ClassType)q).package_();
                    this.cachePackage(p);
                    if (p != null && containerName.equals(p.fullName())) {
                        this.addNamed(containerName, p);
                    }
                } else if (ct.isMember() && name.equals(ct.fullName())) {
                    this.addNamed(containerName, ct.outer());
                }
            }
        } else if (q instanceof Package) {
            Package p = (Package)q;
            this.cachePackage(p);
            QName containerName = name.qualifier();
            Package prefix = Types.get(p.prefix());
            if (prefix != null && containerName.equals(prefix.fullName())) {
                this.addNamed(containerName, prefix);
            }
        }
        if (q instanceof Type && this.packageExists(name)) {
            throw new SemanticException("Type \"" + name + "\" clashes with package of the same name.", q.position());
        }
    }
}

