/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Resource;
import polyglot.main.Report;
import polyglot.types.reflect.ClassFile;

public class ClassFileLoader {
    protected ExtensionInfo extensionInfo;
    protected static Collection verbose = new HashSet();

    public ClassFileLoader(ExtensionInfo ext) {
        this.extensionInfo = ext;
    }

    public ClassFile loadClass(Resource r) {
        ClassFile c;
        if (r == null) {
            return null;
        }
        try {
            InputStream in = r.getInputStream();
            c = this.loadFromStream(r.file(), in, r.name());
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return c;
    }

    ClassFile loadFromStream(File source, InputStream in, String name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int n = 0;
        do {
            if ((n = in.read(buf)) < 0) continue;
            out.write(buf, 0, n);
        } while (n >= 0);
        byte[] bytecode = out.toByteArray();
        try {
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "defining class " + name);
            }
            return this.extensionInfo.createClassFile(source, bytecode);
        }
        catch (ClassFormatError e) {
            throw new IOException(e.getMessage());
        }
    }

    static {
        verbose.add("loader");
    }
}

