/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;

public class Method {
    protected ClassFile clazz;
    protected DataInputStream in;
    protected int modifiers;
    protected int name;
    protected int type;
    protected Attribute[] attrs;
    protected Exceptions exceptions;
    protected boolean synthetic;

    public Method(DataInputStream in, ClassFile clazz) {
        this.clazz = clazz;
        this.in = in;
    }

    public void initialize() throws IOException {
        this.modifiers = this.in.readUnsignedShort();
        this.name = this.in.readUnsignedShort();
        this.type = this.in.readUnsignedShort();
        int numAttributes = this.in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            long n;
            int nameIndex = this.in.readUnsignedShort();
            int length = this.in.readInt();
            Constant name = this.clazz.getConstants()[nameIndex];
            if (name != null) {
                if ("Exceptions".equals(name.value())) {
                    this.exceptions = new Exceptions(this.clazz, this.in, nameIndex, length);
                    this.attrs[i] = this.exceptions;
                }
                if ("Synthetic".equals(name.value())) {
                    this.synthetic = true;
                }
            }
            if (this.attrs[i] != null || (n = this.in.skip(length)) == (long)length) continue;
            throw new EOFException();
        }
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public Attribute[] getAttrs() {
        return this.attrs;
    }

    public ClassFile getClazz() {
        return this.clazz;
    }

    public Exceptions getExceptions() {
        return this.exceptions;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String name() {
        return (String)this.clazz.getConstants()[this.name].value();
    }
}

