/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTransformingList<S, T>
extends TransformingList<S, T> {
    protected ArrayList<T> cache;

    public CachingTransformingList(Collection<S> underlying, Transformation<S, T> trans) {
        this((List<S>)new ArrayList<S>(underlying), trans);
    }

    public CachingTransformingList(List<S> underlying, Transformation<S, T> trans) {
        super(underlying, trans);
        this.cache = new ArrayList<Object>(Collections.nCopies(underlying.size(), null));
    }

    @Override
    public T get(int index) {
        T o = this.cache.get(index);
        if (o == null) {
            o = this.trans.transform(this.underlying.get(index));
            this.cache.set(index, o);
        }
        return o;
    }
}

