/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.util.Predicate2;
import polyglot.util.Transformation;
import polyglot.util.TransformingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static List<String> dummyStringList(int length) {
        if (length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (length == 1) {
            return Collections.singletonList("a1");
        }
        ArrayList<String> list = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            list.add("a" + (i + 1));
        }
        return list;
    }

    public static <T> List<T> add(List<T> l, T o) {
        l.add(o);
        return l;
    }

    public static <T> boolean allElementwise(Collection<? extends T> a, Collection<? extends T> b, Predicate2<T> predicate) {
        if (a == b) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        Iterator<T> i = a.iterator();
        Iterator<T> j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            T p;
            T o = i.next();
            if (predicate.isTrue(o, p = j.next())) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    public static <T> boolean allEqual(Collection<? extends T> a, Collection<? extends T> b) {
        if (a == b) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        Iterator<T> i = a.iterator();
        Iterator<T> j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            T p;
            T o = i.next();
            if (o == (p = j.next())) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    public static <T> List<T> append(Collection<? extends T> l1, Collection<? extends T> l2) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(l1);
        l.addAll(l2);
        return l;
    }

    public static <T> List<T> list() {
        return Collections.emptyList();
    }

    public static <T> List<T> list(T o) {
        return Collections.singletonList(o);
    }

    public static <T> List<T> list(T o1, T o2, T ... o3s) {
        ArrayList<T> l = new ArrayList<T>(2 + o3s.length);
        l.add(o1);
        l.add(o2);
        for (T o3 : o3s) {
            l.add(o3);
        }
        return l;
    }

    public static <T> T firstOrElse(Collection<? extends T> l, T alt) {
        Iterator<T> i = l.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return alt;
    }

    public static <T> Iterator<Object[]> pairs(Collection<T> l) {
        if (l.size() == 0) {
            return Collections.emptyList().iterator();
        }
        ArrayList<Object[]> x = new ArrayList<Object[]>(l.size() - 1);
        Object prev = null;
        for (T curr : l) {
            if (prev != null) {
                x.add(new Object[]{prev, curr});
            }
            prev = curr;
        }
        return x.iterator();
    }

    public static <S, T> List<T> map(List<S> l, Transformation<S, T> t) {
        ArrayList m = new ArrayList(l.size());
        TransformingIterator<S, T> i = new TransformingIterator<S, T>(l.iterator(), t);
        while (i.hasNext()) {
            m.add(i.next());
        }
        return m;
    }

    public static <T> List<T> nonNullList(List<T> l) {
        if (l != null) {
            return l;
        }
        return Collections.emptyList();
    }

    public static String listToString(List<?> l) {
        StringBuffer sb = new StringBuffer();
        Iterator<?> i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o == null) {
                sb.append("null");
            } else {
                sb.append(o.toString());
            }
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

