/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcatenatedIterator<T>
implements Iterator<T> {
    protected T next_item;
    protected Iterator[] backing_iterators;
    protected int index;

    public ConcatenatedIterator(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        this(new Iterator[]{iter1, iter2});
    }

    public ConcatenatedIterator(Iterator[] iters) {
        this.backing_iterators = (Iterator[])iters.clone();
        this.findNextItem();
    }

    public ConcatenatedIterator(Collection<Iterator<? extends T>> iters) {
        this.backing_iterators = iters.toArray(new Iterator[0]);
        this.findNextItem();
    }

    @Override
    public T next() {
        T res = this.next_item;
        if (res == null) {
            throw new NoSuchElementException();
        }
        this.findNextItem();
        return res;
    }

    @Override
    public boolean hasNext() {
        return this.next_item != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ConcatenatedIterator.remove");
    }

    private void findNextItem() {
        while (this.index < this.backing_iterators.length) {
            Iterator it = this.backing_iterators[this.index];
            if (it.hasNext()) {
                this.next_item = it.next();
                return;
            }
            ++this.index;
        }
        this.next_item = null;
    }
}

