/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import polyglot.types.Context;
import polyglot.types.Type;
import polyglot.types.TypeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtypeSet
implements Set<Type> {
    protected List<Type> v;
    protected TypeSystem ts;
    protected Type topType;

    public SubtypeSet(TypeSystem ts) {
        this(ts.Object());
    }

    public SubtypeSet(Type top) {
        this.v = new ArrayList<Type>();
        this.ts = top.typeSystem();
        this.topType = top;
    }

    public SubtypeSet(SubtypeSet s) {
        this.v = new ArrayList<Type>(s.v);
        this.ts = s.ts;
        this.topType = s.topType;
    }

    public SubtypeSet(TypeSystem ts, Collection<Type> c) {
        this(ts);
        this.addAll((Collection<? extends Type>)c);
    }

    public SubtypeSet(Type top, Collection<Type> c) {
        this(top);
        this.addAll((Collection<? extends Type>)c);
    }

    @Override
    public boolean add(Type o) {
        if (o == null) {
            return false;
        }
        Type type = o;
        Context context = this.ts.emptyContext();
        if (this.ts.isSubtype(type, this.topType, context)) {
            boolean haveToAdd = true;
            Iterator<Type> i = this.v.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                if (!this.ts.typeEquals(t, type, context) && this.ts.isSubtype(t, type, context)) {
                    i.remove();
                }
                if (!this.ts.isSubtype(type, t, context)) continue;
                haveToAdd = false;
                break;
            }
            if (haveToAdd) {
                this.v.add(type);
            }
            return haveToAdd;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Type> c) {
        if (c == null) {
            return false;
        }
        boolean changed = false;
        for (Type type : c) {
            changed |= this.add(type);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.v.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Type) {
            Type type = (Type)o;
            Context context = this.ts.emptyContext();
            for (Type t : this.v) {
                if (!this.ts.isSubtype(type, t, context)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsSubtype(Type type) {
        Context context = this.ts.emptyContext();
        for (Type t : this.v) {
            if (!this.ts.isSubtype(type, t, context) && !this.ts.isSubtype(t, type, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.v.isEmpty();
    }

    @Override
    public Iterator<Type> iterator() {
        return this.v.iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Type)) {
            return false;
        }
        Type type = (Type)o;
        Context context = this.ts.emptyContext();
        boolean removed = false;
        Iterator<Type> i = this.v.iterator();
        while (i.hasNext()) {
            Type t = i.next();
            if (!this.ts.isSubtype(t, type, context)) continue;
            removed = true;
            i.remove();
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int size() {
        return this.v.size();
    }

    @Override
    public Object[] toArray() {
        return this.v.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.v.toArray(a);
    }

    public String toString() {
        return this.v.toString();
    }
}

