/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.main.Report;
import polyglot.types.TypeSystem;
import polyglot.util.Internable;

public class TypeInputStream
extends ObjectInputStream {
    protected TypeSystem ts;
    protected Map cache;
    protected boolean failed;
    protected boolean enableReplace;
    protected Set placeHoldersUsed;
    private static final Object UNRESOLVED = new Object();

    public TypeInputStream(InputStream in, TypeSystem ts, Map cache) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.ts = ts;
        this.cache = cache;
        this.failed = false;
        this.enableReplace = true;
        this.placeHoldersUsed = new HashSet();
    }

    public Set placeHoldersUsed() {
        return this.placeHoldersUsed;
    }

    public boolean deserializationFailed() {
        return this.failed;
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public void enableReplace(boolean f) {
        this.enableReplace = f;
    }

    protected Object resolveObject(Object o) {
        if (!this.enableReplace) {
            return o;
        }
        String s = "";
        if (Report.should_report("serialize", 2)) {
            try {
                s = o.toString();
            }
            catch (NullPointerException e) {
                s = "<NullPointerException thrown>";
            }
        }
        if (!this.enableReplace) {
            return o;
        }
        if (o instanceof Internable) {
            if (Report.should_report("serialize", 2)) {
                Report.report(2, "- Interning " + s + " : " + o.getClass());
            }
            return ((Internable)o).intern();
        }
        if (o instanceof Goal) {
            return ((Goal)o).intern(Globals.Scheduler());
        }
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "- " + s + " : " + o.getClass());
        }
        return o;
    }
}

