/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import polyglot.util.InternalCompilerError;
import polyglot.util.TypedListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedList<T>
implements List<T>,
Serializable,
Cloneable {
    static final long serialVersionUID = -1390984392613203018L;
    private Class<? super T> allowed_type;
    private boolean immutable;
    private List<T> backing_list;

    public static <T> TypedList<T> copy(List<T> list, Class<? super T> c, boolean immutable) {
        if (list == null) {
            return null;
        }
        return new TypedList<T>(new ArrayList<T>(list), c, immutable);
    }

    public static <T> TypedList<T> copyAndCheck(List<T> list, Class<? super T> c, boolean immutable) {
        if (c != null) {
            TypedList.check(list, c);
        }
        return TypedList.copy(list, c, immutable);
    }

    public static <T> void check(List<T> list, Class<? super T> c) {
        if (list == null) {
            return;
        }
        for (T o : list) {
            if (o == null || c.isAssignableFrom(o.getClass())) continue;
            throw new UnsupportedOperationException("Tried to add a " + o.getClass().getName() + " to a list of type " + c.getName());
        }
    }

    public TypedList(List<T> list, Class<? super T> c, boolean immutable) {
        this.immutable = immutable;
        this.allowed_type = c;
        this.backing_list = list;
    }

    public Class<? super T> getAllowedType() {
        return this.allowed_type;
    }

    public TypedList<T> copy() {
        return (TypedList)this.clone();
    }

    public Object clone() {
        try {
            TypedList l = (TypedList)super.clone();
            l.backing_list = new ArrayList<T>(this.backing_list);
            return l;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone weirdness.");
        }
    }

    @Override
    public void add(int idx, T o) {
        this.tryIns(o);
        this.backing_list.add(idx, o);
    }

    @Override
    public boolean add(T o) {
        this.tryIns(o);
        return this.backing_list.add(o);
    }

    @Override
    public boolean addAll(int idx, Collection<? extends T> coll) {
        this.tryIns(coll);
        return this.backing_list.addAll(idx, coll);
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        this.tryIns(coll);
        return this.backing_list.addAll(coll);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new TypedListIterator<T>(this.backing_list.listIterator(), this.allowed_type, this.immutable);
    }

    @Override
    public ListIterator<T> listIterator(int idx) {
        return new TypedListIterator<T>(this.backing_list.listIterator(idx), this.allowed_type, this.immutable);
    }

    @Override
    public T set(int idx, T o) {
        this.tryIns(o);
        return this.backing_list.set(idx, o);
    }

    @Override
    public List subList(int from, int to) {
        return new TypedList<T>(this.backing_list.subList(from, to), this.allowed_type, this.immutable);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.backing_list == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (((List)o).size() != this.backing_list.size()) {
            return false;
        }
        if (o instanceof TypedList) {
            return ((Object)this.backing_list).equals(((TypedList)o).backing_list);
        }
        return ((Object)this.backing_list).equals(o);
    }

    @Override
    public void clear() {
        this.tryMod();
        this.backing_list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing_list.contains(o);
    }

    @Override
    public boolean containsAll(Collection coll) {
        return this.backing_list.containsAll(coll);
    }

    @Override
    public T get(int idx) {
        return this.backing_list.get(idx);
    }

    @Override
    public int hashCode() {
        return ((Object)this.backing_list).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.backing_list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.backing_list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backing_list.lastIndexOf(o);
    }

    @Override
    public T remove(int idx) {
        this.tryMod();
        return this.backing_list.remove(idx);
    }

    @Override
    public boolean remove(Object o) {
        this.tryMod();
        return this.backing_list.remove(o);
    }

    @Override
    public boolean removeAll(Collection coll) {
        this.tryMod();
        return this.backing_list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection coll) {
        this.tryMod();
        return this.backing_list.retainAll(coll);
    }

    @Override
    public int size() {
        return this.backing_list.size();
    }

    @Override
    public Object[] toArray() {
        return this.backing_list.toArray();
    }

    @Override
    public <S> S[] toArray(S[] oa) {
        return this.backing_list.toArray(oa);
    }

    public String toString() {
        return this.backing_list.toString();
    }

    private final void tryIns(T o) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Add to an immutable TypedListIterator");
        }
        if (this.allowed_type != null && o != null && !this.allowed_type.isAssignableFrom(o.getClass())) {
            String why = "Tried to add a " + o.getClass().getName() + " to a list of type " + this.allowed_type.getName();
            throw new UnsupportedOperationException(why);
        }
    }

    private final void tryIns(Collection<? extends T> coll) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Add to an immutable TypedListIterator");
        }
        for (T o : coll) {
            this.tryIns(o);
        }
    }

    private final void tryMod() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Change to an immutable TypedListIterator");
        }
    }
}

