/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.FieldDecl;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.InitializerDef;
import polyglot.types.Name;
import polyglot.types.ParsedClassType_c;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.util.TypeEncoder;
import polyglot.visit.NodeVisitor;

public class ClassSerializer
extends NodeVisitor {
    private static final int MAX_ENCODED_TYPE_INFO_STRING_LENGTH = 8192;
    protected TypeEncoder te;
    protected ErrorQueue eq;
    protected Date date;
    protected TypeSystem ts;
    protected NodeFactory nf;
    protected Version ver;

    public ClassSerializer(TypeSystem ts, NodeFactory nf, Date date, ErrorQueue eq, Version ver) {
        this.ts = ts;
        this.nf = nf;
        this.te = new TypeEncoder(ts);
        this.eq = eq;
        this.date = date;
        this.ver = ver;
    }

    public Node override(Node n) {
        if (n instanceof ClassMember && !(n instanceof ClassDecl)) {
            return n;
        }
        return null;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (!(n instanceof ClassDecl)) {
            return n;
        }
        ClassDecl cd = (ClassDecl)n;
        ClassBody body = cd.body();
        List l = this.createSerializationMembers(cd);
        for (ClassMember m : l) {
            body = body.addMember(m);
        }
        return cd.body(body);
    }

    public List createSerializationMembers(ClassDecl cd) {
        return this.createSerializationMembers(cd.classDef());
    }

    public List createSerializationMembers(ClassDef cd) {
        try {
            ArrayList<FieldDecl> newMembers = new ArrayList<FieldDecl>(3);
            ClassType ct = cd.asType();
            ct.memberClasses();
            ct.constructors();
            ct.methods();
            ct.fields();
            ct.interfaces();
            ct.superClass();
            if (!ct.isTopLevel() && !ct.isMember()) {
                return Collections.EMPTY_LIST;
            }
            String suffix = this.ver.name();
            if (ct.fieldNamed(Name.make("jlc$CompilerVersion$" + suffix)) != null || ct.fieldNamed(Name.make("jlc$SourceLastModified$" + suffix)) != null || ct.fieldNamed(Name.make("jlc$ClassType$" + suffix)) != null) {
                this.eq.enqueue(5, "Cannot serialize class information more than once.");
                return Collections.EMPTY_LIST;
            }
            Flags flags = Flags.PUBLIC.set(Flags.STATIC).set(Flags.FINAL);
            String version = this.ver.major() + "." + this.ver.minor() + "." + this.ver.patch_level();
            Position pos = Position.COMPILER_GENERATED;
            FieldDef fi = this.ts.fieldDef(pos, Types.ref(new ParsedClassType_c(cd)), flags, Types.ref(this.ts.String()), Name.make("jlc$CompilerVersion$" + suffix));
            fi.setConstantValue(version);
            InitializerDef ii = this.ts.initializerDef(pos, Types.ref(new ParsedClassType_c(cd)), Flags.STATIC);
            FieldDecl f = this.nf.FieldDecl(fi.position(), this.nf.FlagsNode(fi.position(), fi.flags()), this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.StringLit(pos, version).type(this.ts.String()));
            f = f.fieldDef(fi);
            f = f.initializerDef(ii);
            newMembers.add(f);
            long time = this.date.getTime();
            fi = this.ts.fieldDef(pos, Types.ref(new ParsedClassType_c(cd)), flags, Types.ref(this.ts.Long()), Name.make("jlc$SourceLastModified$" + suffix));
            fi.setConstantValue(new Long(time));
            ii = this.ts.initializerDef(pos, Types.ref(new ParsedClassType_c(cd)), Flags.STATIC);
            f = this.nf.FieldDecl(fi.position(), this.nf.FlagsNode(fi.position(), fi.flags()), this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.IntLit(pos, IntLit.LONG, time).type(this.ts.Long()));
            f = f.fieldDef(fi);
            f = f.initializerDef(ii);
            newMembers.add(f);
            String encodedTypeInfo = this.te.encode(ct);
            int etiStart = 0;
            int etiEnd = 0;
            int numberETIFields = 0;
            do {
                if ((etiEnd = encodedTypeInfo.length()) - etiStart > 8192) {
                    etiEnd = etiStart + 8192;
                }
                String additionalFieldSuffix = numberETIFields == 0 ? "" : "$" + numberETIFields;
                String encoded = encodedTypeInfo.substring(etiStart, etiEnd);
                fi = this.ts.fieldDef(pos, Types.ref(new ParsedClassType_c(cd)), flags, Types.ref(this.ts.String()), Name.make("jlc$ClassType$" + suffix + additionalFieldSuffix));
                fi.setConstantValue(encoded);
                ii = this.ts.initializerDef(pos, Types.ref(new ParsedClassType_c(cd)), Flags.STATIC);
                f = this.nf.FieldDecl(fi.position(), this.nf.FlagsNode(fi.position(), fi.flags()), this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.StringLit(pos, encoded).type(this.ts.String()));
                f = f.fieldDef(fi);
                f = f.initializerDef(ii);
                newMembers.add(f);
                ++numberETIFields;
                etiStart = etiEnd;
            } while (etiEnd != encodedTypeInfo.length());
            return newMembers;
        }
        catch (IOException e) {
            if (Report.should_report("serialize", 1)) {
                e.printStackTrace();
            }
            this.eq.enqueue(2, "Unable to serialize class information.");
            return Collections.EMPTY_LIST;
        }
    }
}

