/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.ForInit;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.LocalDef;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class CopyPropagator
extends DataFlow {
    public CopyPropagator(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, true);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        return new DataFlowItem();
    }

    public DataFlow.Item confluence(List inItems, Term node, boolean entry, FlowGraph graph) {
        DataFlowItem result = null;
        for (DataFlowItem inItem : inItems) {
            if (result == null) {
                result = new DataFlowItem(inItem);
                continue;
            }
            result.intersect(inItem);
        }
        return result;
    }

    private void killDecl(DataFlowItem dfi, Stmt stmt) {
        if (stmt instanceof LocalDecl) {
            dfi.kill(((LocalDecl)stmt).localDef());
        }
    }

    protected DataFlowItem flow(DataFlow.Item in, FlowGraph graph, Term t, boolean entry) {
        DataFlowItem result = new DataFlowItem((DataFlowItem)in);
        if (entry) {
            return result;
        }
        if (t instanceof LocalAssign) {
            LocalAssign n = (LocalAssign)t;
            Assign.Operator op = n.operator();
            Local left = n.local();
            Expr right = n.right();
            if (left instanceof Local) {
                LocalDef to = (LocalDef)left.localInstance().def();
                result.kill(to);
                if (right instanceof Local && op == Assign.ASSIGN) {
                    LocalDef from = (LocalDef)((Local)right).localInstance().def();
                    result.add(from, to);
                }
            }
        } else if (t instanceof Unary) {
            Unary n = (Unary)t;
            Unary.Operator op = n.operator();
            Expr expr = n.expr();
            if (expr instanceof Local && (op == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_DEC)) {
                result.kill((LocalDef)((Local)expr).localInstance().def());
            }
        } else if (t instanceof LocalDecl) {
            LocalDecl n = (LocalDecl)t;
            LocalDef to = n.localDef();
            result.kill(to);
            if (!n.flags().flags().isFinal() && n.init() instanceof Local) {
                LocalDef from = (LocalDef)((Local)n.init()).localInstance().def();
                result.add(from, to);
            }
        } else if (t instanceof Block) {
            Block n = (Block)t;
            Iterator<Stmt> it = n.statements().iterator();
            while (it.hasNext()) {
                this.killDecl(result, it.next());
            }
        } else if (t instanceof Loop) {
            if (t instanceof For) {
                For n = (For)t;
                Iterator<ForInit> it = n.inits().iterator();
                while (it.hasNext()) {
                    this.killDecl(result, it.next());
                }
            }
            this.killDecl(result, ((Loop)t).body());
        } else if (t instanceof Catch) {
            result.kill(((Catch)t).formal().localDef());
        } else if (t instanceof If) {
            If n = (If)t;
            this.killDecl(result, n.consequent());
            this.killDecl(result, n.alternative());
        }
        return result;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term t, boolean entry, Set succEdgeKeys) {
        return CopyPropagator.itemToMap(this.flow(in, graph, t, entry), succEdgeKeys);
    }

    public void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    public void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) throws SemanticException {
        throw new InternalCompilerError("CopyPropagator.check should never be called.");
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof Local) {
            FlowGraph g = this.currentFlowGraph();
            if (g == null) {
                return n;
            }
            Local l = (Local)n;
            Collection peers = g.peers(l, 0);
            if (peers == null || peers.isEmpty()) {
                return n;
            }
            ArrayList<DataFlow.Item> items = new ArrayList<DataFlow.Item>();
            for (FlowGraph.Peer p : peers) {
                if (p.inItem() == null) continue;
                items.add(p.inItem());
            }
            DataFlowItem in = (DataFlowItem)this.confluence(items, l, false, g);
            if (in == null) {
                return n;
            }
            LocalDef root = in.getRoot((LocalDef)l.localInstance().def());
            if (root == null) {
                return n;
            }
            return l.name(l.name().id(root.name())).localInstance(root.asInstance());
        }
        if (n instanceof Unary) {
            return old;
        }
        if (n instanceof LocalAssign) {
            LocalAssign oldAssign = (LocalAssign)old;
            LocalAssign newAssign = (LocalAssign)n;
            return newAssign.local(oldAssign.local());
        }
        return n;
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        private Map map;

        protected DataFlowItem() {
            this.map = new HashMap();
        }

        protected DataFlowItem(DataFlowItem dfi) {
            this.map = new HashMap(dfi.map.size());
            for (Map.Entry e : dfi.map.entrySet()) {
                LocalDef li = (LocalDef)e.getKey();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (ci.from == null) continue;
                this.add(ci.from.li, li);
            }
        }

        protected void add(LocalDef from, LocalDef to) {
            CopyInfo ciFrom;
            CopyInfo ciTo;
            boolean newTo;
            boolean bl = newTo = !this.map.containsKey(to);
            if (newTo) {
                ciTo = new CopyInfo(to);
                this.map.put(to, ciTo);
            } else {
                ciTo = (CopyInfo)this.map.get(to);
            }
            if (this.map.containsKey(from)) {
                ciFrom = (CopyInfo)this.map.get(from);
            } else {
                ciFrom = new CopyInfo(from);
                this.map.put(from, ciFrom);
                ciFrom.root = ciFrom;
            }
            if (ciTo.from != null) {
                throw new InternalCompilerError("Error while copying dataflow item during copy propagation.");
            }
            ciFrom.to.add(ciTo);
            ciTo.from = ciFrom;
            if (newTo) {
                ciTo.root = ciFrom.root;
            } else {
                ciTo.setRoot(ciFrom.root);
            }
        }

        protected void intersect(DataFlowItem dfi) {
            Map.Entry e;
            boolean modified = false;
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                LocalDef li = (LocalDef)e.getKey();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (!dfi.map.containsKey(li)) {
                    modified = true;
                    it.remove();
                    if (ci.from != null) {
                        ci.from.to.remove(ci);
                    }
                    for (CopyInfo toCI : ci.to) {
                        toCI.from = null;
                    }
                    continue;
                }
                if (ci.from == null) continue;
                CopyInfo otherCI = (CopyInfo)dfi.map.get(li);
                CopyInfo otherCIfrom = (CopyInfo)dfi.map.get(ci.from.li);
                if (otherCIfrom != null && otherCI.root == otherCIfrom.root) continue;
                modified = true;
                ci.from.to.remove(ci);
                ci.from = null;
            }
            if (!modified) {
                return;
            }
            it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (ci.from != null) continue;
                if (ci.to.isEmpty()) {
                    it.remove();
                    continue;
                }
                ci.setRoot(ci);
            }
        }

        public void kill(LocalDef var) {
            if (!this.map.containsKey(var)) {
                return;
            }
            CopyInfo ci = (CopyInfo)this.map.get(var);
            this.map.remove(var);
            if (ci.from != null) {
                ci.from.to.remove(ci);
            }
            for (CopyInfo toCI : ci.to) {
                toCI.from = ci.from;
                if (ci.from == null) {
                    toCI.setRoot(toCI);
                    continue;
                }
                ci.from.to.add(toCI);
            }
        }

        public LocalDef getRoot(LocalDef var) {
            if (!this.map.containsKey(var)) {
                return null;
            }
            return ((CopyInfo)this.map.get((Object)var)).root.li;
        }

        private void die() {
            throw new InternalCompilerError("Copy propagation dataflow item consistency error.");
        }

        private void consistencyCheck() {
            for (Map.Entry e : this.map.entrySet()) {
                LocalDef li = (LocalDef)e.getKey();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (li != ci.li) {
                    this.die();
                }
                if (!this.map.containsKey(ci.root.li)) {
                    this.die();
                }
                if (this.map.get(ci.root.li) != ci.root) {
                    this.die();
                }
                if (ci.from == null) {
                    if (ci.root != ci) {
                        this.die();
                    }
                } else {
                    if (!this.map.containsKey(ci.from.li)) {
                        this.die();
                    }
                    if (this.map.get(ci.from.li) != ci.from) {
                        this.die();
                    }
                    if (ci.from.root != ci.root) {
                        this.die();
                    }
                    if (!ci.from.to.contains(ci)) {
                        this.die();
                    }
                }
                for (CopyInfo toCI : ci.to) {
                    if (!this.map.containsKey(toCI.li)) {
                        this.die();
                    }
                    if (this.map.get(toCI.li) != toCI) {
                        this.die();
                    }
                    if (toCI.root != ci.root) {
                        this.die();
                    }
                    if (toCI.from == ci) continue;
                    this.die();
                }
            }
        }

        public int hashCode() {
            int result = 0;
            for (Map.Entry e : this.map.entrySet()) {
                result = 31 * result + e.getKey().hashCode();
                result = 31 * result + e.getValue().hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataFlowItem)) {
                return false;
            }
            DataFlowItem dfi = (DataFlowItem)o;
            return ((Object)this.map).equals(dfi.map);
        }

        public String toString() {
            String result = "";
            boolean first = true;
            for (CopyInfo ci : this.map.values()) {
                if (ci.from == null) continue;
                if (!first) {
                    result = result + ", ";
                }
                if (ci.root != ci.from) {
                    result = result + ci.root.li + " ->* ";
                }
                result = result + ci.from.li + " -> " + ci.li;
                first = false;
            }
            return "[" + result + "]";
        }

        protected static class CopyInfo {
            public final LocalDef li;
            public CopyInfo from;
            public Set to;
            public CopyInfo root;

            protected CopyInfo(LocalDef li) {
                if (li == null) {
                    throw new InternalCompilerError("Null local instance encountered during copy propagation.");
                }
                this.li = li;
                this.from = null;
                this.to = new HashSet();
                this.root = this;
            }

            protected void setRoot(CopyInfo root) {
                ArrayList<CopyInfo> worklist = new ArrayList<CopyInfo>();
                worklist.add(this);
                while (worklist.size() > 0) {
                    CopyInfo ci = (CopyInfo)worklist.remove(worklist.size() - 1);
                    worklist.addAll(ci.to);
                    ci.root = root;
                }
            }

            public boolean equals(Object o) {
                if (!(o instanceof CopyInfo)) {
                    return false;
                }
                CopyInfo ci = (CopyInfo)o;
                return this.li == ci.li && (this.from == null ? ci.from == null : ci.from != null && this.from.li == ci.from.li) && this.root.li == ci.root.li;
            }

            public int hashCode() {
                return this.li.hashCode() + 31 * (this.from == null ? 0 : this.from.li.hashCode() + 31 * this.root.li.hashCode());
            }
        }
    }
}

