/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Do;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.ast.While;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.LocalDef;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class DeadCodeEliminator
extends DataFlow {
    public DeadCodeEliminator(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, false, true);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        return new DataFlowItem();
    }

    public DataFlow.Item confluence(List inItems, Term node, boolean entry, FlowGraph graph) {
        DataFlowItem result = null;
        for (DataFlowItem inItem : inItems) {
            if (result == null) {
                result = new DataFlowItem(inItem);
                continue;
            }
            result.union(inItem);
        }
        return result;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term t, boolean entry, Set succEdgeKeys) {
        return DeadCodeEliminator.itemToMap(this.flow(in, graph, t, entry), succEdgeKeys);
    }

    protected DataFlowItem flow(DataFlow.Item in, FlowGraph graph, Term t, boolean entry) {
        DataFlowItem result = new DataFlowItem((DataFlowItem)in);
        if (entry) {
            return result;
        }
        Set[] du = null;
        if (t instanceof LocalDecl) {
            LocalDecl n = (LocalDecl)t;
            LocalDef to = n.localDef();
            result.removeDecl(to);
            du = this.getDefUse(n.init());
        } else if (t instanceof Stmt && !(t instanceof CompoundStmt)) {
            du = this.getDefUse((Stmt)t);
        } else if (t instanceof CompoundStmt) {
            if (t instanceof If) {
                du = this.getDefUse(((If)t).cond());
            } else if (t instanceof Switch) {
                du = this.getDefUse(((Switch)t).expr());
            } else if (t instanceof Do) {
                du = this.getDefUse(((Do)t).cond());
            } else if (t instanceof For) {
                du = this.getDefUse(((For)t).cond());
            } else if (t instanceof While) {
                du = this.getDefUse(((While)t).cond());
            }
        }
        if (du != null) {
            result.removeAll(du[0]);
            result.addAll(du[1]);
        }
        return result;
    }

    public void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    public void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) throws SemanticException {
        throw new InternalCompilerError("DeadCodeEliminator.check should never be called.");
    }

    private DataFlowItem getItem(Term n) {
        FlowGraph g = this.currentFlowGraph();
        if (g == null) {
            return null;
        }
        Collection peers = g.peers(n, 0);
        if (peers == null || peers.isEmpty()) {
            return null;
        }
        ArrayList<DataFlow.Item> items = new ArrayList<DataFlow.Item>();
        for (FlowGraph.Peer p : peers) {
            if (p.inItem() == null) continue;
            items.add(p.inItem());
        }
        return (DataFlowItem)this.confluence(items, n, false, g);
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)n;
            DataFlowItem in = this.getItem(ld);
            if (in == null || in.needDecl(ld.localDef())) {
                return n;
            }
            return this.getEffects(ld.init());
        }
        if (n instanceof Eval) {
            Local local;
            Eval eval = (Eval)n;
            Expr expr = eval.expr();
            Expr right = null;
            if (expr instanceof LocalAssign) {
                LocalAssign assign = (LocalAssign)expr;
                Local left = assign.local();
                right = assign.right();
                if (!(left instanceof Local)) {
                    return n;
                }
                local = left;
            } else {
                if (expr instanceof Assign) {
                    return n;
                }
                if (expr instanceof Unary) {
                    Unary unary = (Unary)expr;
                    if (!((expr = unary.expr()) instanceof Local)) {
                        return n;
                    }
                    local = (Local)expr;
                } else {
                    return n;
                }
            }
            DataFlowItem in = this.getItem(eval);
            if (in == null || in.needDef((LocalDef)local.localInstance().def())) {
                return n;
            }
            if (right != null) {
                return this.getEffects(right);
            }
            return this.nf.Empty(Position.COMPILER_GENERATED);
        }
        if (n instanceof Block) {
            Block b = (Block)n;
            ArrayList<Stmt> stmts = new ArrayList<Stmt>(b.statements());
            Iterator it = stmts.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Empty)) continue;
                it.remove();
            }
            return b.statements(stmts);
        }
        return n;
    }

    protected Set[] getDefUse(Node n) {
        HashSet def = new HashSet();
        HashSet use = new HashSet();
        if (n != null) {
            n.visit(this.createDefUseFinder(def, use));
        }
        return new Set[]{def, use};
    }

    protected NodeVisitor createDefUseFinder(Set def, Set use) {
        return new DefUseFinder(def, use);
    }

    protected Stmt getEffects(Expr expr) {
        Empty empty = this.nf.Empty(Position.COMPILER_GENERATED);
        if (expr == null) {
            return empty;
        }
        final LinkedList<Stmt> result = new LinkedList<Stmt>();
        final Position pos = Position.COMPILER_GENERATED;
        NodeVisitor v = new NodeVisitor(){

            public Node override(Node parent, Node n) {
                Unary.Operator op;
                if (n instanceof Assign || n instanceof ProcedureCall) {
                    return this.leave(parent, n, n, this);
                }
                if (n instanceof Unary && ((op = ((Unary)n).operator()) == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_INC)) {
                    return this.leave(parent, n, n, this);
                }
                return n;
            }

            public Node leave(Node old, Node n, NodeVisitor v) {
                Unary.Operator op;
                if (n instanceof Assign || n instanceof ProcedureCall) {
                    result.add(DeadCodeEliminator.this.nf.Eval(pos, (Expr)n));
                } else if (n instanceof Unary && ((op = ((Unary)n).operator()) == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_INC)) {
                    result.add(DeadCodeEliminator.this.nf.Eval(pos, (Expr)n));
                }
                return n;
            }
        };
        expr.visit(v);
        if (result.isEmpty()) {
            return empty;
        }
        if (result.size() == 1) {
            return (Stmt)result.get(0);
        }
        return this.nf.Block(Position.COMPILER_GENERATED, result);
    }

    protected static class DefUseFinder
    extends NodeVisitor {
        protected Set def;
        protected Set use;

        public DefUseFinder(Set def, Set use) {
            this.def = def;
            this.use = use;
        }

        public Node override(Node parent, Node n) {
            LocalAssign a;
            if (parent instanceof LocalAssign && n == (a = (LocalAssign)parent).local()) {
                return n;
            }
            return null;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            Local left;
            if (n instanceof Local) {
                this.use.add(((Local)n).localInstance().def());
            } else if (n instanceof LocalAssign && (left = ((LocalAssign)n).local()) instanceof Local) {
                this.def.add(left.localInstance().def());
            }
            return n;
        }
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        private Set liveVars;
        private Set liveDecls;

        protected DataFlowItem() {
            this.liveVars = new HashSet();
            this.liveDecls = new HashSet();
        }

        protected DataFlowItem(DataFlowItem dfi) {
            this.liveVars = new HashSet(dfi.liveVars);
            this.liveDecls = new HashSet(dfi.liveDecls);
        }

        public void add(LocalDef li) {
            this.liveVars.add(li);
            this.liveDecls.add(li);
        }

        public void addAll(Set lis) {
            this.liveVars.addAll(lis);
            this.liveDecls.addAll(lis);
        }

        public void remove(LocalDef li) {
            this.liveVars.remove(li);
        }

        public void removeAll(Set lis) {
            this.liveVars.removeAll(lis);
        }

        public void removeDecl(LocalDef li) {
            this.liveVars.remove(li);
            this.liveDecls.remove(li);
        }

        public void union(DataFlowItem dfi) {
            this.liveVars.addAll(dfi.liveVars);
            this.liveDecls.addAll(dfi.liveDecls);
        }

        protected boolean needDecl(LocalDef li) {
            return this.liveDecls.contains(li);
        }

        protected boolean needDef(LocalDef li) {
            return this.liveVars.contains(li);
        }

        public int hashCode() {
            int result = 0;
            Iterator it = this.liveVars.iterator();
            while (it.hasNext()) {
                result = 31 * result + it.next().hashCode();
            }
            it = this.liveDecls.iterator();
            while (it.hasNext()) {
                result = 31 * result + it.next().hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataFlowItem)) {
                return false;
            }
            DataFlowItem dfi = (DataFlowItem)o;
            return ((Object)this.liveVars).equals(dfi.liveVars) && ((Object)this.liveDecls).equals(dfi.liveDecls);
        }

        public String toString() {
            return "<vars=" + this.liveVars + " ; decls=" + this.liveDecls + ">";
        }
    }
}

