/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.SourceFile;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.LocalClassRemover;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClassRemover
extends ContextVisitor {
    public static final Name OUTER_FIELD_NAME = Name.make("out$");
    protected Map<ClassDef, FieldDef> outerFieldInstance = new HashMap<ClassDef, FieldDef>();

    public InnerClassRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    Expr getContainer(Position pos, Expr this_, ClassDef currentClass, ClassDef containerClass) {
        if (containerClass == currentClass) {
            return this_;
        }
        FieldDef fi = this.boxThis(currentClass, Types.get(currentClass.outer()));
        Field f = this.nf.Field(pos, this_, this.nf.Id(pos, OUTER_FIELD_NAME));
        f = f.fieldInstance(fi.asInstance());
        f = (Field)f.type(fi.asInstance().type());
        f = f.targetImplicit(false);
        return this.getContainer(pos, f, Types.get(currentClass.outer()), containerClass);
    }

    protected ContextVisitor localClassRemover() {
        LocalClassRemover lcv = new LocalClassRemover(this.job, this.ts, this.nf);
        return lcv;
    }

    @Override
    public Node override(Node parent, Node n) {
        if (n instanceof SourceFile) {
            ContextVisitor lcv = this.localClassRemover();
            lcv = (ContextVisitor)lcv.begin();
            lcv = lcv.context(this.context);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> output ----------------------");
                n.prettyPrint(System.out);
                System.out.println("<<< output ----------------------");
            }
            n = n.visit(lcv);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> locals removed ----------------------");
                n.prettyPrint(System.out);
                System.out.println("<<< locals removed ----------------------");
            }
            n = this.visitEdgeNoOverride(parent, n);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> inners removed ----------------------");
                n.prettyPrint(System.out);
                System.out.println("<<< inners removed ----------------------");
            }
            return n;
        }
        return null;
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        Expr f;
        Context context = this.context();
        Position pos = n.position();
        if (n instanceof Special) {
            Special s = (Special)n;
            if (s.qualifier() == null) {
                return s;
            }
            assert (s.qualifier().type().toClass() != null);
            if (s.qualifier().type().toClass().def() == context.currentClassDef()) {
                return s;
            }
            return this.getContainer(pos, this.nf.This(pos).type(context.currentClass()), context.currentClassDef(), (ClassDef)s.qualifier().type().toClass().def());
        }
        if (n instanceof Field && (f = (Field)n).isTargetImplicit() && !(f.target() instanceof Special)) {
            return f.targetImplicit(false);
        }
        if (n instanceof FieldAssign && (f = (FieldAssign)n).targetImplicit() && !(f.target() instanceof Special)) {
            return f.targetImplicit(false);
        }
        if (n instanceof Call && (f = (Call)n).isTargetImplicit() && !(f.target() instanceof Special)) {
            return f.targetImplicit(false);
        }
        if (n instanceof New) {
            New neu = (New)n;
            Expr q = neu.qualifier();
            if (q != null) {
                neu = neu.qualifier(null);
                ConstructorInstance ci = neu.constructorInstance();
                ArrayList<Type> args = new ArrayList<Type>();
                args.add(q.type());
                args.addAll(ci.formalTypes());
                ci = ci.formalTypes(args);
                neu = neu.constructorInstance(ci);
                args = new ArrayList();
                args.add((Type)((Object)q));
                args.addAll(neu.arguments());
                neu = (New)neu.arguments(args);
            }
            return neu;
        }
        if (n instanceof ConstructorCall) {
            ArrayList<Expr> args;
            boolean fixCI;
            ConstructorCall cc = (ConstructorCall)n;
            if (cc.kind() != ConstructorCall.SUPER) {
                return cc;
            }
            ConstructorInstance ci = cc.constructorInstance();
            ClassType ct = ci.container().toClass();
            if (cc.qualifier() == null) {
                return cc;
            }
            Expr q = cc.qualifier();
            boolean bl = fixCI = (cc = cc.qualifier(null)).arguments().size() + 1 != ci.formalTypes().size();
            if (fixCI) {
                args = new ArrayList<Expr>();
                args.add((Expr)((Object)q.type()));
                args.addAll(ci.formalTypes());
                ci = ci.formalTypes(args);
                cc = cc.constructorInstance(ci);
            }
            args = new ArrayList();
            args.add(q);
            args.addAll(cc.arguments());
            cc = (ConstructorCall)cc.arguments(args);
            return cc;
        }
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            if (cd.classDef().isMember() && !cd.classDef().flags().isStatic()) {
                cd.classDef().flags(cd.classDef().flags().Static());
                Flags f2 = cd.classDef().flags();
                cd = cd.flags(cd.flags().flags(f2));
                ClassType ct = (ClassType)Types.get(cd.classDef().container());
                FieldDef fi = this.boxThis(cd.classDef(), (ClassDef)ct.def());
                cd = InnerClassRemover.addFieldsToClass(cd, Collections.singletonList(fi), this.ts, this.nf, true);
                cd = this.fixQualifiers(cd);
            }
            return cd;
        }
        return n;
    }

    public ClassDecl fixQualifiers(ClassDecl cd) {
        return (ClassDecl)cd.visitChildren(new NodeVisitor(){
            LocalDef li;

            public Node override(Node parent, Node n) {
                if (n instanceof ClassBody) {
                    return null;
                }
                if (n instanceof ConstructorDecl) {
                    return null;
                }
                if (parent instanceof ConstructorDecl && n instanceof Formal) {
                    Formal f = (Formal)n;
                    LocalDef li = f.localDef();
                    if (li.name().equals(OUTER_FIELD_NAME)) {
                        this.li = li;
                    }
                    return n;
                }
                if (parent instanceof ConstructorDecl && n instanceof Block) {
                    return null;
                }
                if (parent instanceof Block && n instanceof ConstructorCall) {
                    return null;
                }
                if (parent instanceof ConstructorCall) {
                    return null;
                }
                return n;
            }

            public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
                if (parent instanceof ConstructorCall && this.li != null && n instanceof Expr) {
                    return InnerClassRemover.this.fixQualifier((Expr)n, this.li);
                }
                return n;
            }
        });
    }

    public Expr fixQualifier(Expr e, final LocalDef li) {
        return (Expr)e.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                Special s;
                Expr f;
                if (n instanceof Field && (f = (Field)n).target() instanceof Special && (s = (Special)f.target()).kind() == Special.THIS && f.name().id().equals(OUTER_FIELD_NAME)) {
                    Local l = InnerClassRemover.this.nf.Local(n.position(), f.name());
                    l = l.localInstance(li.asInstance());
                    l = (Local)l.type(li.asInstance().type());
                    return l;
                }
                if (n instanceof FieldAssign && (f = (FieldAssign)n).target() instanceof Special && (s = (Special)f.target()).kind() == Special.THIS && f.name().id().equals(OUTER_FIELD_NAME)) {
                    Local l = InnerClassRemover.this.nf.Local(n.position(), f.name());
                    l = l.localInstance(li.asInstance());
                    l = (Local)l.type(li.asInstance().type());
                    return l;
                }
                return n;
            }
        });
    }

    public static ClassDecl addFieldsToClass(ClassDecl cd, List<FieldDef> newFields, TypeSystem ts, NodeFactory nf, boolean rewriteMembers) {
        if (newFields.isEmpty()) {
            return cd;
        }
        ClassBody b = cd.body();
        ArrayList<ClassMember> newMembers = new ArrayList<ClassMember>();
        for (FieldDef fi : newFields) {
            Position pos = fi.position();
            FieldDecl fd = nf.FieldDecl(pos, nf.FlagsNode(pos, fi.flags()), nf.CanonicalTypeNode(pos, fi.type()), nf.Id(pos, fi.name()));
            fd = fd.fieldDef(fi);
            newMembers.add(fd);
        }
        for (ClassMember m : b.members()) {
            if (m instanceof ConstructorDecl) {
                ConstructorDecl td = (ConstructorDecl)m;
                ArrayList<Formal> formals = new ArrayList<Formal>();
                ArrayList<LocalDef> locals = new ArrayList<LocalDef>();
                for (FieldDef fi : newFields) {
                    Position pos = fi.position();
                    LocalDef li = ts.localDef(pos, Flags.FINAL, fi.type(), fi.name());
                    li.setNotConstant();
                    Formal formal = nf.Formal(pos, nf.FlagsNode(pos, li.flags()), nf.CanonicalTypeNode(pos, li.type()), nf.Id(pos, li.name()));
                    formal = formal.localDef(li);
                    formals.add(formal);
                    locals.add(li);
                }
                ArrayList<Formal> newFormals = new ArrayList<Formal>();
                newFormals.addAll(formals);
                newFormals.addAll(td.formals());
                td = td.formals(newFormals);
                ArrayList<Stmt> statements = new ArrayList<Stmt>();
                for (int j = 0; j < newFields.size(); ++j) {
                    FieldDef fi = newFields.get(j);
                    LocalDef li = ((Formal)formals.get(j)).localDef();
                    Position pos = fi.position();
                    Local l = nf.Local(pos, nf.Id(pos, li.name()));
                    l = (Local)l.type(li.asInstance().type());
                    l = l.localInstance(li.asInstance());
                    FieldAssign a = nf.FieldAssign(pos, nf.This(pos).type(fi.asInstance().container()), nf.Id(pos, fi.name()), Assign.ASSIGN, l);
                    a = (FieldAssign)a.type(fi.asInstance().type());
                    a = a.fieldInstance(fi.asInstance());
                    a = a.targetImplicit(false);
                    Eval e = nf.Eval(pos, a);
                    statements.add(e);
                }
                Block block = td.body();
                if (block.statements().size() > 0) {
                    Stmt s0 = block.statements().get(0);
                    if (s0 instanceof ConstructorCall) {
                        ConstructorCall cc = (ConstructorCall)s0;
                        ConstructorInstance ci = cc.constructorInstance();
                        if (cc.kind() == ConstructorCall.THIS) {
                            ArrayList<Expr> arguments = new ArrayList<Expr>();
                            for (Stmt si : statements) {
                                Eval e = (Eval)si;
                                Assign a = (Assign)e.expr();
                                arguments.add(a.right());
                            }
                            ArrayList<Type> newFormalTypes = new ArrayList<Type>();
                            for (int j = 0; j < newFields.size(); ++j) {
                                FieldDef fi = newFields.get(j);
                                newFormalTypes.add(fi.asInstance().type());
                            }
                            newFormalTypes.addAll(ci.formalTypes());
                            ci = ci.formalTypes(newFormalTypes);
                            cc = cc.constructorInstance(ci);
                            arguments.addAll(cc.arguments());
                            cc = (ConstructorCall)cc.arguments(arguments);
                        }
                        statements.add(0, cc);
                    }
                    statements.addAll(block.statements().subList(1, block.statements().size()));
                } else {
                    statements.addAll(block.statements());
                }
                block = block.statements(statements);
                td = (ConstructorDecl)td.body(block);
                newMembers.add(td);
                ArrayList<Ref<? extends Type>> newFormalTypes = new ArrayList<Ref<? extends Type>>();
                for (Formal f : newFormals) {
                    newFormalTypes.add(f.type().typeRef());
                }
                ConstructorDef ci = td.constructorDef();
                ci.setFormalTypes(newFormalTypes);
                continue;
            }
            newMembers.add(m);
        }
        b = b.members(newMembers);
        return cd.body(b);
    }

    List<Expr> addArgs(ProcedureCall n, ConstructorInstance nci, Expr q) {
        if (nci == null || q == null) {
            return n.arguments();
        }
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(q);
        args.addAll(n.arguments());
        assert (args.size() == nci.formalTypes().size());
        return args;
    }

    protected FieldDef boxThis(ClassDef currClass, ClassDef outerClass) {
        FieldDef fi = this.outerFieldInstance.get(currClass);
        if (fi != null) {
            return fi;
        }
        Position pos = outerClass.position();
        fi = this.ts.fieldDef(pos, Types.ref(currClass.asType()), Flags.FINAL.Private(), Types.ref(outerClass.asType()), OUTER_FIELD_NAME);
        fi.setNotConstant();
        currClass.addField(fi);
        this.outerFieldInstance.put(currClass, fi);
        return fi;
    }

    public static Object hashGet(Map map, Object k, Object v) {
        return LocalClassRemover.hashGet(map, k, v);
    }
}

