/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.ContextVisitor;
import polyglot.visit.InnerClassRemover;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClassRemover
extends ContextVisitor {
    Map<Pair<LocalDef, ClassDef>, FieldDef> fieldForLocal = new HashMap<Pair<LocalDef, ClassDef>, FieldDef>();
    Map<ClassDef, List<ClassMember>> orphans = new HashMap<ClassDef, List<ClassMember>>();
    Map<ClassDef, List<FieldDef>> newFields = new HashMap<ClassDef, List<FieldDef>>();
    boolean inConstructorCall;
    Map<FieldDef, LocalDef> localOfField = new HashMap<FieldDef, LocalDef>();

    public LocalClassRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    @Override
    public Node override(Node parent, Node n) {
        if (n instanceof Block) {
            Block b = (Block)n;
            ArrayList<Stmt> ss = new ArrayList<Stmt>(b.statements());
            for (int i = 0; i < ss.size(); ++i) {
                Stmt s = (Stmt)ss.get(i);
                if (s instanceof LocalClassDecl) {
                    s = (Stmt)n.visitChild(s, this);
                    LocalClassDecl lcd = (LocalClassDecl)s;
                    ClassDecl cd = lcd.decl();
                    Flags oldFlags = cd.flags().flags();
                    Flags flags = this.context.inStaticContext() ? oldFlags.Private().Static() : oldFlags.Private();
                    Id name = this.nf.Id(cd.name().position(), UniqueID.newID(cd.name().toString()));
                    cd = cd.name(name);
                    cd = cd.flags(cd.flags().flags(flags));
                    cd.classDef().flags(flags);
                    cd.classDef().kind(ClassDef.MEMBER);
                    cd.classDef().name(cd.name().id());
                    cd = this.renameConstructors(cd, this.nf);
                    cd = this.rewriteLocalClass(cd, LocalClassRemover.hashGet(this.newFields, cd.classDef(), Collections.emptyList()));
                    if (cd != lcd.decl()) {
                        ss.set(i, lcd.decl(cd));
                        for (int j = i; j < ss.size(); ++j) {
                            Stmt sj = (Stmt)ss.get(j);
                            sj = (Stmt)this.rewriteConstructorCalls(sj, cd.classDef(), LocalClassRemover.hashGet(this.newFields, cd.classDef(), Collections.emptyList()));
                            ss.set(j, sj);
                        }
                        lcd = (LocalClassDecl)ss.get(i);
                        cd = lcd.decl();
                    }
                    LocalClassRemover.hashAdd(this.orphans, this.context.currentClassDef(), cd);
                    ss.remove(i);
                    --i;
                    continue;
                }
                s = (Stmt)n.visitChild(s, this);
                ss.set(i, s);
            }
            return b.statements(ss);
        }
        return null;
    }

    private ClassDecl renameConstructors(ClassDecl cd, NodeFactory nf) {
        ClassBody b = cd.body();
        ArrayList<ClassMember> newMembers = new ArrayList<ClassMember>();
        List<ClassMember> members = b.members();
        for (ClassMember m : members) {
            if (m instanceof ConstructorDecl) {
                ConstructorDecl td = (ConstructorDecl)m;
                td = td.name(nf.Id(td.name().position(), cd.name().id()));
                newMembers.add(td.name(cd.name()));
                continue;
            }
            newMembers.add(m);
        }
        return cd.body(b.members(newMembers));
    }

    @Override
    protected NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        LocalClassRemover v = (LocalClassRemover)super.enterCall(parent, n);
        if (n instanceof ConstructorCall && !this.inConstructorCall) {
            v = (LocalClassRemover)v.copy();
            v.inConstructorCall = true;
            return v;
        }
        if ((n instanceof ClassBody || n instanceof CodeNode) && v.inConstructorCall) {
            v = (LocalClassRemover)v.copy();
            v.inConstructorCall = false;
            return v;
        }
        return v;
    }

    protected boolean isLocal(Context c, Name name) {
        return c.isLocal(name);
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        FieldDef fi;
        Local l;
        Context c = this.context();
        Position pos = n.position();
        if (n instanceof Local && !this.inConstructorCall && !this.isLocal(this.context, (l = (Local)n).name().id()) && (fi = this.boxLocal((LocalDef)l.localInstance().def())) != null) {
            Field f = this.nf.Field(pos, this.makeMissingFieldTarget(fi.asInstance(), pos), this.nf.Id(pos, fi.name()));
            f = f.fieldInstance(fi.asInstance());
            f = (Field)f.type(fi.asInstance().type());
            return f;
        }
        if (n instanceof New) {
            ClassType s;
            New neu = (New)n;
            ClassBody body = neu.body();
            if (body == null) {
                return neu;
            }
            TypeNode superClass = neu.objectType();
            List<TypeNode> interfaces = Collections.EMPTY_LIST;
            Type supertype = neu.objectType().type();
            if (supertype instanceof ClassType && (s = (ClassType)supertype).flags().isInterface()) {
                superClass = this.defaultSuperType(pos);
                interfaces = Collections.singletonList(neu.objectType());
            }
            Flags oldFlags = neu.anonType().flags();
            Flags flags = this.context.inStaticContext() ? oldFlags.Private().Static() : oldFlags.Private();
            Id name = this.nf.Id(pos, UniqueID.newID("Anonymous"));
            ClassDecl cd = this.nf.ClassDecl(pos, this.nf.FlagsNode(pos, flags), name, superClass, interfaces, body);
            ClassDef type = neu.anonType();
            type.kind(ClassDef.MEMBER);
            type.name(cd.name().id());
            type.outer(Types.ref(this.context.currentClassDef()));
            type.setPackage(Types.ref(this.context.package_()));
            type.flags(flags);
            cd = cd.classDef(type);
            ConstructorDecl td = this.addConstructor(cd, neu);
            type.addConstructor(td.constructorDef());
            ClassBody b = cd.body();
            ArrayList<ClassMember> members = new ArrayList<ClassMember>();
            members.addAll(b.members());
            members.add(td);
            b = b.members(members);
            cd = cd.body(b);
            neu = neu.constructorInstance(td.constructorDef().asInstance());
            neu = neu.anonType(null);
            if (!flags.isStatic()) {
                neu = neu.qualifier(this.nf.This(pos).type(this.context.currentClass()));
            }
            cd = this.rewriteLocalClass(cd, LocalClassRemover.hashGet(this.newFields, cd.classDef(), Collections.emptyList()));
            LocalClassRemover.hashAdd(this.orphans, this.context.currentClassDef(), cd);
            neu = neu.objectType(this.nf.CanonicalTypeNode(pos, type.asType())).body(null);
            neu = (New)this.rewriteConstructorCalls(neu, cd.classDef(), LocalClassRemover.hashGet(this.newFields, cd.classDef(), Collections.emptyList()));
            return neu;
        }
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            List<ClassMember> o = this.orphans.get(cd.classDef());
            if (o == null) {
                return cd;
            }
            ClassBody b = cd.body();
            ArrayList<ClassMember> members = new ArrayList<ClassMember>();
            members.addAll(b.members());
            members.addAll(o);
            b = b.members(members);
            return cd.body(b);
        }
        return n;
    }

    protected TypeNode defaultSuperType(Position pos) {
        return this.nf.CanonicalTypeNode(pos, this.ts.Object());
    }

    protected ClassDecl rewriteLocalClass(ClassDecl cd, List<FieldDef> newFields) {
        return InnerClassRemover.addFieldsToClass(cd, newFields, this.ts, this.nf, false);
    }

    protected Node rewriteConstructorCalls(Node s, ClassDef ct, List<FieldDef> fields) {
        Node r = s.visit(new ConstructorCallRewriter(fields, ct));
        return r;
    }

    ConstructorDecl addConstructor(ClassDecl cd, New neu) {
        ArrayList<Formal> formals = new ArrayList<Formal>();
        ArrayList<Expr> args = new ArrayList<Expr>();
        ArrayList<Ref<? extends Type>> argTypes = new ArrayList<Ref<? extends Type>>();
        int i = 1;
        for (Expr e : neu.arguments()) {
            Position pos = e.position();
            Id name = this.nf.Id(pos, "a" + i);
            ++i;
            Formal f = this.nf.Formal(pos, this.nf.FlagsNode(pos, Flags.FINAL), this.nf.CanonicalTypeNode(pos, e.type()), name);
            Local l = this.nf.Local(pos, name);
            LocalDef li = this.ts.localDef(pos, f.flags().flags(), f.type().typeRef(), name.id());
            li.setNotConstant();
            f = f.localDef(li);
            l = l.localInstance(li.asInstance());
            l = (Local)l.type(li.asInstance().type());
            formals.add(f);
            args.add(l);
            argTypes.add(li.type());
        }
        Position pos = cd.position();
        ConstructorCall cc = this.nf.SuperCall(pos, args);
        cc = cc.constructorInstance(neu.constructorInstance());
        cc = cc.qualifier(this.adjustQualifier(neu.qualifier()));
        ArrayList<Stmt> statements = new ArrayList<Stmt>();
        statements.add(cc);
        ArrayList<TypeNode> throwTypeNodes = new ArrayList<TypeNode>();
        ArrayList<Ref<? extends Type>> throwTypes = new ArrayList<Ref<? extends Type>>();
        for (Type t : neu.constructorInstance().throwTypes()) {
            Ref<Type> tref = Types.ref(t);
            throwTypes.add(tref);
            throwTypeNodes.add(this.nf.CanonicalTypeNode(pos, tref));
        }
        ConstructorDecl td = this.nf.ConstructorDecl(pos, this.nf.FlagsNode(pos, Flags.PRIVATE), cd.name(), formals, throwTypeNodes, this.nf.Block(pos, statements));
        ConstructorDef ci = this.ts.constructorDef(pos, Types.ref(cd.classDef().asType()), Flags.PRIVATE, argTypes, throwTypes);
        td = td.constructorDef(ci);
        return td;
    }

    private Expr adjustQualifier(Expr e) {
        Special s;
        if (e instanceof Special && (s = (Special)e).kind() == Special.THIS && s.qualifier() == null) {
            return s.qualifier(this.nf.CanonicalTypeNode(s.position(), s.type()));
        }
        return e;
    }

    protected List<Expr> addArgs(ProcedureCall n, ConstructorDef nci, List<FieldDef> fields, ClassDef curr, ClassDef theLocalClass) {
        if (nci == null || fields == null || fields.isEmpty() || n.arguments().size() == nci.formalTypes().size()) {
            return n.arguments();
        }
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (FieldDef fi : fields) {
            if (curr != null && theLocalClass != null && this.ts.isEnclosed(curr, theLocalClass)) {
                Position pos = fi.position();
                Field f = this.nf.Field(pos, this.makeMissingFieldTarget(fi.asInstance(), pos), this.nf.Id(pos, fi.name()));
                f = f.fieldInstance(fi.asInstance());
                f = (Field)f.type(fi.asInstance().type());
                args.add(f);
                continue;
            }
            LocalDef li = this.localOfField.get(fi);
            if (li != null) {
                Local l = this.nf.Local(li.position(), this.nf.Id(li.position(), li.name()));
                l = l.localInstance(li.asInstance());
                l = (Local)l.type(li.asInstance().type());
                args.add(l);
                continue;
            }
            throw new InternalCompilerError("field " + fi + " created with rev map to null", n.position());
        }
        args.addAll(n.arguments());
        assert (args.size() == nci.formalTypes().size());
        return args;
    }

    private FieldDef boxLocal(LocalDef li) {
        ClassDef curr = this.currLocalClass();
        if (curr == null) {
            return null;
        }
        Pair<LocalDef, ClassDef> key = new Pair<LocalDef, ClassDef>(li, curr);
        FieldDef fi = this.fieldForLocal.get(key);
        if (fi != null) {
            return fi;
        }
        Position pos = li.position();
        fi = this.ts.fieldDef(pos, Types.ref(curr.asType()), li.flags().Private(), li.type(), li.name());
        fi.setNotConstant();
        curr.addField(fi);
        List l = LocalClassRemover.hashGet(this.newFields, curr, new ArrayList());
        l.add(fi);
        this.localOfField.put(fi, li);
        this.fieldForLocal.put(key, fi);
        return fi;
    }

    private ClassDef currLocalClass() {
        ClassDef curr = this.context.currentClassDef();
        while (curr != null) {
            if (curr.isLocal() || curr.isAnonymous()) {
                return curr;
            }
            if (curr.isTopLevel()) break;
            curr = Types.get(curr.outer());
        }
        return null;
    }

    protected Receiver makeMissingFieldTarget(FieldInstance fi, Position pos) {
        ClassType scope;
        Context c = this.context();
        Receiver r = fi.flags().isStatic() ? this.nf.CanonicalTypeNode(pos, fi.container()) : (!this.ts.typeEquals(scope = (ClassType)fi.container(), c.currentClass(), this.context) ? this.nf.This(pos.startOf(), this.nf.CanonicalTypeNode(pos, scope)).type(scope) : this.nf.This(pos.startOf()).type(scope));
        return r;
    }

    public static <K, V> V hashGet(Map<K, V> map, K k, V v) {
        V x = map.get(k);
        if (x != null) {
            return x;
        }
        map.put(k, v);
        return v;
    }

    public static <K, V> void hashAdd(Map<K, List<V>> map, K k, V v) {
        List<V> l = map.get(k);
        if (l == null) {
            l = new ArrayList<V>();
            map.put(k, l);
        }
        l.add(v);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConstructorCallRewriter
    extends NodeVisitor {
        protected final List<FieldDef> newFields;
        protected final ClassDef theLocalClass;
        protected ClassDef curr;

        public ConstructorCallRewriter(List<FieldDef> fields, ClassDef ct) {
            this.newFields = fields;
            this.theLocalClass = ct;
        }

        @Override
        public NodeVisitor enter(Node n) {
            if (n instanceof ClassDecl) {
                ConstructorCallRewriter v = (ConstructorCallRewriter)this.copy();
                v.curr = ((ClassDecl)n).classDef();
                return v;
            }
            return this;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            if (n instanceof New) {
                New neu = (New)n;
                ConstructorInstance ci = neu.constructorInstance();
                ConstructorDef nci = (ConstructorDef)ci.def();
                ClassType container = Types.get(nci.container()).toClass();
                if (container.def() == this.theLocalClass) {
                    neu = (New)neu.arguments(LocalClassRemover.this.addArgs(neu, nci, this.newFields, this.curr, this.theLocalClass));
                    if (!this.theLocalClass.flags().isStatic()) {
                        ClassDef outer = Types.get(this.theLocalClass.outer());
                        Expr q = outer == LocalClassRemover.this.context.currentClassDef() ? LocalClassRemover.this.nf.This(neu.position()).type(outer.asType()) : LocalClassRemover.this.nf.This(neu.position(), LocalClassRemover.this.nf.CanonicalTypeNode(neu.position(), outer.asType())).type(outer.asType());
                        neu = neu.qualifier(q);
                    }
                }
                return neu;
            }
            if (n instanceof ConstructorCall) {
                ConstructorCall neu = (ConstructorCall)n;
                ConstructorInstance ci = neu.constructorInstance();
                ConstructorDef nci = (ConstructorDef)ci.def();
                ClassType container = Types.get(nci.container()).toClass();
                if (container.def() == this.theLocalClass) {
                    neu = (ConstructorCall)neu.arguments(LocalClassRemover.this.addArgs(neu, nci, this.newFields, this.curr, this.theLocalClass));
                    if (!this.theLocalClass.flags().isStatic()) {
                        ClassDef outer = Types.get(this.theLocalClass.outer());
                        Expr q = outer == LocalClassRemover.this.context.currentClassDef() ? LocalClassRemover.this.nf.This(neu.position()).type(outer.asType()) : LocalClassRemover.this.nf.This(neu.position(), LocalClassRemover.this.nf.CanonicalTypeNode(neu.position(), outer.asType())).type(outer.asType());
                        neu = neu.qualifier(q);
                    }
                }
                return neu;
            }
            return n;
        }
    }
}

